<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ApplicantModel extends Model
{
    use HasFactory;

    protected $table = 'egc_applicant';
    protected $primaryKey = 'sno';
    public $timestamps = false; // Because created_on & updated_on are custom columns

    protected $fillable = [
        'applicant_id',
        'candidate_id',
        'job_request_id',
        'applicant_name',
        'job_role_id',
        'mobile',
        'alter_mobile',
        'email',
        'gender',
        'qualification_id',
        'major',
        'other_qualification',
        'experience_id',
        'experience_count',
        'drive_data',
        'old_data',
        'source_id',
        'attachment',
        'resume_text',
        'ipaddress',
        'interview_date',
        'status',
        'applicant_status',
        'shortlist_check',
        'ai_response',
        'match_status',
        'match_score',
        'ai_summary',
        'hiring_status',
        'hiring_details',
        'call_status_id',
        'marital_status_id',
        'recruitment_id',
        'recruitment_file',
        'created_by',
        'created_at',
        'updated_by',
        'updated_at',
        'called_by'
    ];

}
