<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BranchModel extends Model {
    use HasFactory;

    protected $table = 'egc_branch'; // Table Name
    protected $primaryKey = 'sno';  // Primary Key
    // public $timestamps = false;     // Disable timestamps if not using Laravel's default created_at & updated_at fields

    protected $fillable = [
        'branch_id','company_id','entity_id', 'branch_type', 'branch_name', 'business_name', 'business_person_name', 'franchise_name', 
        'branch_category', 'branch_department', 'country_id', 'state_id', 'city_id', 'area_street', 
        'door_no', 'city_short_code', 'pincode', 'mobile', 'cre_mobile', 'sales_mobile', 'mail', 
        'comm_email_id', 'min_amnt_receive', 'location', 'website', 'latitude', 'longitude', 
        'gst_no', 'gst_percentage', 'pan_no', 'share_percentage', 'share_start_date', 'share_end_date','social_media_details',
        'opening_date', 'time_zone_id', 'currency_id', 'tax_no', 'collection_close', 
        'registeration_close', 'min_prd_cost', 'min_prd_days', 'min_payment_cost', 
        'min_course_change_days', 'last_payment', 'bank_name', 'bank_branch', 'bank_holder', 
        'bank_account_no', 'bank_ifsc', 'bank_desc', 'branch_desc', 'branch_attachments', 
        'authority_id', 'gst_check', 'fb_link', 'insta_link', 'cre_id', 'sales_id', 'other_src_staff_id','task_working_hours',
        'royal_fee', 'just_dial_id', 'created_by', 'created_at', 'updated_by', 
        'updated_at', 'status', 'staff_cug', 'call_tracker_branch_id','bus_closing_month_end','bus_closing_day_count'
    ];
}
