<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FeedbackQuestionModel extends Model
{
    use HasFactory;
    public $table      = "egc_feedback_question";
    public $primaryKey = 'sno';


    protected $fillable = [
        'feedback_question_id',
        'interview_category_id',
        'feedback_section_id',
        'language_id',
        'question_name',
        'question_type',
        'question_option',
        'created_by',
        'created_at',
        'updated_by',
        'status',
    ];

    public function depends()
    {
        return $this->hasMany(HrQuestionDependsModel::class, 'question_id', 'sno');
    }
}