<?php

namespace App\Models;

use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Cell\DataValidation;
use Carbon\Carbon;

class HolidayExportExcel implements WithHeadings, FromArray, WithEvents
{
    protected $companies = [];

    public function __construct()
    {
        $this->companies = DB::table('egc_company')
            ->where('status', 0)
            ->pluck('company_name')
            ->toArray();
    }

    public function headings(): array
    {
        return [
            'Holiday From Date (YYYY-MM-DD)',
            'Holiday To Date (YYYY-MM-DD)',
            'Holiday Reason',
            'Company',
        ];
    }

    public function array(): array
    {
        $today = Carbon::now()->format('Y-m-d');

        return array_merge(
            [
                // ✅ Dummy reference row
                [
                    $today,
                    $today,
                    'Holiday',
                    'All'
                ]
            ],
            array_fill(0, 99, ['', '', '', ''])
        );
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {

                $sheet = $event->sheet->getDelegate();

                /**
                 * Company dropdown values
                 * Order matters
                 */
                $dropdownValues = [
                    'All',
                    'Elysium Groups'
                ];

                foreach ($this->companies as $company) {
                    $dropdownValues[] = $company;
                }

                $dropdownList = implode(',', $dropdownValues);

                /**
                 * Apply dropdown to Company column
                 */
                for ($row = 2; $row <= 101; $row++) {
                    $validation = $sheet->getCell("D{$row}")->getDataValidation();
                    $validation->setType(DataValidation::TYPE_LIST);
                    $validation->setAllowBlank(false);
                    $validation->setShowDropDown(true);
                    $validation->setFormula1('"' . $dropdownList . '"');
                }

                /**
                 * Column widths
                 */
                $sheet->getColumnDimension('A')->setWidth(25);
                $sheet->getColumnDimension('B')->setWidth(25);
                $sheet->getColumnDimension('C')->setWidth(30);
                $sheet->getColumnDimension('D')->setWidth(40);
            }
        ];
    }
}
