<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HrQuestionDependsModel extends Model
{
    use HasFactory;
    public $table      = "egc_hr_question_depends";
    public $primaryKey = 'sno';


    protected $fillable = [
        'question_id',
        'field_name',
        'field_value',
        'field_option',
        'is_depends',
        'depends_on',
        'is_mandatory',
        'created_by',
        'created_at',
        'status',
    ];

    public function parentQuestion()
    {
        return $this->belongsTo(HrQuestionnaireModel::class, 'question_id', 'sno');
    }
}