<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HrQuestionnaireModel extends Model
{
    use HasFactory;
    public $table      = "egc_hr_questionnaire";
    public $primaryKey = 'sno';


    protected $fillable = [
        'hr_question_id',
        'field_name',
        'field_value',
        'field_option',
        'is_depends',
        'depends_on',
        'is_mandatory',
        'created_by',
        'created_at',
        'status',
    ];

    public function depends()
    {
        return $this->hasMany(HrQuestionDependsModel::class, 'question_id', 'sno');
    }
}