<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IntegrationModel extends Model
{
    use HasFactory;
    public $table      = "egc_api_integration";
    public $primaryKey = 'sno';


    protected $fillable = [
        'api_fields',
        'api_name',
        'api_key',
        'developer_link',
        'image',
        'created_by',
        'created_at',
        'updated_by',
        'updated_at',
        'status',
    ];

    public function depends()
    {
        return $this->hasMany(HrQuestionDependsModel::class, 'question_id', 'sno');
    }
}