<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InterviewQuestionModel extends Model
{
    use HasFactory;
    public $table      = "egc_interview_question";
    public $primaryKey = 'sno';


    protected $fillable = [
        'interview_question_id',
        'interview_category_id',
        'job_role_id',
        'field_name',
        'field_value',
        'field_option',
        'is_depends',
        'allowed_time',
        'retakes',
        'thinking_time',
        'created_by',
        'created_at',
        'updated_by',
        'status',
    ];

    public function depends()
    {
        return $this->hasMany(HrQuestionDependsModel::class, 'question_id', 'sno');
    }
}