<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InterviewScheduleQuestionModel extends Model
{
  use HasFactory;
       protected $table = 'egc_interview_schedule_questions';
    protected $primaryKey = 'sno';
    // public $timestamps = false;

    protected $fillable = [
        'interview_schedule_stage_id',
        'interview_question_id',
        'thinking_time',
        'allowed_time',
        'retakes',
        'status',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by'
    ];

    /* Optional relationship */
    public function stage()
    {
        return $this->belongsTo(
            EgcInterviewScheduleStage::class,
            'interview_schedule_stage_id',
            'sno'
        );
    }

}