<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InterviewScheduleStageModel extends Model
{
  use HasFactory;
   protected $table = 'egc_interview_schedule_stage';
    protected $primaryKey = 'sno';
    // public $timestamps = false;

   protected $fillable = [
        'interview_schedule_id',
        'interview_category_id',
        'stage_order',
        'shortlist_applicant_ids',
        'selected_ids',
        'shareLink',
        'duration_value',
        'duration_unit',
        'interview_time',
        'interview_date',
        'mode',
        'call_confirmation',
        'immediate_notify',
        'status',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by'
    ];

     public function schedule()
    {
        return $this->belongsTo(
            InterviewScheduleModel::class,
            'interview_schedule_id',
            'sno'
        );
    }
}