<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JobConfirmationModel extends Model
{
    use HasFactory;

    protected $table = 'egc_job_confirmations';
    protected $primaryKey = 'sno';
    public $timestamps = false; // Because created_on & updated_on are custom columns

    protected $fillable = [
        'applicant_id',
        'job_request_id',
        'reporting_date',
        'expiry_date',
        'confirmation_link',
        'token',
        'created_by',
        'created_at',
        'updated_by',
        'updated_at',
        'status',
        'email_sent',
        'communication_read',
        'whatsapp_send',
    ];

}
