<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JobRequestModel extends Model
{
    use HasFactory;

    protected $table = 'egc_job_request';
    protected $primaryKey = 'sno';
    public $timestamps = false; // Because created_on & updated_on are custom columns

    protected $fillable = [
        'erp_job_request_id',
        'company_type',
        'company_id',
        'entity_id',
        'branch_id',
        'job_request_id',
        'job_role_name',
        'job_role_id',
        'special_requirements',
        'erp_job_role_id',
        'erp_special_requirements',
        'min_salary',
        'max_salary',
        'vacancy_count',
        'exp_type_ids',
        'experience',
        'closing_date',
        'skill_required',
        'job_description',
        'status',
        'created_by',
        'created_at',
        'updated_by',
        'updated_at',
    ];
    
     public function company()
    {
        return $this->belongsTo(CompanyModel::class, 'company_id', 'sno');
    }
 
    public function entity()
    {
        return $this->belongsTo(ManageEntityModel::class, 'entity_id', 'sno');
    }

}
