<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OnboardingStaffModel extends Model
{
    use HasFactory;

    protected $table = 'egc_onboarding_employee';
    protected $primaryKey = 'sno';

    /**
     * Laravel timestamps are used (created_at, updated_at)
     */
    public $timestamps = true;

    /**
     * Mass assignable fields
     */
    protected $fillable = [

        // References
        'applicant_id',
        'job_request_id',
        'job_confirmation_id',

        // Candidate Info
        'candidate_name',
        'personal_email',
        'mobile',

        // Job Info
        'company_id',
        'entity_id',
        'department_id',
        'division_id',
        'job_role_id',
        'reporting_staff_id',

        // Compensation
        'basic_salary',

        // Dates
        'doj',
        'offer_accepted_at',

        // Onboarding Flow
        'onboarding_step',
        'document_status',

        // Employee Code
        'employee_code',

        // Notes
        'notes',

        // Status & Audit
        'status',
        'created_by',
        'updated_by',
    ];

    /**
     * Cast attributes to native types
     */
    protected $casts = [
        'basic_salary'     => 'decimal:2',
        'doj'              => 'date',
        'offer_accepted_at'=> 'datetime',
        'status'           => 'integer',
    ];

    /* =========================
       RELATIONSHIPS (OPTIONAL)
       ========================= */

    public function applicant()
    {
        return $this->belongsTo(ApplicantModel::class, 'applicant_id', 'sno');
    }

    public function jobRequest()
    {
        return $this->belongsTo(JobRequestModel::class, 'job_request_id', 'sno');
    }

    public function department()
    {
        return $this->belongsTo(DepartmentModel::class, 'department_id', 'sno');
    }

    public function division()
    {
        return $this->belongsTo(DivisionModel::class, 'division_id', 'sno');
    }

    public function jobRole()
    {
        return $this->belongsTo(JobRoleModel::class, 'job_role_id', 'sno');
    }

    public function reportingStaff()
    {
        return $this->belongsTo(StaffModel::class, 'reporting_staff_id', 'sno');
    }
    public function entity()
    {
        return $this->belongsTo(ManageEntityModel::class, 'entity_id', 'sno');
    }
    public function company()
    {
        return $this->belongsTo(CompanyModel::class, 'company_id', 'sno');
    }
}
