<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Support\Facades\DB;
use App\Models\BranchModel;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'user_id',
        'role_id',
        'branch_id',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];

    // Define a relationship to the StaffModel
    public function staff()
    {
        return $this->belongsTo(StaffModel::class, 'user_id', 'sno');
    }
    // Define a relationship to the StaffModel
     public function roledetails()
     {
         return $this->belongsTo(UserRoleModel::class, 'role_id', 'sno');
     }
      public function rolepermisiion()
     {
         return $this->belongsTo(UserRolePermissionModel::class, 'role_id', 'sno');
     }
    public function isOnline()
    {

        return \DB::table('personal_access_tokens')
            ->where('tokenable_id', $this->id)
            ->whereDate('created_at', now()->toDateString())
            ->exists();
    }
    //  public function hasPermission($menuName, $actionName = null, $submenuName = null)
    // {
    //     // Retrieve the permissions data for the user's role
    //     $rolePermissions = (new UserRolePermissionModel())->getPermissionsByRole($this->role_id);

    //     // Decode the JSON permissions data into an associative array
    //     $rolePermissions = json_decode($rolePermissions, true);
    //     // dd($rolePermissions);
    //     // Check if the decoded data is an array
    //     if (!is_array($rolePermissions)) {
    //         throw new \Exception('Permissions data is not an array');
    //     }

    //     foreach ($rolePermissions as $menu) {
    //         if ($menu['menuName'] === $menuName && $menu['menuChecked']) {


    //             // Check if a submenu needs to be checked
    //             if ($submenuName) {
    //                 if ($submenuName && $submenuName === 'Manage Attendance') {
    //                     // Fetch attendance data if the submenu is 'attendance'
    //                     return $this->getStaffNotAttendedToday();
    //                 }
    //                 if ($submenuName && $submenuName === 'Manage Extension Batch') {
    //                     // Fetch attendance data if the submenu is 'attendance'
    //                     return $this->getbatchextension();
    //                 }
    //                 if ($submenuName && $submenuName === 'Manage Outstanding') {
    //                     // Fetch attendance data if the submenu is 'attendance'
    //                     return $this->getOutstandingCount();
    //                 }
    //                 if ($submenuName && $submenuName === 'Manage Old Outstanding') {
    //                     // Fetch attendance data if the submenu is 'attendance'
    //                     return $this->getOldOutstandingCount();
    //                 }
    //                 if ($submenuName && $submenuName === 'Manage Low MPC') {
    //                   // Fetch attendance data if the submenu is 'attendance'
    //                   return $this->getLowMPCCount();
    //                 }
    //                  if ($submenuName && $submenuName === 'Manage Not Started') {
    //                     // Fetch attendance data if the submenu is 'attendance'
    //                     return $this->getNotYetSatrtedCount();
    //                 }
    //                 if ($submenuName && $submenuName === 'Manage Hold') {
    //                     // Fetch attendance data if the submenu is 'attendance'
    //                     return $this->getHoldCustomer();
    //                 }
    //                 if ($submenuName && $submenuName === 'Manage Hold') {
    //                     // Fetch attendance data if the submenu is 'attendance'
    //                     return $this->getExtendedHoldCustomer();
    //                 }
    //                 if ($submenuName && $submenuName === 'Manage Events') {
    //                     // Fetch attendance data if the submenu is 'Event'
    //                     return $this->getEventNotCompletedCount();
    //                 }

    //                 if ($submenuName && $submenuName === 'Manage Drop') {
    //                     // Fetch attendance data if the submenu is 'Customer Drop'
    //                     return $this->customerDropCount();
    //                 }


    //                 if (isset($menu['submenu']) && is_array($menu['submenu'])) {
    //                     foreach ($menu['submenu'] as $submenu) {
    //                         if ($submenu['submenuName'] === $submenuName && $submenu['submenuChecked']) {
    //                             if ($actionName) {
    //                                 if (isset($submenu['actions']) && is_array($submenu['actions'])) {
    //                                     foreach ($submenu['actions'] as $action) {
    //                                         if ($action['actionName'] === $actionName) {
    //                                             return $action['actionChecked'];
    //                                         }
    //                                     }
    //                                 }
    //                             } else {
    //                                 return true; // If no action specified, just check the submenu itself
    //                             }
    //                         }
    //                     }
    //                 }
    //             } else {
    //                 // No submenu, check the main menu actions
    //                 if ($actionName) {
    //                     if (isset($menu['actions']) && is_array($menu['actions'])) {
    //                         foreach ($menu['actions'] as $action) {
    //                             if ($action['actionName'] === $actionName) {
    //                                 return $action['actionChecked'];
    //                             }
    //                         }
    //                     }
    //                 } else {
    //                     return true; // If no action or submenu specified, just check the menu itself
    //                 }
    //             }
    //         }
    //     }

    //     return false;
    // }
    // public function hasPermission($menuName, $actionName = null, $submenuName = null, $subsubmenuName = null)
    // {
    //     // get role permissions
    //     $rolePermissions = (new UserRolePermissionModel())->getPermissionsByRole($this->role_id);
    //     $rolePermissions = json_decode($rolePermissions, true);

    //     if (!is_array($rolePermissions)) {
    //         return false;
    //     }

    //     foreach ($rolePermissions as $menu) {

    //         $menuN = $menu['menuName'] ?? null;
    //         $menuChecked = $menu['menuChecked'] ?? false;

    //         if ($menuN === $menuName && $menuChecked) {

    //             // -------- LEVEL-2 : SUBMENU---------
    //             if ($submenuName) {

    //                 // Special counters (Your old logic)
    //                 if ($submenuName === "Manage Attendance") return $this->getStaffNotAttendedToday();
    //                 if ($submenuName === "Manage Extension Batch") return $this->getbatchextension();
    //                 if ($submenuName === "Manage Outstanding") return $this->getOutstandingCount();
    //                 if ($submenuName === "Manage Old Outstanding") return $this->getOldOutstandingCount();
    //                 if ($submenuName === "Manage Low MPC") return $this->getLowMPCCount();
    //                 if ($submenuName === "Manage Not Started") return $this->getNotYetSatrtedCount();
    //                 if ($submenuName === "Manage Hold") return $this->getHoldCustomer();
    //                 if ($submenuName === "Manage Extended Hold") return $this->getExtendedHoldCustomer();
    //                 if ($submenuName === "Manage Events") return $this->getEventNotCompletedCount();
    //                 if ($submenuName === "Manage Drop") return $this->customerDropCount();

    //                 // Normal submenu permission loop
    //                 if (isset($menu['submenu'])) {
    //                     foreach ($menu['submenu'] as $submenu) {

    //                         $subN = $submenu['submenuName'] ?? null;
    //                         $subChecked = $submenu['submenuChecked'] ?? false;

    //                         if ($subN === $submenuName && $subChecked) {

    //                             // -------- LEVEL-3 : LASTMENU---------
    //                               if ($subsubmenuName && isset($submenu['lastmenu'])) {
    //                                   foreach ($submenu['lastmenu'] as $subsubmenu) {

    //                                       $subsubN = $subsubmenu['lastmenuName'] ?? null;
    //                                       $subsubChecked = $subsubmenu['lastmenuChecked'] ?? false;

    //                                       if ($subsubN === $subsubmenuName && $subsubChecked) {
    //                                           return true;
    //                                       }
    //                                   }
    //                                   return false;
    //                               }


    //                             // No sub-submenu → return submenu permission
    //                             return true;
    //                         }
    //                     }
    //                 }
    //             }

    //             // -------- LEVEL-1: MENU ONLY ---------
    //             return true;
    //         }
    //     }

    //     return false;
    // }
   public function hasPermission($menuName, $submenuName = null, $lastmenuName = null, $actionName = null)
    {
        $rolePermissions = (new UserRolePermissionModel())->getPermissionsByRole($this->role_id);
        $rolePermissions = json_decode($rolePermissions, true);

        if (!is_array($rolePermissions)) {
            \Log::info('Role permissions not an array', ['role_id' => $this->role_id]);
            return false;
        }

        foreach ($rolePermissions as $menu) {
            if (($menu['menuName'] ?? null) === $menuName && ($menu['menuChecked'] ?? 0)) {

                // If only menu level check required
                if (!$submenuName) {
                    return true;
                }

                // Check submenu permissions
                foreach ($menu['submenu'] ?? [] as $submenu) {
                    $submenuChecked = $submenu['submenuChecked'] ?? 1;

                    if (($submenu['submenuName'] ?? null) === $submenuName && $submenuChecked) {

                        // If only submenu level check required
                        if (!$lastmenuName) {
                            return true;
                        }

                        // Check lastmenu permissions
                        foreach ($submenu['lastmenu'] ?? [] as $lastmenu) {
                            $lastmenuChecked = $lastmenu['lastmenuChecked'] ?? 1;

                            if (($lastmenu['lastmenuName'] ?? null) === $lastmenuName && $lastmenuChecked) {

                                // If only lastmenu level check required
                                if (!$actionName) {
                                    return true;
                                }

                                // Check action permissions
                                foreach ($lastmenu['actions'] ?? [] as $action) {
                                    $actionChecked = $action['actionChecked'] ?? 0;
                                    if (($action['actionName'] ?? null) === $actionName && $actionChecked) {
                                        return true;
                                    }
                                }
                                return false; // Action not allowed
                            }
                        }
                        return false; // Lastmenu not found or not allowed
                    }
                }
                return false; // Submenu not found or not allowed
            }
        }
        return false; // Menu not found or not allowed
    }



    public function hasPermissionradio($menuName, $submenuName, $radioValue)
    {
        // Retrieve the permissions data for the user's role
        $rolePermissions = (new UserRolePermissionModel())->getPermissionsByRole($this->role_id);

        // Decode the JSON permissions data into an associative array
        $rolePermissions = json_decode($rolePermissions, true);

        // Check if the decoded data is an array
        if (!is_array($rolePermissions)) {
            throw new \Exception('Permissions data is not an array');
        }

        foreach ($rolePermissions as $menu) {
            if ($menu['menuName'] === $menuName && $menu['menuChecked']) {
                if (isset($menu['submenu']) && is_array($menu['submenu'])) {
                    foreach ($menu['submenu'] as $submenu) {
                        if ($submenu['submenuName'] === $submenuName && $submenu['submenuChecked']) {
                            if (isset($submenu['radios']) && is_array($submenu['radios'])) {
                                foreach ($submenu['radios'] as $radio) {
                                    if ($radio['radioValue'] === $radioValue && $radio['checked'] == 1) {
                                        return true; // Permission found
                                    }
                                }
                            }
                        }
                    }
                }


            }
        }

        return false; // Permission not found
    }
    public function getStaffNotAttendedToday()
    {
        // dd($this);
        // Get today's date
        $today = today();
        $branchId =  Auth::user()->branch_id; // Calling the getBranchId method inside this method
        // dd($branchId);  // This will show the branch_id

        // Query to find staff who are not present today
        $staffNotAttendedCount = DB::table('za_staff')
            ->where('status', 0)
            ->where('branch_id', $branchId)
             ->where('za_staff.position_role','!=' ,49)
            ->whereNotIn('sno', function ($query) use ($today) {
                $query->select('staff_id')
                    ->from('za_staff_attendance')
                    ->where('date', $today);
                // Use the correct branch_id
            })
            ->count();

        return ['balance_attendance_count' => $staffNotAttendedCount];
    }
    public function getbatchextension()
    {
        // dd($this);
        // Get today's date
        $branchId =  Auth::user()->branch_id; // Calling the getBranchId method inside this method
        // dd($branchId);  // This will show the branch_id

        // Query to find staff who are not present today
        $batchextensionCount = DB::table('za_batch_extension')
            ->where('status', 0)
            ->where('branch_id', $branchId)
            ->count();

        return ['batch_extension_count' => $batchextensionCount];
    }
    public function getOutstandingCount()
    {

        $branchId = Auth::user()->branch_id;

        $drop_ids = DB::table('za_drop_refund')
            ->join('za_training', 'za_drop_refund.training_id', '=', 'za_training.sno')
            ->where('za_drop_refund.bh_status', 1)
            ->where('za_drop_refund.branch_id', $branchId)
            ->pluck('za_training.customer_id');

        // Get the current date
        $currentDate = now()->subDay()->toDateString();

        $OutstandingPayment = DB::table('za_payment')->where('za_payment.branch_id', $branchId)
            ->join('za_customer', 'za_payment.customer_id', '=', 'za_customer.sno')
            ->join('za_course', 'za_payment.course_id', '=', 'za_course.sno')
            ->whereNotIn('za_payment.customer_id', $drop_ids)
            ->where('za_payment.status', 0)
            ->where('za_payment.amount', '>',0)
            ->where('za_customer.status', 0)
            ->whereDate('za_payment.nextPayDate', '<=', $currentDate)
            ->orderBy('za_payment.sno', 'asc')
            ->count();

         $OutstandingPaymentss = DB::table('za_payment')
            ->join('za_customer', 'za_payment.customer_id', '=', 'za_customer.sno')
            ->leftJoin('za_course', 'za_payment.course_id', '=', 'za_course.sno')
            ->join('za_training', 'za_training.payment_id', '=', 'za_payment.payment_id')
            ->where('za_payment.branch_id', $branchId)
            ->whereNotIn('za_payment.customer_id', $drop_ids)
            ->where('za_payment.status', 0)
            ->where('za_payment.amount', '>', 0)
            ->where('za_customer.status', 0)
            ->whereDate('za_payment.nextPayDate', '<=', $currentDate)
            ->select('za_training.training_id')
            ->groupBy('za_training.training_id')
            ->orderBy('za_payment.nextPayDate', 'DESC')
            ->get();
       $OutstandingPayment = $OutstandingPaymentss->count();
         // Get the total count of records

        return ['OutstandingPaymentCount' => $OutstandingPayment];
    }
    public function getOldOutstandingCount()
    {

        $branchId = Auth::user()->branch_id;

        $drop_ids = DB::table('za_drop_refund')
            ->join('za_training', 'za_drop_refund.training_id', '=', 'za_training.sno')
            ->where('za_drop_refund.bh_status', 1)
            ->where('za_drop_refund.branch_id', $branchId)
            ->pluck('za_training.payment_id');

        // Get the current date
        $currentDate = now()->toDateString();

        $OutstandingPayment = DB::table('za_old_payments')->where('za_old_payments.branch_id', $branchId)
        ->join('za_old_customer', 'za_old_payments.customer_id', '=', 'za_old_customer.sno')
        ->join('za_course', 'za_old_payments.course_id', '=', 'za_course.sno')
        ->where('za_old_payments.status', 0)
        // ->where('za_old_payments.amount', '>',0)
        ->whereIn('za_old_customer.status', [1, 4])
        ->whereDate('za_old_payments.schedule_date', '<=', $currentDate)
        ->orderBy('za_old_payments.schedule_date', 'DESC')
        ->count();
        // Get the total count of records

        return ['OldOutstandingPaymentCount' => $OutstandingPayment];
    }
    public function customerDropCount(){
         $branch_id = Auth::user()->branch_id;
         $customerDropCount = DropRefundModel::where('type',0)->where('bh_status',0)->where('branch_id',$branch_id)->count();

          return ['customerDropCount' => $customerDropCount];
    }

    public function getLowMPCCount()
    {
        $branch_id = Auth::user()->branch_id;
        // $page = $request->input('page', 1);
        // $perPage = (int) $request->input('sorting_filter', 25);
        // $offset = ($page - 1) * $perPage;
     // Get branch details
      $branch = BranchModel::where('sno', $branch_id)
          ->where('status', 0)
          ->orderBy('sno', 'desc')
          ->first();

      // Handle case where no branch is found
      if (!$branch) {
          return redirect()->back()->with('error', 'Branch not found.');
      }
        // Get the current date
        $currentDate = now()->toDateString(); // Get the date in 'YYYY-MM-DD' format
        $drop_ids = DB::table('za_drop_refund')
          ->join('za_training', 'za_drop_refund.training_id', '=', 'za_training.sno')
          ->where('za_drop_refund.bh_status', 1)
          ->pluck('za_training.customer_id');

        // Sum of the amounts
        $sumScheduleAmount = DB::table('za_payment')
            ->where('za_payment.branch_id', $branch_id)
            ->sum('za_payment.amount');

        $sumBalanceFee = DB::table('za_payment')
            ->where('za_payment.branch_id', $branch_id)
            ->sum('za_payment.balanceFee');
     $min = $branch->min_prd_cost;
        // Retrieve payments for the given branch and group by customer and course with aggregation
      $PaidUnderPayment = DB::table('za_training')
          ->join('za_customer', 'za_training.customer_id', '=', 'za_customer.sno')
          ->join('za_course', 'za_training.course_id', '=', 'za_course.sno')
          ->join('za_payment', 'za_payment.payment_id', '=', 'za_training.payment_id')
          ->join('za_lead', 'za_customer.lead_id', '=', 'za_lead.sno')
          ->leftJoin('za_staff', 'za_lead.created_by', '=', 'za_staff.sno')
          ->select(
              'za_customer.customer_id',
              'za_payment.course_id',
              'za_customer.sno as customer_sno',
              'za_course.sno as course_sno',
              'za_customer.cus_name',
              'za_customer.cus_gender',
              'za_customer.cus_pic',
              'za_customer.cus_mobile',
              'za_customer.cus_email_id',
              'za_course.course_name',
              'za_staff.staff_name',
              'za_training.training_id',
              'za_training.batch_id',
              'za_training.payment_id',
              'za_payment.initialPayDate',
              'za_training.paid_amount as total_paid_amount',
             'za_training.balance_amount as total_balance_fee',
             'za_training.overall_fees as total_amount',
              DB::raw('SUM(za_payment.gst_amount) as total_gst_amount'),
              'za_payment.payment_mode_label',
              'za_payment.nextPayDate'
          )
          ->where('za_payment.branch_id', $branch_id)
           ->whereNotIn('za_customer.sno', $drop_ids)
          ->where('za_training.status', '!=',2)
          //   ->where('za_training.balance_amount', '!=',0)
            ->where(function ($q) use ($min) {
                $q->where('za_training.overall_fees', '>', $min)
                  ->orWhere(function ($q2) use ($min) {
                      $q2->where('za_training.overall_fees', '<=', $min)
                         ->whereColumn('za_training.overall_fees', '!=', 'za_training.paid_amount');
                  });
            })
          ->groupBy(
              'za_customer.customer_id',
              'za_customer.sno',
              'za_course.sno',
              'za_customer.cus_name',
              'za_customer.cus_mobile',
              'za_customer.cus_pic',
              'za_customer.cus_gender',
              'za_customer.cus_email_id',
              'za_course.course_name',
              'za_training.training_id',
              'za_training.payment_id',
               'za_staff.staff_name',
                'za_training.batch_id',
               'za_training.paid_amount',
             'za_training.balance_amount',
             'za_training.overall_fees',
              'za_payment.payment_mode_label',
              'za_payment.nextPayDate',
              'za_payment.initialPayDate',
              'za_payment.course_id'
          )
        //   ->orderByDesc('za_payment.sno')
        ->orderBy('za_payment.nextPayDate', 'asc')
          ->get()
          ->unique('payment_id'); // Keep only unique customer records;
      //   return $PaidUnderPayment;
      // Filter the results for customers with unpaid or insufficient amounts (below min_required)
      $result = $PaidUnderPayment->filter(function ($payment) use ($branch) {
          return $payment->total_paid_amount < $branch->min_prd_cost;
      });


      // Group by customer_id
      $finalResult = $result->groupBy('customer_id')->map(function ($payments) use ($branch) {
          // Filter payments where paidAmount is greater than 0
          $filteredPayments = $payments->filter(function ($payment) {
              return $payment->total_paid_amount > 0;
          });

          // If no valid payments exist after filtering, exclude this customer
          if ($filteredPayments->isEmpty()) {
              return null;
          }

          $payment = $payments->first();
          // Return structured data for each customer
          return [
              'customer_name' => $payment->cus_name,
              'customer_sno' => $payment->customer_sno,
              'total_paid' => $payment->total_paid_amount,
              'min_required' => $branch->min_prd_cost,
              'status' => 'Pending',
              'payments' => $filteredPayments->sortBy('nextPayDate')->map(function ($payment) {
                  return [
                      'course_name' => $payment->course_name,
                      'cus_gender' => $payment->cus_gender,
                      'cus_pic' => $payment->cus_pic,
                      'staff_name' => $payment->staff_name,
                      'batch_id' => $payment->batch_id,
                      'training_id' => $payment->training_id,
                      'payment_id' => $payment->payment_id,
                      'cus_name' => $payment->cus_name,
                      'cus_mobile' => $payment->cus_mobile,
                      'amount' => $payment->total_amount,
                      'paidAmount' => $payment->total_paid_amount,
                      'balanceFee' => $payment->total_balance_fee,
                      'gst_amount' => $payment->total_gst_amount,
                      'nextPayDate' => $payment->nextPayDate,
                      'initialPayDate' => $payment->initialPayDate,
                      'payment_mode_label' => $payment->payment_mode_label,
                  ];
              })->values(), // Reset array keys
          ];
      })->filter();

        // Paginate the results
        //   $paginatedResult = $finalResult->slice(($page - 1) * $perPage, $perPage);

        // Calculate the total number of pages
        $totalItems = $finalResult->count();
        // $totalPages = ceil($totalItems / $perPage);


        return ['LowMPCPaymentCount' => $totalItems];

    }
    public function getNotYetSatrtedCount()
    {

        $branchId = Auth::user()->branch_id;

         $batch_Data = DB::table('za_training')
        ->select('za_training.customer_id', 'za_training.status', 'za_training.start_date')
        ->join('za_customer', 'za_customer.sno', '=', 'za_training.customer_id')
        // ->whereNotNull('za_training.start_date')
         ->where('za_training.branch_id',$branchId)
        ->where('za_customer.status',0)
        // ->groupBy('za_training.customer_id', 'za_training.status', 'za_training.start_date')
        ->get();
       $drop_ids = DB::table('za_drop_refund')
        ->join('za_training', 'za_drop_refund.training_id', '=', 'za_training.sno')
        ->where('za_drop_refund.bh_status', 1)
        ->pluck('za_training.customer_id');

        $dropCount = 0;
        $activeCount = 0;
        $notYetStartedCount = 0;
        $scheduleCount = 0;

        $processed_drop_customers = [];
        $processed_active_customers = [];
        $processed_schedule_customers = [];
        $processed_not_started_customers = [];

        foreach ($batch_Data as $singledata) {
            if (in_array($singledata->customer_id, $processed_drop_customers)) {
                continue;
            }
            if ($singledata->status == "2") {
                $dropCount++;
                $processed_drop_customers[] = $singledata->customer_id;
            }
        }

        $batch_active_Data = DB::table('za_training')
        ->select('za_training.customer_id', 'za_training.status', 'za_training.start_date')
        ->join('za_customer', 'za_customer.sno', '=', 'za_training.customer_id')
        ->whereNotNull('za_training.start_date')
         ->where('za_training.branch_id',$branchId)
        ->where('za_customer.status',0)
        ->whereNotIn('za_customer.sno', $drop_ids)
        ->groupBy('za_training.customer_id', 'za_training.status', 'za_training.start_date')
        ->get();


        foreach ($batch_active_Data as $singledata) {
            if( !in_array($singledata->customer_id, $processed_drop_customers)){
                if (in_array($singledata->customer_id, $processed_active_customers)) {
                    continue;
                }
                if ($singledata->start_date <= \Carbon\Carbon::today()->startOfDay()) {
                    $activeCount++;
                    $processed_active_customers[] = $singledata->customer_id;
                }
            }
        }


          $batch_Data_old = DB::table('za_training')
          ->select('za_training.customer_id', 'za_training.status', 'za_training.start_date')
          ->join('za_customer', 'za_customer.sno', '=', 'za_training.customer_id')
          ->where('za_training.branch_id',$branchId)
          ->where('za_customer.status',0)
          ->whereNotIn('za_customer.sno', $drop_ids)
          ->groupBy('za_training.customer_id', 'za_training.status', 'za_training.start_date')
          ->get();


          // return  $processed_active_customers;
          foreach ($batch_Data_old as $singledata) {

                  if( !in_array($singledata->customer_id, $processed_drop_customers)){
                      if( !in_array($singledata->customer_id, $processed_active_customers)){
                          if (in_array($singledata->customer_id, $processed_schedule_customers)) {
                              continue;
                          }
                          if($singledata->start_date > \Carbon\Carbon::today()->startOfDay()){
                            $scheduleCount ++;
                            $processed_schedule_customers [] = $singledata->customer_id;
                          }
                      }
                  }

          }
        // return $processed_schedule_customers;


        $batch_notyetStated = DB::table('za_training')
        ->select('za_training.customer_id', 'za_training.status', 'za_training.start_date')
        ->join('za_customer', 'za_customer.sno', '=', 'za_training.customer_id')
        ->where('za_training.branch_id',$branchId)
        ->where('za_customer.status',0)
        ->whereNotIn('za_customer.sno', $drop_ids)
        ->groupBy('za_training.customer_id', 'za_training.status', 'za_training.start_date')
        ->get();

        foreach ($batch_notyetStated as $singledata) {

          if( !in_array($singledata->customer_id, $processed_drop_customers)){
              if( !in_array($singledata->customer_id, $processed_active_customers)){
                if( !in_array($singledata->customer_id, $processed_schedule_customers)){
                  if (in_array($singledata->customer_id, $processed_not_started_customers)) {
                      continue;
                  }
                if ($singledata->start_date === null) {
                      $notYetStartedCount++;
                      $processed_not_started_customers[] = $singledata->customer_id;
                  }
              }
            }
          }

        }

    // return  $notYetStartedCount;
        // Get the total count of records

        return ['NotYetStartedCustomerCount' => $notYetStartedCount];
    }

    public function getHoldCustomer()
    {
        // dd($this);
        // Get today's date
        $branchId =  Auth::user()->branch_id; // Calling the getBranchId method inside this method
        // dd($branchId);  // This will show the branch_id

        // Query to find staff who are not present today
        $totalHoldCount = DB::table('za_cus_hold_history')
            ->where('status', 0)
            ->where('branch_id', $branchId)
            ->count();

        return ['total_hold_count' => $totalHoldCount];
    }

    public function getExtendedHoldCustomer()
    {
        // dd($this);
        // Get today's date
        $branchId =  Auth::user()->branch_id; // Calling the getBranchId method inside this method
        // dd($branchId);  // This will show the branch_id
        $currentDate = Carbon::today()->toDateString(); // 2025-04-30
        // Query to find staff who are not present today
        $extendedHoldCount = DB::table('za_cus_hold_history')
            ->where('status', 0)
            ->where('hold_end_date', '<', $currentDate)
            ->where('branch_id', $branchId)
            ->count();

        return ['extended_hold_count' => $extendedHoldCount];
    }

     public function getEventNotCompletedCount()
    {
          $roleId =  Auth::user()->role_id;
          $branchId =  Auth::user()->branch_id;
        // Query to find staff who are not present today
        $eventNotCompletedCount = DB::table('za_event')
            ->whereNotIn('status', [4,3,2])
            ->where('attendance_status', 0);
            if($roleId != 1 && $roleId != 9){
             $eventNotCompletedCount->where('branch_id', $branchId);
            }else{
                $eventNotCompletedCount->where('branch_id','!=',1);
            }
           $eventNotCompletedCount =$eventNotCompletedCount->count();

        return ['eventNotCompletedCount' => $eventNotCompletedCount];
    }

}
