<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserRolePermissionModel extends Model
{
    use HasFactory;
    public $table = "egc_user_role_permission";
    public $primaryKey = 'sno';

    protected $fillable = [
        'branch_id',
        'role_id',
        'permission',
        'created_by',
        'created_at',
        'status',
    ];

    public function getPermissionsByRole($role_id)
    {
        $permissions = UserRolePermissionModel::where('role_id', $role_id)->first();
        // dd($permissions);


        return $permissions ? json_decode($permissions->permissions, true) : [];
    }
}