<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class WebhookDispatchModel extends Model {
    protected $table = 'egc_webhook_dispatches';
    protected $primaryKey = 'sno';
    public $incrementing = true;
    protected $keyType = 'int';
    public $timestamps = true;

    protected $fillable = [
        'sub_erp_webhook_sno','dispatchable_type','dispatchable_id','message_uuid',
        'payload','status','attempts','last_attempt_at','next_attempt_at','http_status','last_response','created_by','updated_by'
    ];

    protected $casts = [
        'payload' => 'array',
        'attempts' => 'integer',
        'next_attempt_at' => 'datetime',
        'last_attempt_at' => 'datetime',
        'status' => 'integer',
    ];

    public function webhook()
    {
        return $this->belongsTo(SubErpWebhookModel::class, 'sub_erp_webhook_sno', 'sno');
    }

    public function attemptLogs()
    {
        return $this->hasMany(WebhookDispatchAttemptModel::class, 'webhook_dispatch_sno', 'sno');
    }

   
}
