@extends('layouts/layoutMaster')
@section('style')
@section('title', 'Exam badge')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/select2/select2.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
    @vite(['resources/assets/vendor/libs/select2/select2.js'])
@endsection

@section('content')

    <style>
        .credential-wrapper {
            min-height: 70vh;
        }

        /* Sidebar */
        .tab-sidebar {
             width: 250px;
            transition: all 0.3s ease;
            background: #fff;
            border-left: 1px solid #ddd;
        }

        .tab-sidebar.collapsed {
            width: 60px;
        }

        .tab-sidebar .nav-link {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px;
        }

        .tab-sidebar .nav-link i {
            font-size: 22px;
        }

        .nav-align-sideright .nav-link.active > label {
            background-color: #cfcfcf;
            color: #000;
            padding: 5px 8px;
            border-radius: 5px;
        }

        .tab-sidebar ul{
            /* align-items: end; */
        }
        

        /* Hide text when collapsed */
        .tab-sidebar.collapsed .tab-text {
            display: none;
        }
        .tab-sidebar.collapsed ul {
            align-items: center;
        }

        /* Toggle button */
        .toggle-btn {
            position: absolute;
            top: 15px;
            right: -15px;
            z-index: 10;
            background: #ab2b22;
            color: #fff;
            border: none;
            width: 30px;
            height: 30px;
            border-radius: 50%;
        }

        /* When sidebar collapsed */
        .tab-sidebar.collapsed + .tab-content .toggle-btn {
            right: -15px;
        }

        .tab-sidebar .right_nav{
            cursor:pointer !important;
            width:100%;
            display:flex;
            justify-content:end;
             align-items:center;
              gap:4px;
        }

        .tab-sidebar .right_nav:hover{
            color:#ab2b22 !important;
        }
    </style>

    <!-- Users List Table -->
    <div class="card">
        <div class="card-header pb-1">
            <ul class="nav nav-tabs flex-nowrap" role="tablist">
                <div class="scroll-container-wrapper">
                    <button class="scroll-btn left" id="scrollLeftBtn"><span class="scroll-arrow"><i
                                class="mdi mdi-chevron-left fs-2 text-white"></i></span></button>
                                
                    <div class="scroll-container" id="scrollContainer">
                        <li class="item nav-item">
                            <a href="{{ url('/settings/general_settings') }}"
                                type="button"
                                class="nav-link scroll-link "
                                role="tab">
                                General Settings
                            </a>
                        </li>        
                        <li class="item nav-item">
                            <a
                                href="{{ url('/settings/broadcast_theme') }}"
                                type="button"
                                class="nav-link scroll-link"
                                aria-selected="true">
                                Common
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/credential_book') }}" type="button"
                                class="nav-link scroll-link ">
                                Entity
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/document') }}" type="button" class="nav-link scroll-link ">
                                HRM
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/applicant_status') }}" type="button"
                                class="nav-link scroll-link ">
                                Recruitment
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/interview_mode') }}" type="button"
                                class="nav-link scroll-link">
                                Interview
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/assessment/guidelines') }}" type="button"
                                class="nav-link scroll-link active">
                                Assessment
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/department') }}" type="button"
                                class="nav-link scroll-link ">
                                Management
                            </a>
                        </li>
                        <li class="nav-item">
                                <a href="{{ url('/settings/business/department') }}" type="button"
                                    class="nav-link scroll-link ">
                                    Business
                                </a>
                            </li>

                        <li class="nav-item">
                            <a href="{{ url('/settings/api_config') }}" type="button"
                                class="nav-link scroll-link ">
                                API Config
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/admin/webhooks') }}" type="button"
                                class="nav-link scroll-link ">
                                Webhook Moniter
                            </a>
                        </li>
                    </div>
                    <button class="scroll-btn right" id="scrollRightBtn" style="display: block;"><i
                            class="mdi mdi-chevron-right fs-2 text-white"></i></button>
                </div>
            </ul>
        </div>
        <div class="card-body px-1 py-1">
            <div class="d-flex credential-wrapper">
                <!-- CONTENT -->
                <div class="tab-content flex-grow-1 position-relative">
                    <!-- Toggle Button -->
                    <button id="toggleSidebarSetting" class="toggle-btn toggle-right">
                        <i class="mdi mdi-chevron-right"></i>
                    </button>
                    <div class="d-flex align-items-center justify-content-between pb-0 mb-4 pt-0 mt-0" style="border-bottom: 1px solid gray;">
                        <div class="d-flex flex-column align-items-start">
                            <h5 class="card-title mb-1 text-black">Exam Badge</h5>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb custom-breadcrumb">
                                    <!-- Home -->
                                    <li class="breadcrumb-item">
                                        <a href="{{ url('/dashboard') }}">
                                            <i class="mdi mdi-cog"></i> Settings
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item" aria-current="page">
                                        <a href="javascript:void(0);">Assessment </a>
                                    </li>
                                    <li class="breadcrumb-item active" aria-current="page">
                                        <a href="javascript:void(0);" class="active-link">
                                            Exam Badge
                                        </a>
                                    </li>
                                </ol>
                            </nav>
                        </div>
                        <div class="d-flex justify-content-end align-items-center mb-2 gap-2">
                            <a href="#" class="btn btn-sm fw-bold btn-primary" data-bs-toggle="modal"
                                data-bs-target="#kt_modal_add_exam_badge">
                                <span class="me-2"><i class="mdi mdi-plus"></i></span>Add Exam Badge
                            </a>
                        </div>
                    </div>        
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="d-flex align-items-center justify-content-between mb-4 ">
                                <div>
                                    <span>Show</span>
                                    <select id="perpage" class="form-select form-select-sm w-75px"
                                        onchange="loadThemes(1)">
                                        @php $options = [5,10, 25, 100, 500]; @endphp
                                        @foreach ($options as $option)
                                            <option value="{{ $option }}" {{ $perpage == $option ? 'selected' : '' }}>
                                                {{ $option }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="d-flex align-items-center justify-content-end flex-wrap gap-2">
                                    <div class="searchBar">
                                        <input type="text" id="search_filter" class="searchQueryInput"
                                            placeholder="Search Exam Badge"
                                            value="{{ $search_filter }}"/>
                                        
                                        <div class="searchAction">
                                            <div class="d-flex align-items-center">
                                                <a href="javascript:;"  class="searchSubmit" id="searchSubmit" >
                                                    <span class="mdi mdi-magnify fs-4 fw-bold"  style="color:#ab2b22;"></span>
                                                </a>
                                                <a href="javascript:;" class="refreshBar" id="refreshSearch" >
                                                    <span class="mdi mdi-refresh fs-4 fw-bold" style="color:#ab2b22;"></span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <table
                                class="table align-middle table-row-dashed table-striped table-hover gy-0 gs-1 list_page">
                                <thead>
                                    <tr class="text-start align-top fw-bold fs-6 gs-0 bg-primary">
                                        <th class="min-w-50px">S.No</th>
                                        <th class="min-w-100px">Badge Name</th>
                                        <th class="min-w-50px">Badge</th>
                                        <th class="min-w-50px">Prize</th>
                                        <th class="min-w-50px">Status</th>
                                        <th class="min-w-50px">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="list-table-body" class="text-black fw-semibold fs-7">
                                    <tr class="skeleton-loader" id="skeleton-loader">
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="text-center my-3" id="pagination-container">
                            <!-- Pagination buttons will appear here -->
                        </div>
                    </div>
                </div>
                <!-- SIDEBAR -->
                 
                <div id="tabSidebarSetting" class="tab-sidebar expanded right nav-align-sideright">
                    <ul class="nav nav-tabs flex-column" role="tablist">
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/assessment/guidelines') }}" class="nav-link "  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Guidelines</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Guidelines"><i class="mdi mdi-book-lock-open-outline fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/assessment/exam_category') }}" class="nav-link "  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Exam Category</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Exam Category"><i class="mdi mdi-web-plus fs-3"></i></span>
                                </label>
                                
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/assessment/exam_section') }}" class="nav-link"  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Exam Section</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Exam Section"><i class="mdi mdi-webhook fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a class="nav-link" href="{{ url('/settings/assessment/job_role_schedule') }}"  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Exam Schedule</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Exam Schedule"><i class="mdi mdi-police-badge-outline fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a class="nav-link active" href="{{ url('/settings/assessment/exam_badge') }}"  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Exam Badge</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Exam Badge"><i class="mdi mdi-podium-gold fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>


<!--begin::Modal - Add Exam Category-->
<div class="modal fade" id="kt_modal_add_exam_badge" tabindex="-1" aria-hidden="true" data-bs-keyboard="false"
    data-bs-backdrop="static">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-md">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header justify-content-end border-0 pb-0">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                    <span class="svg-icon svg-icon-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1"
                                transform="rotate(-45 6 17.3137)" fill="currentColor" />
                            <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)"
                                fill="currentColor" />
                        </svg>
                    </span>
                    <!--end::Svg Icon-->
                </div>
                <!--end::Close-->
            </div>
            <!--end::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body pt-0 pb-10 px-10 px-xl-20">
                <!--begin::Heading-->
                <div class="mb-8 text-center">
                    <h3 class="text-center mb-4 text-black">Create Exam Badge</h3>
                </div>
                <form id="add_exam_badge" action="{{ route('create_exam_badge') }}" method="POST"
                    enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <!-- Basic -->
                        <div class="col-lg-12 mb-3">
                            <label class="text-black mb-1 fs-6 fw-semibold">Exam Badge<span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control" placeholder="Enter Exam Badge" id="exam_badge_name"
                                name="exam_badge_name" />
                            <div id="exam_badge_name_err" class="text-danger mt-1 fs-7 fw-semibold"></div>
                        </div>

                        <div class="col-lg-12 mb-3">
                            <label class="text-black mb-1 fs-6 fw-semibold">Exam Category<span
                                    class="text-danger">*</span></label>
                            <select class="select3 form-select" name="exam_cat_id" id="exam_cat_id">
                                <option value="">Select Exam Category</option>
                            </select>
                            <div id="exam_cat_id_err" class="fs-7 fw-semibold text-danger mt-1"></div>
                        </div>
                        <div class="col-lg-12 mb-3">
                            <label class="text-black mb-1 fs-6 fw-semibold">Prize</label>
                            <select class="select3 form-select" name="prize_id" id="prize_id"
                                onchange="prize_change(this.value)">
                                <option value="">Select Prize</option>
                                <option value="1">Gifts</option>
                                <option value="2">Points</option>
                                <option value="3">Promotion</option>
                            </select>
                        </div>
                        <div class="col-lg-12 mb-3" id="gifts-container" style="display: none;">
                            <label class="text-black mb-1 fs-6 fw-semibold">Gifts<span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control" placeholder="Enter Gifts" id="exam_gift"
                                name="exam_gift" maxlength="70" />
                            <div id="gift_err" class="text-danger mt-1 fs-7 fw-semibold"></div>
                        </div>
                        <div class="col-lg-12 mb-3" id="points-container" style="display: none;">
                            <label class="text-black mb-1 fs-6 fw-semibold">Points<span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control" placeholder="Enter Points" id="exam_points"
                                name="exam_points"
                                oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');"
                                maxlength="5" />
                            <div id="points_err" class="text-danger mt-1 fs-7 fw-semibold"></div>
                        </div>
                        <div class="col-lg-12 mb-3" id="promotion-container" style="display: none;">
                            <label class="text-black mb-1 fs-6 fw-semibold">Promotion<span
                                    class="text-danger">*</span></label>
                            <select class="select3 form-select" name="promotion_id" id="promotion_id">
                                <option value="">Select Job Position</option>
                                @foreach ($job_position as $jp)
                                <option value="{{ $jp->sno }}">{{ $jp->job_position_name }}</option>
                                @endforeach
                            </select>
                            <div id="promotion_id_err" class="fs-7 fw-semibold text-danger mt-1"></div>
                        </div>
                        <div class="col-lg-12 mb-3">
                            <div class="row">
                                <label class="col-lg-6 text-black fs-6 fw-semibold">Badge Image<span
                                        class="text-danger">*</span></label>
                                <div class="col-lg-12">
                                    <div class="align-items-sm-center gap-4">
                                        <img src="{{ asset('assets/egc_images/award.png') }}" alt="user-avatar"
                                            class="w-px-120 h-px-120 mt-2 rounded border border-gray-600 border-solid"
                                            id="uploadedlogo" />
                                        <div class="button-wrapper">
                                            <div class="d-flex align-items-start mt-2 mb-2">
                                                <label for="upload" class="btn btn-sm btn-primary me-2" tabindex="0"
                                                    data-bs-toggle="tooltip" data-bs-placement="top"
                                                    title="Upload Logo">
                                                    <i class="mdi mdi-tray-arrow-up"></i>
                                                    <input type="file" name="logo" id="upload" class="file-in" hidden
                                                        accept="image/png, image/jpeg" />
                                                </label>
                                                <button type="button" class="btn btn-sm btn-outline-danger file-reset"
                                                    data-bs-toggle="tooltip" data-bs-placement="top" title="Reset Logo">
                                                    <i class="mdi mdi-reload"></i>
                                                </button>
                                            </div>
                                            <div class="text-danger fs-7 fw-semibold mt-2" id="badge_image_err"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12 mb-3">
                            <label class="text-black mb-1 fs-6 fw-semibold">Description</label>
                            <textarea class="form-control" rows="3" placeholder="Enter Description"
                                name="badge_desc"></textarea>
                        </div>
                    </div>
                    <div class="d-flex justify-content-center align-items-center mt-4">
                        <button type="reset" class="btn btn-secondary me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Create Exam Category</button>
                    </div>
                </form>
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>
<!--end::Modal - Add Exam Bank Category-->

<!--begin::Modal - edit Exam Bank Category-->
<div class="modal fade" id="kt_modal_edit_badge" tabindex="-1" aria-hidden="true" data-bs-keyboard="false"
    data-bs-backdrop="static">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-md">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header justify-content-end border-0 pb-0">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                    <span class="svg-icon svg-icon-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1"
                                transform="rotate(-45 6 17.3137)" fill="currentColor" />
                            <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)"
                                fill="currentColor" />
                        </svg>
                    </span>
                    <!--end::Svg Icon-->
                </div>
                <!--end::Close-->
            </div>
            <!--end::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body pt-0 pb-10 px-10 px-xl-20">
                <!--begin::Heading-->
                <div class="mb-8 text-center">
                    <h3 class="text-center mb-4 text-black">Update Exam Badge</h3>
                </div>
                <form action="{{ route('update_exam_badge') }}" method="POST" id="edit_exam_badge"
                    enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <!-- Basic -->
                        <input type="hidden" name="edit_id" id="edit_id">
                        <div class="col-lg-12 mb-3">
                            <label class="text-black mb-1 fs-6 fw-semibold">Exam Badge<span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control" placeholder="Enter Exam Badge"
                                id="exam_badge_name_edit" name="exam_badge_name_edit" />
                            <div id="exam_badge_name_edit_err" class="text-danger mt-1 fs-7 fw-semibold"></div>
                        </div>
                        <div class="col-lg-12 mb-3">
                            <label class="text-black mb-1 fs-6 fw-semibold">Exam Category<span
                                    class="text-danger">*</span></label>
                            <select class="select3 form-select" name="exam_cat_id_edit" id="exam_cat_id_edit">
                                <option value="">Select Exam Category</option>
                            </select>
                            <div id="exam_cat_id_edit_err" class="fs-7 fw-semibold text-danger mt-1"></div>
                        </div>
                        <div class="col-lg-12 mb-3">
                            <label class="text-black mb-1 fs-6 fw-semibold">Prize</label>
                            <select class="select3 form-select" name="edit_prize_id" id="edit_prize_id" onchange="prize_change_edit(this.value)">
                                <option value="">Select Prize</option>
                                <option value="1">Gifts</option>
                                <option value="2">Points</option>
                                <option value="3">Promotion</option>
                            </select>
                        </div>
                        <div class="col-lg-12 mb-3" id="gifts-container-edit" style="display: none;">
                            <label class="text-black mb-1 fs-6 fw-semibold">Gifts<span class="text-danger">*</span></label>
                            <input type="text" class="form-control" placeholder="Enter Gifts" id="exam_gift_edit" name="exam_gift_edit" maxlength="70" />
                            <div id="gift_err_edit" class="text-danger mt-1 fs-7 fw-semibold"></div>
                        </div>
                        <div class="col-lg-12 mb-3" id="points-container-edit" style="display: none;">
                            <label class="text-black mb-1 fs-6 fw-semibold">Points<span class="text-danger">*</span></label>
                            <input type="text" class="form-control" placeholder="Enter Points" id="exam_points_edit" name="exam_points_edit"
                                oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');" maxlength="5" />
                            <div id="points_err_edit" class="text-danger mt-1 fs-7 fw-semibold"></div>
                        </div>
                        <div class="col-lg-12 mb-3" id="promotion-container-edit" style="display: none;">
                            <label class="text-black mb-1 fs-6 fw-semibold">Promotion<span class="text-danger">*</span></label>
                            <select class="select3 form-select" name="promotion_id_edit" id="promotion_id_edit">
                                <option value="">Select Job Position</option>
                                @foreach ($job_position as $jp)
                                <option value="{{ $jp->sno }}">{{ $jp->job_position_name }}</option>
                                @endforeach
                            </select>
                            <div id="promotion_id_err_edit" class="fs-7 fw-semibold text-danger mt-1"></div>
                        </div>
                        <div class="col-lg-12 mb-3">
                            <div class="row">
                                <label class="col-lg-6 text-black fs-6 fw-semibold">Badge Image<span
                                        class="text-danger">*</span></label>
                                <div class="col-lg-12">
                                    <div class="align-items-sm-center gap-4">
                                        <img src="{{ asset('assets/egc_images/award.png') }}" alt="user-avatar"
                                            class="w-px-120 h-px-120 mt-2 rounded border border-gray-600 border-solid"
                                            id="uploadedlogo_edit" />
                                        <div class="button-wrapper">
                                            <div class="d-flex align-items-start mt-2 mb-2">
                                                <label for="upload_edit" class="btn btn-sm btn-primary me-2"
                                                    tabindex="0" data-bs-toggle="tooltip" data-bs-placement="top"
                                                    title="Upload Logo">
                                                    <i class="mdi mdi-tray-arrow-up"></i>
                                                    <input type="file" name="logo_edit" id="upload_edit"
                                                        class="file-in-edit" hidden accept="image/png, image/jpeg" />
                                                </label>
                                                <button type="button"
                                                    class="btn btn-sm btn-outline-danger file-reset-edit"
                                                    data-bs-toggle="tooltip" data-bs-placement="top" title="Reset Logo">
                                                    <i class="mdi mdi-reload"></i>
                                                </button>
                                            </div>
                                            <div class="text-danger fs-7 fw-semibold mt-2" id="badge_image_err_edit">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12 mb-3">
                            <label class="text-black mb-1 fs-6 fw-semibold">Description</label>
                            <textarea class="form-control" rows="3" placeholder="Enter Description"
                                name="badge_desc_edit" id="badge_desc_edit"></textarea>
                        </div>
                    </div>
                    <div class="d-flex justify-content-center align-items-center mt-4">
                        <button type="reset" class="btn btn-secondary me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Update Exam Badge</button>
                    </div>
                </form>
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>
<!--end::Modal - edit Exam Bank Category-->

    <!--begin::Modal - Delete  Social Media-->
    <div class="modal fade" id="kt_modal_delete_exam_category" tabindex="-1" aria-hidden="true" data-bs-keyboard="false"
        data-bs-backdrop="static">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-m">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <div class="swal2-icon swal2-danger swal2-icon-show" style="display: flex;">
                    <!-- <div class="swal2-icon-content"><i class="mdi mdi-trash fs-2 text-danger"></i></div> -->
                    <div>
                        <i class="fa-solid fa-trash text-danger" style="font-size: 35px;"></i>
                    </div>
                </div>
                <div class="swal2-html-container mb-4" id="swal2-html-container" style="display: block;">
                    <span id="delete_message">Are you sure you want to delete <br><b class="text-danger"> </b>
                         Exam category ?</span>
                </div>
                <div class="d-flex justify-content-center align-items-center pt-8 mb-4">
                    <button type="submit" class="btn btn-danger me-3" onclick="deletelevel()">Yes,
                        delete!</button>
                    <button type="reset" class="btn btn-secondary text-black" data-bs-dismiss="modal">No,cancel</button>
                </div>
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - Delete  Social Media-->




    <!-- Logo File Upload Start -->
    <!-- jQuery from CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

  

<script>
    let currentPage = 1;
    let isLoading = false;
    let abortController = new AbortController();

    function formatDate(date) {
        const options = { year: 'numeric', month: 'short', day: 'numeric', hour: '2-digit', minute: '2-digit', hour12: true };
        return new Date(date).toLocaleDateString('en-GB', options);
    }
   
    function buildRow(item,index) {

        let badge_image = '';
        if (item.badge_image && item.badge_image.trim() !== '') {
            badge_image = `exam/badges/${item.badge_image}`;
            
        } 
        badge_image = `{{ asset('${badge_image}') }}`;
     
        let prizeType = item.prize_id;
        let htmlprize = '';
        if (prizeType == 1) {
            htmlprize = 'Gifts';
        } else if(prizeType == 2) {
            htmlprize = 'Points';
        } else if(prizeType == 3) {
            htmlprize = 'Promotion';
        } else {
            htmlprize = 'Not Allocated';
        }
                                           
        return `
            <tr>
                <td><label class="fs-7 fw-medium">${index}</label></td>
                <td>
                    <label class="fs-7 fw-medium">${item.badge_name}</label>
                    <span class="cursor-pointer" data-bs-toggle="tooltip" data-bs-placement="right"
                        title="${item.badge_desc || '-' }">
                        <i class="mdi mdi mdi-help-circle text-dark"></i>
                    </span>
                    <label class="d-block text-black fw-semibold fs-7">${item.category_name}</label>
                </td>
                <td>
                    <img src="${badge_image}" alt="user-avatar" class="w-px-50" />
                </td>
                <td>
                    <label class="text-black fw-semibold fs-7">${htmlprize}</label>
                </td>
                <td>
                    <label class="switch switch-square">
                        <input type="checkbox" class="switch-input" ${item.status == 0 ? 'checked' : ''} onchange="updatelevelStatus('${item.sno}', this.checked)"/>
                        <span class="switch-toggle-slider">
                            <span class="switch-on"></span>
                            <span class="switch-off"></span>
                        </span>
                    </label>
                </td>
                
                <td >
                    <span class="text-end">
                        <button class="btn btn-icon btn-sm" type="button" data-bs-toggle="modal"
                            data-bs-target="#kt_modal_edit_badge"
                            data-bs-toggle="tooltip" data-bs-placement="bottom"
                            title="Edit" onclick="openEditModal('${item.sno}')">
                            <i class="mdi mdi-square-edit-outline fs-3 text-black"></i>
                        </button>
                        <button class="btn btn-icon btn-sm" type="button" 
                            data-bs-toggle="modal"
                            data-bs-target="#kt_modal_delete_exam_category"
                            data-bs-toggle="tooltip" data-bs-placement="bottom"
                            title="Delete"  onclick="confirmDelete('${item.sno}', '${item.badge_name}')">
                            <i class="mdi mdi-delete-outline fs-3 text-black"></i>
                        </button>
                    </span>
                </td>
            </tr>
        `;
    }
    function loadThemes(page = 1) {
        const perpage = document.getElementById('perpage').value;
        const search = document.getElementById('search_filter').value;
        const url = `/settings/assessment/exam_badge?page=${page}&sorting_filter=${perpage}&search_filter=${search}`;

        // Show skeleton loader and clear old data before fetching new data
        isLoading = true;
        document.getElementById('list-table-body').innerHTML = ''; // Clear old data
        document.getElementById('list-table-body').insertAdjacentHTML('beforeend', skeletenRow()); // Clear old data
        $('#skeleton-loader').show(); // Show skeleton loader

        if (abortController.signal) {
            abortController.abort(); // Abort the previous request
        }
        abortController = new AbortController();

         fetch(url, { headers: { 'X-Requested-With': 'XMLHttpRequest' }, signal: abortController.signal })
            .then(res => res.json())
            .then(res => {
                // Insert new data into the table
                res.data.forEach((item, index) => {
                    document.getElementById('list-table-body').insertAdjacentHTML('beforeend', buildRow(item, index + 1));
                });
               
                // Update pagination and results info
                updatePagination(res.current_page, res.last_page, res.total, perpage);

                // Hide skeleton loader after data is fetched
                isLoading = false;
                $('#skeleton-loader').hide();
                 $('[data-bs-toggle="tooltip"]').tooltip();
            })
            .catch(error => {
                if (error.name !== 'AbortError') { // Only handle abort error
                    console.error('Error loading data:', error);
                }
                // Hide skeleton loader in case of error
                $('#skeleton-loader').hide();
                isLoading = false;
            });
    }

    function skeletenRow(){
        return `
            <tr class="skeleton-loader" id="skeleton-loader">
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
            </tr>
            `;
    }

    function updatePagination(currentPage, lastPage, total, perpage) {
        let paginationContainer = document.getElementById('pagination-container');
        paginationContainer.innerHTML = ''; // Clear old pagination

        // Set the pagination container style
        paginationContainer.style.display = "flex";
        paginationContainer.style.justifyContent = "space-between";
        paginationContainer.style.alignItems = "center";

        // Showing result count info (e.g., Showing 1 to 25 of 3556 results)
        let start = (currentPage - 1) * perpage + 1;
        let end = Math.min(currentPage * perpage, total);
        let showingInfo = `Showing ${start} to ${end} of ${total} results`;
        paginationContainer.insertAdjacentHTML('beforeend', showingInfo);

        // Create Pagination Buttons

        // << First button
        let firstButton = `<li class="page-item ${currentPage === 1 ? 'disabled' : ''}" data-bs-toggle="tooltip" data-bs-placement="top" title="First Page"><button class=" page-link" onclick="loadThemes(1)" >«</button> </li>`;
        
        // < Previous button
        let prevButton = `<li class="page-item ${currentPage > 1 ? '' : 'disabled'}" data-bs-toggle="tooltip" data-bs-placement="top" title="Previous"><button class=" page-link" onclick="loadThemes(${currentPage - 1})" >‹</button> </li>`;
        
        // Next button
        let nextButton = `<li class="page-item ${currentPage < lastPage ? '' : 'disabled'}" data-bs-toggle="tooltip" data-bs-placement="top" title="Next"><button class="page-link" onclick="loadThemes(${currentPage + 1})" >›</button> </li>`;
        
        // >> Last button
        let lastButton = `<li class="page-item ${currentPage === lastPage ? 'disabled' : ''}" data-bs-toggle="tooltip" data-bs-placement="top" title="Last Page"><button class=" page-link" onclick="loadThemes(${lastPage})" >»</button> </li>`;

        // Page Number Buttons (Dynamically show a range of pages around the current page)
        let pageButtons = '';
        let range = 2; // Show 2 pages before and after the current page
        let startPage = Math.max(1, currentPage - range);
        let endPage = Math.min(lastPage, currentPage + range);

        // Generate page numbers
        for (let i = startPage; i <= endPage; i++) {
            pageButtons += `<li class="page-item ${i === currentPage ? 'active' : ''}"><button class="page-link " onclick="loadThemes(${i})">${i}</button> </li>`;
        }

        // Add the pagination buttons and page numbers
        paginationContainer.insertAdjacentHTML('beforeend', `
            <nav aria-label="Page navigation example">
                <ul class="pagination">
                    ${firstButton}
                    ${prevButton}
                    ${pageButtons}
                    ${nextButton}
                    ${lastButton}
                </ul>
            </nav>
        `);

        // Update perpage dropdown if changed
        document.getElementById('perpage').value = perpage;
    }

    function debounceSearch(e) {
        if (e.keyCode === 13) {
            loadThemes(1);  // Trigger the search when the user presses enter
        }
    }

    // Debounce function to handle input changes
    let debounceTimeout;
    function debounce(fn, delay) {
        return function() {
            clearTimeout(debounceTimeout);
            debounceTimeout = setTimeout(fn, delay);
        };
    };

  

    // SearchBar
    document.getElementById('search_filter').addEventListener('input', function() {
        const searchValue = document.getElementById('search_filter').value;
        if (searchValue) {
            document.getElementById('refreshSearch').style.display = 'inline-block';  // Show the refresh button
        } else {
            document.getElementById('refreshSearch').style.display = 'none';  // Hide the refresh button
        }
    });

     // Listen for changes in the perpage dropdown and reload data
    document.getElementById('perpage').addEventListener('change', () => loadThemes(1));

    // Listen for Enter key in the search filter and reload data
    document.getElementById('search_filter').addEventListener('keyup', debounceSearch);

    document.getElementById('refreshSearch').addEventListener('click', function() {
        document.getElementById('search_filter').value = '';  // Clear the search input
        loadThemes(1);  // Reload the table data without the search filter
    });
    document.getElementById('searchSubmit').addEventListener('click', function() {
        loadThemes(1);  // Reload the table data without the search filter
    });

    // Initial load
    loadThemes(1);

</script>

<script>
    function confirmDelete(id, name) {
        document.querySelector('#kt_modal_delete_exam_category .btn-danger').setAttribute(
            'data-id', id);
        $('#delete_message').html('Are you sure you want to delete <br> <b class="text-danger"> ' + name +
            '</b> Exam Badge ?');
    }

    function deletelevel() {

        var categoryId = document.querySelector('#kt_modal_delete_exam_category .btn-danger').getAttribute('data-id');

        fetch('/delete_exam_badge/' + categoryId, {
                method: 'DELETE',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}' // Include CSRF token if using Laravel CSRF protection
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 200) {
                    toastr.success('Exam Badge Deleted successfully!');
                    location.reload();

                } else {

                    console.error(data.error_msg);
                }
            })
            .catch(error => {
                console.error('Error:', error);
            });
    }

    function updatelevelStatus(categoryId, isChecked) {
        const status = isChecked ? 0 : 1; // Set status based on checkbox state

        fetch(`/status_exam_badge/${categoryId}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}' // Include CSRF token
                },
                body: JSON.stringify({
                    status: status
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 200) {
                    toastr.success('Exam Badge status Updated successfully!');
                    loadThemes(1); 
                } else {
                    console.error('Error updating Exam Badge status:', data.message);
                }
            })
            .catch(error => {
                console.error('Error updating Exam Badge status:', error);
            });
    }
</script>
<!-- Add Validation -->
<script>
    $('#add_exam_badge').on('submit', (e) => {
        let isValid = true;

        const badgeName = $('#exam_badge_name').val().trim();
        const examCatId = $('#exam_cat_id').val();
        const badgeImage = $('.file-in')[0];
        const file = badgeImage?.files[0];

        const prizeId = $('#prize_id').val();
        const gifts = $('#exam_gift').val().trim();
        const points = $('#exam_points').val().trim();
        const promotion = $('#promotion_id').val();

        // Clear Errors
        $('#exam_badge_name_err').text('');
        $('#badge_image_err').text('');
        $('#exam_cat_id_err').text('');
        $('#gift_err').text('');
        $('#points_err').text('');
        $('#promotion_id_err').text('');

        // Badge name validation
        if (badgeName === '') {
            $('#exam_badge_name_err').text('Badge Name is Required.');
            isValid = false;
        }

        // Exam category validation
        if (examCatId === '') {
            $('#exam_cat_id_err').text('Exam Category is Required.');
            isValid = false;
        }

        // Prize-related validation
        if (prizeId === '1') {
            if (gifts === '') {
                $('#gift_err').text('Gifts are Required.');
                isValid = false;
            }
        } else if (prizeId === '2') {
            if (points === '') {
                $('#points_err').text('Points are Required.');
                isValid = false;
            }
        } else if (prizeId === '3') {
            if (promotion === '') {
                $('#promotion_id_err').text('Promotion is Required.');
                isValid = false;
            }
        }

        // Image validation
        if (!file) {
            $('#badge_image_err').text('Badge Image is Required.');
            isValid = false;
        } else {
            const validTypes = ['image/jpeg', 'image/png'];
            const maxSize = 800 * 1024; // 800 KB
            if (!validTypes.includes(file.type)) {
                $('#badge_image_err').text("Only JPG and PNG images are allowed.");
                isValid = false;
            } else if (file.size > maxSize) {
                $('#badge_image_err').text("Image size should not exceed 800 KB.");
                isValid = false;
            }
        }

        // Prevent submit if not valid
        if (!isValid) {
            e.preventDefault();
        }
    });
</script>

<!-- Edit Validation -->
<script>
    $('#edit_exam_badge').on('submit', (e) => {
        e.preventDefault(); // prevent default until we validate fully
        let isValid = true;

        const editBadgeName = $('#exam_badge_name_edit').val().trim();
        const editExamCat = $('#exam_cat_id_edit').val();
        const editBadgeImage = $('.file-in-edit')[0];
        const file = editBadgeImage?.files[0];

        const editPrizeId = $('#edit_prize_id').val();
        const editGifts = $('#exam_gift_edit').val().trim();
        const editPoints = $('#exam_points_edit').val().trim();
        const editPromotionId = $('#promotion_id_edit').val();

        // Clear previous errors
        $('#exam_badge_name_edit_err').text('');
        $('#exam_cat_id_edit_err').text('');
        $('#badge_image_err_edit').text('');

        // Validate badge name
        if (editBadgeName === '') {
            $('#exam_badge_name_edit_err').text('Badge Name is required.');
            isValid = false;
        }

        // Validate exam category
        if (editExamCat === '') {
            $('#exam_cat_id_edit_err').text('Exam Category is required.');
            isValid = false;
        }

        if(editPrizeId === '1') {
            if (editGifts === '') {
                $('#gift_err_edit').text('Gifts are Required.');
                isValid = false;
            }
        } else if (editPrizeId === '2') {
            if (editPoints === '') {
                $('#points_err_edit').text('Points are Required.');
                isValid = false;
            }
        } else if (editPrizeId === '3') {
            if (editPromotionId === '') {
                $('#promotion_id_err_edit').text('Promotion is Required.');
                isValid = false;
            }
        }

        // Validate image only if new file is selected
        if (file) {
            const validTypes = ['image/jpeg', 'image/png'];
            const maxSize = 800 * 1024; // 800 KB

            if (!validTypes.includes(file.type)) {
                $('#badge_image_err_edit').text("Only JPG and PNG images are allowed.");
                isValid = false;
            } else if (file.size > maxSize) {
                $('#badge_image_err_edit').text("Image size should not exceed 800 KB.");
                isValid = false;
            }
        }

        // If all is valid, submit the form
        if (isValid) {
            e.currentTarget.submit();
        }
    });
</script>

<!-- Image Preview -->
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const logoFileInput = document.querySelector('.file-in');
        const logoResetButton = document.querySelector('.file-reset');

        // Function to reset logo image and input
        logoResetButton.addEventListener('click', function () {
            const logoImage = document.getElementById('uploadedlogo');
            const resetLogoImage = "{{ asset('assets/egc_images/award.png') }}"; // Default image path
            logoImage.src = resetLogoImage;
            logoFileInput.value = '';
        });

        // Function to preview uploaded logo image
        logoFileInput.addEventListener('change', function () {
            const logoImage = document.getElementById('uploadedlogo');
            if (this.files && this.files[0]) {
                const reader = new FileReader();
                reader.onload = function (e) {
                    logoImage.src = e.target.result;
                };
                reader.readAsDataURL(this.files[0]);
            }
        });
    });
</script>

<!-- Edit Data Fetch and Image Handling -->
<script>
    function openEditModal(id) {
        $.ajax({
            url: `/edit_exam_badge/${id}`,
            method: 'GET',
            dataType: 'json',
            success: function(response) {
                if(response && response.status === 200) {
                    const edit = response.data;

                    $('#edit_id').val(edit.sno);
                    $('#exam_badge_name_edit').val(edit.badge_name);
                    $('#edit_prize_id').val(edit.prize_id).trigger('change');

                    const prizeVal = edit.prize_id;
                    if(prizeVal == '1') {
                        $('#exam_gift_edit').val(edit.gift);
                    } else if(prizeVal == '2') {
                        $('#exam_points_edit').val(edit.points);
                    } else if(prizeVal == '3') {
                        $('#promotion_id_edit').val(edit.promotion_id).trigger('change');
                    }

                    $('#badge_desc_edit').val(edit.badge_desc ?? '-');

                    var editExamCatId = edit.exam_cat_id;

                    // Fetch Exam Category
                    $.ajax({
                        url: `/list_exam_category`,
                        method: 'GET',
                        success: function (res) {
                            if(res.status === 200) {
                                var examCatID = $('#exam_cat_id_edit');
                                examCatID.empty();

                                examCatID.append(`<option value="">Select Exam Category</option>`);

                                res.data.forEach(cat => {
                                    examCatID.append(`<option value="${cat.sno}">${cat.category_name}</option>`);
                                });

                                if(editExamCatId) {
                                    examCatID.val(editExamCatId).trigger('change');
                                }
                            }
                        },
                        error : function (err) {
                            console.error('Data Fetching Failed' + err);
                        }
                    });

                    if(edit.badge_image) {
                        const imageURL = `/exam/badges/${edit.badge_image}`;
                        $('#uploadedlogo_edit').attr('src', imageURL);
                    } else {
                        $('#uploadedlogo_edit').attr('src', '{{ asset("assets/egc_images/award.png") }}');
                    }
                } else {
                    console.log('Data Fetching Failed !')
                }
            },
            error: function (err) {
                console.error('Data Fetching Failed !');
            }
        });
    }

    // Add these event listeners for the edit modal
    document.addEventListener('DOMContentLoaded', function () {
        const logoFileInputEdit = document.querySelector('.file-in-edit');
        const logoResetButtonEdit = document.querySelector('.file-reset-edit');

        // Function to reset logo image and input in edit modal
        logoResetButtonEdit.addEventListener('click', function () {
            const logoImage = document.getElementById('uploadedlogo_edit');
            const originalImage = logoImage.dataset.original || "{{ asset('assets/egc_images/award.png') }}";
            logoImage.src = originalImage;
            if (logoFileInputEdit) {
                logoFileInputEdit.value = '';
            }
        });

        // Function to preview uploaded logo image in edit modal
        if (logoFileInputEdit) {
            logoFileInputEdit.addEventListener('change', function () {
                const logoImage = document.getElementById('uploadedlogo_edit');
                if (this.files && this.files[0]) {
                    const reader = new FileReader();
                    reader.onload = function (e) {
                        logoImage.src = e.target.result;
                    };
                    reader.readAsDataURL(this.files[0]);
                }
            });
        }
    });
</script>


<!-- Fetch Exam Category -->
<script>
    $(document).ready(function () {
        $.ajax({
            url: `/list_exam_category`,
            method: 'GET',
            success: function (res) {
                if(res.status === 200) {
                    var examCatID = $('#exam_cat_id');
                    examCatID.empty();

                    examCatID.append(`<option value="">Select Exam Category</option>`);

                    res.data.forEach(cat => {
                        examCatID.append(`<option value="${cat.sno}">${cat.category_name}</option>`);
                    });
                }
            },
            error : function (err) {
                console.error('Data Fetching Failed' + err);
            }
        });
    });
</script>

<!-- PRIZE TOGGLE SCRIPT ADD -->
<script>
    function prize_change(val) {
        $('#gifts-container').hide();
        $('#points-container').hide();
        $('#promotion-container').hide();
        $('#exam_gift').val('');
        $('#exam_points').val('');
        $('#promotion_id').val('').trigger('change');
        $('#gift_err').text('');
        $('#points_err').text('');
        $('#promotion_id_err').text('');

        if (val == "1") {
            $('#gifts-container').show();
            $('#points-container').hide();
            $('#promotion-container').hide();
            $('#exam_points').val('');
            $('#promotion_id').val('').trigger('change');
            $('#gift_err').text('');
            $('#points_err').text('');
            $('#promotion_id_err').text('');
        } else if (val == "2") {
            $('#gifts-container').hide();
            $('#points-container').show();
            $('#promotion-container').hide();
            $('#exam_gift').val('');
            $('#promotion_id').val('').trigger('change');
            $('#gift_err').text('');
            $('#points_err').text('');
            $('#promotion_id_err').text('');
        } else if (val == "3") {
            $('#gifts-container').hide();
            $('#points-container').hide();
            $('#promotion-container').show();
            $('#exam_gift').val('');
            $('#exam_points').val('');
            $('#gift_err').text('');
            $('#points_err').text('');
            $('#promotion_id_err').text('');
        }
    }
</script>

<!-- PRIZE TOGGLE SCRIPT EDIT -->
<script>
    function prize_change_edit(val) {
        $('#gifts-container-edit').hide();
        $('#points-container-edit').hide();
        $('#promotion-container-edit').hide();
        $('#exam_gift_edit').val('');
        $('#exam_points_edit').val('');
        $('#promotion_id_edit').val('').trigger('change');
        $('#gift_err_edit').text('');
        $('#points_err_edit').text('');
        $('#promotion_id_err_edit').text('');

        if (val == "1") {
            $('#gifts-container-edit').show();
            $('#points-container-edit').hide();
            $('#promotion-container-edit').hide();
            $('#exam_points_edit').val('');
            $('#promotion_id_edit').val('').trigger('change');
            $('#gift_err_edit').text('');
            $('#points_err_edit').text('');
            $('#promotion_id_err_edit').text('');
        } else if (val == "2") {
            $('#gifts-container-edit').hide();
            $('#points-container-edit').show();
            $('#promotion-container-edit').hide();
            $('#exam_gift_edit').val('');
            $('#promotion_id_edit').val('').trigger('change');
            $('#gift_err_edit').text('');
            $('#points_err_edit').text('');
            $('#promotion_id_err_edit').text('');
        } else if (val == "3") {
            $('#gifts-container-edit').hide();
            $('#points-container-edit').hide();
            $('#promotion-container-edit').show();
            $('#exam_gift_edit').val('');
            $('#exam_points_edit').val('');
            $('#gift_err_edit').text('');
            $('#points_err_edit').text('');
            $('#promotion_id_err_edit').text('');
        }
    }
</script>
@endsection
