@extends('layouts/layoutMaster')
@section('style')
@section('title', 'Exam Guidelines')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss','resources/assets/vendor/libs/quill/katex.scss', 'resources/assets/vendor/libs/quill/editor.scss'])
@endsection

@section('vendor-script')
    @vite(['resources/assets/vendor/libs/quill/katex.js', 'resources/assets/vendor/libs/quill/quill.js'])
@endsection

@section('page-script')
   @vite(['resources/assets/js/forms-editors.js'])
@endsection

@section('content')

    <style>
        .credential-wrapper {
            min-height: 70vh;
        }

        /* Sidebar */
        .tab-sidebar {
            width: 250px;
            transition: all 0.3s ease;
            background: #fff;
            border-left: 1px solid #ddd;
        }

        .tab-sidebar.collapsed {
            width: 60px;
        }

        .tab-sidebar .nav-link {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px;
        }

        .tab-sidebar .nav-link i {
            font-size: 22px;
        }

        .nav-align-sideright .nav-link.active > label {
            background-color: #cfcfcf;
            color: #000;
            padding: 5px 8px;
            border-radius: 5px;
        }

        .tab-sidebar ul{
            /* align-items: end; */
        }
        

        /* Hide text when collapsed */
        .tab-sidebar.collapsed .tab-text {
            display: none;
        }
        .tab-sidebar.collapsed ul {
            align-items: center;
        }

        /* Toggle button */
        .toggle-btn {
            position: absolute;
            top: 15px;
            right: -15px;
            z-index: 10;
            background: #ab2b22;
            color: #fff;
            border: none;
            width: 30px;
            height: 30px;
            border-radius: 50%;
        }

        /* When sidebar collapsed */
        .tab-sidebar.collapsed + .tab-content .toggle-btn {
            right: -15px;
        }

        .tab-sidebar .right_nav{
            cursor:pointer !important;
            width:100%;
            display:flex;
            justify-content:end;
             align-items:center;
              gap:4px;
        }

        .tab-sidebar .right_nav:hover{
            color:#ab2b22 !important;
        }
    </style>
    <!-- Users List Table -->
    <div class="card">
        <div class="card-header pb-1">
            <ul class="nav nav-tabs flex-nowrap" role="tablist">
                <div class="scroll-container-wrapper">
                    <button class="scroll-btn left" id="scrollLeftBtn"><span class="scroll-arrow"><i
                                class="mdi mdi-chevron-left fs-2 text-white"></i></span></button>
                                
                    <div class="scroll-container" id="scrollContainer">
                        <li class="item nav-item">
                            <a href="{{ url('/settings/general_settings') }}"
                                type="button"
                                class="nav-link scroll-link "
                                role="tab">
                                General Settings
                            </a>
                        </li>        
                        <li class="item nav-item">
                            <a
                                href="{{ url('/settings/broadcast_theme') }}"
                                type="button"
                                class="nav-link scroll-link"
                                aria-selected="true">
                                Common
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/credential_book') }}" type="button"
                                class="nav-link scroll-link ">
                                Entity
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/document') }}" type="button" class="nav-link scroll-link ">
                                HRM
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/applicant_status') }}" type="button"
                                class="nav-link scroll-link ">
                                Recruitment
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/interview_mode') }}" type="button"
                                class="nav-link scroll-link">
                                Interview
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/assessment/guidelines') }}" type="button"
                                class="nav-link scroll-link active">
                                Assessment
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/department') }}" type="button"
                                class="nav-link scroll-link ">
                                Management
                            </a>
                        </li>
                        <li class="nav-item">
                                <a href="{{ url('/settings/business/department') }}" type="button"
                                    class="nav-link scroll-link ">
                                    Business
                                </a>
                            </li>

                        <li class="nav-item">
                            <a href="{{ url('/settings/api_config') }}" type="button"
                                class="nav-link scroll-link ">
                                API Config
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/admin/webhooks') }}" type="button"
                                class="nav-link scroll-link ">
                                Webhook Moniter
                            </a>
                        </li>
                    </div>
                    <button class="scroll-btn right" id="scrollRightBtn" style="display: block;"><i
                            class="mdi mdi-chevron-right fs-2 text-white"></i></button>
                </div>
            </ul>
        </div>
        <div class="card-body px-1 py-1">
            <div class="d-flex credential-wrapper">
                <!-- CONTENT -->
                <div class="tab-content flex-grow-1 position-relative">
                    <!-- Toggle Button -->
                    <button id="toggleSidebarSetting" class="toggle-btn toggle-right">
                        <i class="mdi mdi-chevron-right"></i>
                    </button>

                    <div class="d-flex align-items-center justify-content-between pb-0 mb-4 pt-0 mt-0" style="border-bottom: 1px solid gray;">
                        <div class="d-flex flex-column align-items-start">
                            <h5 class="card-title mb-1 text-black">Assessment Guidelines</h5>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb custom-breadcrumb">
                                    <!-- Home -->
                                    <li class="breadcrumb-item">
                                        <a href="{{ url('/dashboard') }}">
                                            <i class="mdi mdi-cog"></i> Settings
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item" aria-current="page">
                                        <a href="javascript:void(0);">Assessment </a>
                                    </li>
                                    <li class="breadcrumb-item active" aria-current="page">
                                        <a href="javascript:void(0);" class="active-link">
                                            Guidelines
                                        </a>
                                    </li>
                                </ol>
                            </nav>
                        </div>
                    </div>        
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="tab-pane fade show show active" id="tab_add_exam_guidelines" role="tabpanel">
                                <form action="{{ route('create_guidelines') }}" method="POST" id="add_exam_guidelines">
                                    @csrf
                                    <input type="hidden" name="add_text" id="add_text">
                                    <div id="full-editor">
                                        <div class="row px-2 py-2 " id="show_text">
                                            
                                            <div class="col-lg-12">
                                                <div class="row">
                                                    <div id="create_training_content">
                                                        <div class="ql-editor" data-gramm="false" contenteditable="true"
                                                            data-placeholder="Type Something...">
                                                            {!! $guidelines->exam_guidelines !!}
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="error-msg text-danger fw-semibold mt-1 fs-7"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="d-flex justify-content-end align-items-center mt-4">
                                        <button type="reset" class="btn btn-secondary me-3" data-bs-dismiss="modal">Cancel</button>
                                        <button type="submit" class="btn btn-primary" data-bs-dismiss="modal">Update Exam Guidelines</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- SIDEBAR -->

                <div id="tabSidebarSetting" class="tab-sidebar expanded right nav-align-sideright">
                    <ul class="nav nav-tabs flex-column" role="tablist">
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/assessment/guidelines') }}" class="nav-link active"  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Guidelines</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Guidelines"><i class="mdi mdi-book-lock-open-outline fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/assessment/exam_category') }}" class="nav-link"  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Exam Category</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Exam Category"><i class="mdi mdi-web-plus fs-3"></i></span>
                                </label>
                                
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/assessment/exam_section') }}" class="nav-link"  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Exam Section</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Exam Section"><i class="mdi mdi-webhook fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a class="nav-link" href="{{ url('/settings/assessment/job_role_schedule') }}"  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Exam Schedule</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Exam Schedule"><i class="mdi mdi-police-badge-outline fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a class="nav-link" href="{{ url('/settings/assessment/exam_badge') }}"  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Exam Badge</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Exam Badge"><i class="mdi mdi-podium-gold fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

  <!-- Validation -->
<script>
    $('#add_exam_guidelines').on('submit', function(e) {
        e.preventDefault(); 

        $('.error-msg').text('');

        const contentHtml = $('#full-editor .ql-editor').html().trim();
        if (!contentHtml || contentHtml === '<p><br></p>') {
            $('.error-msg').text('Guidelines is required.');
            return false;
        } else {
            $('#add_text').val(contentHtml);
        }
        
        this.submit();
    });
</script>    

      


@endsection
