@extends('layouts/layoutMaster')
@section('style')
@section('title', 'Department')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/select2/select2.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
    @vite(['resources/assets/vendor/libs/select2/select2.js'])
@endsection

@section('content')

    <style>
        .credential-wrapper {
             min-height: 70vh;
        }

        /* Sidebar */
        .tab-sidebar {
            width: 250px;
            transition: all 0.3s ease;
            background: #fff;
            border-left: 1px solid #ddd;
        }

        .tab-sidebar.collapsed {
            width: 60px;
        }

        .tab-sidebar .nav-link {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px;
        }

        .tab-sidebar .nav-link i {
            font-size: 22px;
        }

        .nav-align-sideright .nav-link.active > label {
            background-color: #cfcfcf;
            color: #000;
            padding: 5px 8px;
            border-radius: 5px;
        }

        .tab-sidebar ul{
            /* align-items: end; */
        }
        

        /* Hide text when collapsed */
        .tab-sidebar.collapsed .tab-text {
            display: none;
        }
        .tab-sidebar.collapsed ul {
            align-items: center;
        }

        /* Toggle button */
        .toggle-btn {
            position: absolute;
            top: 15px;
            right: -15px;
            z-index: 10;
            background: #ab2b22;
            color: #fff;
            border: none;
            width: 30px;
            height: 30px;
            border-radius: 50%;
        }

        /* When sidebar collapsed */
        .tab-sidebar.collapsed + .tab-content .toggle-btn {
            right: -15px;
        }

        .tab-sidebar .right_nav{
            cursor:pointer !important;
            width:100%;
            display:flex;
            justify-content:end;
             align-items:center;
             gap:4px;
        }

        .tab-sidebar .right_nav:hover{
            color:#ab2b22 !important;
        }
    </style>

    <!-- Users List Table -->
    <div class="card">
        <div class="card-header pb-1">
            <ul class="nav nav-tabs flex-nowrap" role="tablist">
                <div class="scroll-container-wrapper">
                    <button class="scroll-btn left" id="scrollLeftBtn"><span class="scroll-arrow"><i
                                class="mdi mdi-chevron-left fs-2 text-white"></i></span></button>
                                
                    <div class="scroll-container" id="scrollContainer">
                        <li class="item nav-item">
                            <a href="{{ url('/settings/general_settings') }}"
                                type="button"
                                class="nav-link scroll-link "
                                role="tab">
                                General Settings
                            </a>
                        </li>        
                        <li class="item nav-item">
                            <a
                                href="{{ url('/settings/broadcast_theme') }}"
                                type="button"
                                class="nav-link scroll-link active"
                                aria-selected="true">
                                Common
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/credential_book') }}" type="button"
                                class="nav-link scroll-link ">
                                Entity
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/document') }}" type="button" class="nav-link scroll-link ">
                                HRM
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/applicant_status') }}" type="button"
                                class="nav-link scroll-link ">
                                Recruitment
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/interview_mode') }}" type="button"
                                class="nav-link scroll-link">
                                Interview
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/assessment/guidelines') }}" type="button"
                                class="nav-link scroll-link">
                                Assessment
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/department') }}" type="button"
                                class="nav-link scroll-link ">
                                Management
                            </a>
                        </li>
                        <li class="nav-item">
                                <a href="{{ url('/settings/business/department') }}" type="button"
                                    class="nav-link scroll-link ">
                                    Business
                                </a>
                            </li>

                        <li class="nav-item">
                            <a href="{{ url('/settings/api_config') }}" type="button"
                                class="nav-link scroll-link ">
                                API Config
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/admin/webhooks') }}" type="button"
                                class="nav-link scroll-link ">
                                Webhook Moniter
                            </a>
                        </li>
                    </div>
                    <button class="scroll-btn right" id="scrollRightBtn" style="display: block;"><i
                            class="mdi mdi-chevron-right fs-2 text-white"></i></button>
                </div>
            </ul>
        </div>
        <div class="card-body px-1 py-1">
            <div class="d-flex credential-wrapper">
                <!-- CONTENT -->
                <div class="tab-content flex-grow-1 position-relative">
                    <!-- Toggle Button -->
                    <button id="toggleSidebarSetting" class="toggle-btn toggle-right">
                        <i class="mdi mdi-chevron-right"></i>
                    </button>

                    
                    <div class="d-flex align-items-center justify-content-between pb-0 mb-4 pt-0 mt-0" style="border-bottom: 1px solid gray;">
                        <div class="d-flex flex-column align-items-start">
                            <h5 class="card-title mb-1 text-black">Broadcast Theme</h5>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb custom-breadcrumb">
                                    <!-- Home -->
                                    <li class="breadcrumb-item">
                                        <a href="{{ url('/dashboard') }}">
                                            <i class="mdi mdi-cog"></i> Settings
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item" aria-current="page">
                                        <a href="javascript:void(0);">Common </a>
                                    </li>
                                    <li class="breadcrumb-item active" aria-current="page">
                                        <a href="javascript:void(0);" class="active-link">
                                            Broadcast Theme
                                        </a>
                                    </li>
                                </ol>
                            </nav>
                        </div>
                        <div class="d-flex justify-content-end align-items-center mb-2 gap-2">
                            <a href="/settings/add_broadcast_theme" class="btn btn-sm fw-bold btn-primary" >
                                <span class="me-2"><i class="mdi mdi-plus"></i></span>Add Broadcast Theme
                            </a>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="d-flex align-items-center justify-content-between mb-4 ">
                                <div>
                                    <span>Show</span>
                                    <select id="perpage" class="form-select form-select-sm w-75px"
                                        onchange="loadThemes(1)">
                                        @php $options = [5,10, 25, 100, 500]; @endphp
                                        @foreach ($options as $option)
                                            <option value="{{ $option }}" {{ $perpage == $option ? 'selected' : '' }}>
                                                {{ $option }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="d-flex align-items-center justify-content-end flex-wrap gap-2">
                                    <div class="searchBar">
                                        <input type="text" id="search_filter" class="searchQueryInput"
                                            placeholder="Search Theme..."
                                            value="{{ $search_filter }}"/>
                                        
                                        <div class="searchAction">
                                            <div class="d-flex align-items-center">
                                                <a href="javascript:;"  class="searchSubmit" id="searchSubmit" >
                                                    <span class="mdi mdi-magnify fs-4 fw-bold"  style="color:#ab2b22;"></span>
                                                </a>
                                                <a href="javascript:;" class="refreshBar" id="refreshSearch" >
                                                    <span class="mdi mdi-refresh fs-4 fw-bold" style="color:#ab2b22;"></span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                          <div class="table-responsive">
                              <table
                                  class="table align-middle table-row-dashed table-striped table-hover gy-0 gs-1 list_page">
                                  <thead>
                                      <tr class="text-center align-middle fw-bold fs-6 gs-0 bg-primary">
                                          <th class="min-w-50px">Theme Name</th>
                                          <th class="min-w-max-w-300px">Preview</th>
                                          <th class="min-w-50px">Status</th>
                                          <th class="min-w-50px">Action</th>
                                      </tr>
                                  </thead>
                                  <tbody id="theme-table-body" class="text-black fw-semibold fs-7">
                                      <tr class="skeleton-loader" id="skeleton-loader">
                                          <td class="skeleton-cell">
                                              <div class="skeleton"></div>
                                          </td>
                                          <td class="skeleton-cell">
                                              <div class="skeleton"></div>
                                          </td>
                                          <td class="skeleton-cell">
                                              <div class="skeleton"></div>
                                          </td>
                                          <td class="skeleton-cell">
                                              <div class="skeleton"></div>
                                          </td>
                                      </tr>
                                  </tbody>
                              </table>
                          </div>
                        </div>
                        <div class="text-center my-3" id="pagination-container">
                            <!-- Pagination buttons will appear here -->
                        </div>
                    </div>
                </div>
                <!-- SIDEBAR -->
                <div id="tabSidebarSetting" class="tab-sidebar expanded right nav-align-sideright">
                    <ul class="nav nav-tabs flex-column" role="tablist">
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/broadcast_theme') }}" class="nav-link active"  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Broadcast</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Broadcast"><i class="mdi mdi-broadcast fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/sms_template') }}" class="nav-link"  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">SMS Template</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="SMS Template"><i class="mdi mdi-message-processing fs-3"></i></span>
                                </label>
                                
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/email_template') }}" class="nav-link "  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Email Template</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Email Template"><i class="mdi mdi-email fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/whatsapp_template') }}" class="nav-link" role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Whatsapp Template</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Whatsapp Template"><i class="mdi mdi-whatsapp fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/currency_format') }}" class="nav-link " role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Currency Format</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Currency Format"><i class="mdi mdi-currency-inr fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/country') }}" class="nav-link " role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Country</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Country"><i class="mdi mdi-map-legend fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/state') }}" class="nav-link" role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">State</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="State"><i class="mdi mdi-map-marker-radius fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/city') }}" class="nav-link " role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">City</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="City"><i class="mdi mdi mdi-city fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/timezone') }}" class="nav-link" role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Time Zone</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Time Zone"><i class="mdi mdi-web-clock fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/internal_cugs') }}" class="nav-link" role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Internal Cugs</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Internal Cugs"><i class="mdi mdi-phone-classic fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>


   <div class="modal fade" id="kt_modal_view_theme" tabindex="-1" aria-hidden="true" data-bs-keyboard="false"
        data-bs-backdrop="static" data-bs-focus="false">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-xl">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div class="modal-header justify-content-end border-0 pb-0">
                    <!--begin::Close-->
                    <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1"
                                    transform="rotate(-45 6 17.3137)" fill="currentColor" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1"
                                    transform="rotate(45 7.41422 6)" fill="currentColor" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                    </div>
                    <!--end::Close-->
                </div>
                <!--end::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body pt-0 pb-10 px-10 px-xl-20">
                    <!--begin::Heading-->
                    <div class="mb-4 text-center">
                        <h3 class="text-center mb-4 text-black">View Theme</h3>
                    </div>
                   <div class="container">
                       <div id="ent_wrapper_view">
              
                        </div>
                   </div>
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>

    <!--begin::Modal - Delete Country-->
    <div class="modal fade" id="kt_modal_delete_country" tabindex="-1" aria-hidden="true" data-bs-keyboard="false" data-bs-backdrop="static">
      <!--begin::Modal dialog-->
      <div class="modal-dialog modal-m">
          <!--begin::Modal content-->
          <div class="modal-content rounded">
          <div class="swal2-icon swal2-danger swal2-icon-show" style="display: flex;">
              <div class="swal2-icon-content">?</div>
          </div>
          <div class="swal2-html-container" id="swal2-html-container" style="display: block;">
          <span id="delete_message"></span>
          </div>
          <div class="d-flex justify-content-center align-items-center pt-8 pb-8">
              <button type="submit" class="btn btn-danger me-3" data-bs-dismiss="modal" onclick="deleteFunc()">Yes</button>
              <button type="reset" class="btn btn-secondary" data-bs-dismiss="modal">No</button>
          </div>
          </div>
          <!--end::Modal content-->
      </div>
    <!--end::Modal dialog-->
    </div>





    <!-- Logo File Upload Start -->
    <!-- jQuery from CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Toastr CSS from CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <!-- Toastr JavaScript from CDN -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <style>
        /* Customize Toastr notification */
        .toast-success {
            background-color: green;
        }

        /* Customize Toastr notification */
        .toast-error {
            background-color: red;
        }
    </style>
<script>
        // Display Toastr messages
            @if (Session::has('toastr'))
                var type = "{{ Session::get('toastr')['type'] }}";
                var message = "{{ Session::get('toastr')['message'] }}";
                toastr[type](message);
            @endif
    </script>
   
<script>
let currentPage = 1;
let nextPageUrl = "{{ url('/settings/broadcast_theme') }}?page=1";
let isLoading = false;
let abortController = new AbortController();


function buildRow(item) {
    const isActive = (item.status == 0);
    return `
        <tr id="theme-row-${item.sno}">
            <td>${item.theme_name}</td>
            <td align="left" class="max-w-350px">
                <div class="max-w-650px">
                    <div id="ent_wrapper_preview_${item.sno}" style="position:relative;z-index:1 !important;" class="list_wrapper ent_wrapper" ></div>
                </div>
            </td>
            <td align="center">
              <div>
                <label class="switch switch-square">
                    <input type="checkbox" class="switch-input"
                        ${isActive ? 'checked' : ''} 
                        onchange="updatelevelStatus('${item.sno}', this.checked)" />
                    <span class="switch-toggle-slider">
                        <span class="switch-on"></span>
                        <span class="switch-off"></span>
                    </span>
                </label>
              </div>
                <div class="d-block mt-2 text-center">
                    <span class="fw-bold ${isActive ? 'text-success' : 'text-danger'}">
                        ${isActive ? 'Default' : 'Set Default'}
                    </span>
                </div>
            </td>
            <td>
                <span class="text-end">
                    <a class="btn btn-icon btn-sm" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="mdi mdi-dots-vertical fs-3 text-black"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-end">
                        <a href="{{ url('/edit_broadcast_theme') }}/${item.encrypted_id}" class="dropdown-item">
                            <span><i class="mdi mdi-square-edit-outline fs-3 text-black me-1"></i></span>
                            <span>Edit</span>
                        </a>
                        <a href="#" class="dropdown-item"
                            data-bs-toggle="modal"
                            data-bs-target="#kt_modal_view_theme" onclick="openViewTheme('${item.sno}')" >
                            <span><i class="mdi mdi-eye-outline fs-3 text-black me-1"></i></span>
                            <span>View</span>
                        </a>
                        <a href="#" class="dropdown-item"
                            data-bs-toggle="modal"
                            data-bs-target="#kt_modal_delete_country" onclick="confirmDelete('${item.sno}', '${item.theme_name}')" >
                            <span><i class="mdi mdi-delete-outline fs-3 text-black me-1"></i></span>
                            <span>Delete</span>
                        </a>
                        
                  
                </div>
                </span>
            </td>
        </tr>
    `;
}

async function loadThemes(page = 1) {

      const perpage = document.getElementById('perpage').value;
      const search = document.getElementById('search_filter').value;
      const url = `/settings/broadcast_theme?page=${page}&sorting_filter=${perpage}&search_filter=${search}`;

      // Show skeleton loader and clear old data before fetching new data
      isLoading = true;
      document.getElementById('theme-table-body').innerHTML = ''; // Clear old data
      document.getElementById('theme-table-body').insertAdjacentHTML('beforeend', skeletenRow()); // Clear old data
      $('#skeleton-loader').show(); // Show skeleton loader

      if (abortController.signal) {
          abortController.abort(); // Abort the previous request
      }
      abortController = new AbortController();
      
    try {
        const res = await fetch(url, {
            headers: { 'X-Requested-With': 'XMLHttpRequest' }, signal: abortController.signal 
        });

        if (!res.ok) throw new Error(`HTTP ${res.status}`);

        const data = await res.json();

        // Defensive check
        if (!data || !Array.isArray(data.data)) throw new Error("Invalid response");
        if(data.data.length > 0){
            data.data.forEach(item => {
                    document.getElementById('theme-table-body')
                        .insertAdjacentHTML('beforeend', buildRow(item));
                  initPreview(item);
            });
          }else{
             document.getElementById('theme-table-body').insertAdjacentHTML('beforeend', NoDataFound());
          }

         updatePagination(data.current_page, data.last_page, data.total, perpage);
       
         isLoading = false;
          $('#skeleton-loader').hide();
    } catch (err) {
        if (err.name !== 'AbortError') { // Only handle abort error
                    console.error('Error loading data:', err);
          }
          // Hide skeleton loader in case of error
          $('#skeleton-loader').hide();
          isLoading = false;
    } finally {
        isLoading = false;
        $('#skeleton-loader').hide();
    }
}

function initPreview(item) {
    let settings = {
        position: 'relative',
        height: 50,
        theme: 1,
        margin: '0px',
        roundness: 0,
        shadow: { enable: false, type: 1, reverse: false },
        animation: {
            effect: 'scroll',
            scroll_speed: 50,
            easing: "easeInOutCirc",
            duration: 500,
            delay: 2000
        },
        data: null,
        label: {
            onMobile: { enable: true },
            enable: true,
            padding: '15px',
            fontFamily: "Roboto",
            fontSize: 14,
            fontWeight: "700",
            background: "#DA0037",
            color: "#EEE",
            text: "News",
            logo: ""
        },
        news: {
            background: "#EEE",
            padding: "0 15px",
            prefix: {
                enable: true,
                fontFamily: "Roboto",
                fontSize: 14,
                fontWeight: "700",
                background: "#444",
                color: "#EEE",
                roundness: 5,
                padding: "5px 10px"
            },
            date: {
                enable: true,
                fontFamily: "Roboto",
                fontSize: 14,
                fontWeight: "700",
                background: "none",
                color: "#444",
                roundness: 0,
                padding: "0px"
            },
            heading: {
                color: "#171717",
                fontFamily: "Roboto",
                fontSize: 16,
                fontWeight: "400"
            },
            separator: {
                size: 10,
                background: "#DA0037"
            }
        },
        navigation: {
            onMobile: { enable: true },
            enable: true,
            autohide: false,
            padding: "15px",
            background: "#171717",
            color: "#EEE",
            hover: "#EEE"
        }
    };

    // merge DB theme JSON
    $.extend(true, settings, item.data);

    // fallback news
    if (!settings.data || settings.data.length === 0) {
        settings.data = [
            { date: 'June 23, 2022', prefix: 'CNN', heading: 'Sample news headline', url: '#' },
            { date: 'June 23, 2022', prefix: 'BBC', heading: 'Another sample headline', url: '#' }
        ];
    }

    // render ticker
    let wrapper = $('#ent_wrapper_preview_' + item.sno);
    wrapper.html('').removeClass();
    wrapper.easyNewsTicker(settings);

    // ✅ enforce position from DB (override plugin CSS)
    wrapper.find('.ent_wrapper').css('position', settings.position || 'relative');
}

  function skeletenRow(){
      return `
          <tr class="skeleton-loader" id="skeleton-loader">
              <td class="skeleton-cell">
                  <div class="skeleton"></div>
              </td>
              <td class="skeleton-cell">
                  <div class="skeleton"></div>
              </td>
              <td class="skeleton-cell">
                  <div class="skeleton"></div>
              </td>
              <td class="skeleton-cell">
                  <div class="skeleton"></div>
              </td>
          </tr>
          `;
  }

  function NoDataFound(){
        return `
            <tr><td colspan="4" class="text-center">No Data Found</td></tr>
            `;
    }

    function updatePagination(currentPage, lastPage, total, perpage) {
        let paginationContainer = document.getElementById('pagination-container');
        paginationContainer.innerHTML = ''; // Clear old pagination

        // Set the pagination container style
        paginationContainer.style.display = "flex";
        paginationContainer.style.justifyContent = "space-between";
        paginationContainer.style.alignItems = "center";

        // Showing result count info (e.g., Showing 1 to 25 of 3556 results)
        let start = (currentPage - 1) * perpage + 1;
        let end = Math.min(currentPage * perpage, total);
        let showingInfo = `Showing ${start} to ${end} of ${total} results`;
        paginationContainer.insertAdjacentHTML('beforeend', showingInfo);

        // Create Pagination Buttons

        // << First button
        let firstButton = `<li class="page-item ${currentPage === 1 ? 'disabled' : ''}" data-bs-toggle="tooltip" data-bs-placement="top" title="First Page"><button class=" page-link" onclick="loadThemes(1)" >«</button> </li>`;
        
        // < Previous button
        let prevButton = `<li class="page-item ${currentPage > 1 ? '' : 'disabled'}" data-bs-toggle="tooltip" data-bs-placement="top" title="Previous"><button class=" page-link" onclick="loadThemes(${currentPage - 1})" >‹</button> </li>`;
        
        // Next button
        let nextButton = `<li class="page-item ${currentPage < lastPage ? '' : 'disabled'}" data-bs-toggle="tooltip" data-bs-placement="top" title="Next"><button class="page-link" onclick="loadThemes(${currentPage + 1})" >›</button> </li>`;
        
        // >> Last button
        let lastButton = `<li class="page-item ${currentPage === lastPage ? 'disabled' : ''}" data-bs-toggle="tooltip" data-bs-placement="top" title="Last Page"><button class=" page-link" onclick="loadThemes(${lastPage})" >»</button> </li>`;

        // Page Number Buttons (Dynamically show a range of pages around the current page)
        let pageButtons = '';
        let range = 2; // Show 2 pages before and after the current page
        let startPage = Math.max(1, currentPage - range);
        let endPage = Math.min(lastPage, currentPage + range);

        // Generate page numbers
        for (let i = startPage; i <= endPage; i++) {
            pageButtons += `<li class="page-item ${i === currentPage ? 'active' : ''}"><button class="page-link " onclick="loadThemes(${i})">${i}</button> </li>`;
        }

        // Add the pagination buttons and page numbers
        paginationContainer.insertAdjacentHTML('beforeend', `
            <nav aria-label="Page navigation example">
                <ul class="pagination">
                    ${firstButton}
                    ${prevButton}
                    ${pageButtons}
                    ${nextButton}
                    ${lastButton}
                </ul>
            </nav>
        `);

        // Update perpage dropdown if changed
        document.getElementById('perpage').value = perpage;
    }

    function debounceSearch(e) {
        if (e.keyCode === 13) {
            loadThemes(1);  // Trigger the search when the user presses enter
        }
    }

    // Debounce function to handle input changes
    let debounceTimeout;
    function debounce(fn, delay) {
        return function() {
            clearTimeout(debounceTimeout);
            debounceTimeout = setTimeout(fn, delay);
        };
    };

    // SearchBar
    document.getElementById('search_filter').addEventListener('input', function() {
        const searchValue = document.getElementById('search_filter').value;
        if (searchValue) {
            document.getElementById('refreshSearch').style.display = 'inline-block';  // Show the refresh button
        } else {
            document.getElementById('refreshSearch').style.display = 'none';  // Hide the refresh button
        }
    });

      // Listen for changes in the perpage dropdown and reload data
    document.getElementById('perpage').addEventListener('change', () => loadThemes(1));

    // Listen for Enter key in the search filter and reload data
    document.getElementById('search_filter').addEventListener('keyup', debounceSearch);

    document.getElementById('refreshSearch').addEventListener('click', function() {
        document.getElementById('search_filter').value = '';  // Clear the search input
        loadThemes(1);  // Reload the table data without the search filter
    });
    document.getElementById('searchSubmit').addEventListener('click', function() {
        loadThemes(1);  // Reload the table data without the search filter
    });

    // Initial load
    loadThemes(1);


</script>

 <!-- status Change -->
 <script>
    function updatelevelStatus(Id, isChecked) {
        const status = isChecked ? 0 : 1;
        fetch(`/broadcast_theme_status_change/${Id}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}' // Include CSRF token
                },
                body: JSON.stringify({
                    status: status
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 200) {
                    toastr.success('Status Updated successfully!');
                    loadThemes(1);
                }
            })
            .catch(error => {});
    }
</script>

<!-- Delete Function -->
<script>
      function confirmDelete(id, name) {
  
          document.querySelector('#kt_modal_delete_country .btn-danger').setAttribute('data-id', id);
          $('#delete_message').html(
              'Are you sure you want to delete Theme ?<br> <b class="text-black fw-bold fs-4">' +
              name +
              '</b>');
      }

      function deleteFunc() {
          var categoryId = document.querySelector('#kt_modal_delete_country .btn-danger').getAttribute('data-id');

          fetch('/broadcast_theme_update_delete/' + categoryId, {
                  method: 'DELETE',
                  headers: {
                      'Content-Type': 'application/json',
                      'X-CSRF-TOKEN': '{{ csrf_token() }}'
                  }
              })
              .then(response => response.json())
              .then(data => {
                  if (data.status === 200) {
                      toastr.success(data.message);
                      loadThemes()
                  } else {
                      toastr.error(data.error_msg);
                  }
              })
              .catch(error => {

              });
      }
</script>

<script>
    function openViewTheme(id){
        var settings = {}; 
         $.ajax({
                url: "/broadcast_theme_by_id",
                type: "GET",
                data: { theme_id: id },
                success: function (response) {
                    if (response.status === "200" && response.data) {
                        // merge DB theme into settings
                        var themeIndex = parseInt(response.data.theme) - 1;
                        $.extend(true, settings, response.data);
                    }
                    // re-init ticker
                    $('#ent_wrapper_view').html('').removeClass();
                    $('#ent_wrapper_view').easyNewsTicker(settings);
                },
                error: function (xhr) {
                    console.error("Theme fetch error:", xhr.responseText);
                    toastr.error("Error fetching theme.");

                    // fallback to base settings
                    $('#ent_wrapper_view').html('').removeClass();
                    $('#ent_wrapper_view').easyNewsTicker(settings);
                }
            });
            
        function getSettings(customNews) {
                var news, updateNews, i;
                settings = {
                  position: 'relative' ,
                  height: 50,
                  theme: 1,
                  margin: '0px',
                  roundness: 0,
                  shadow: {
                    enable: false,
                    type: 1,
                    reverse: false
                  },
                  animation: {
                    effect: 'scroll',
                    scroll_speed: parseInt($('#animation-scroll_speed').val()),
                    easing: "easeInOutCirc",
                    duration:500,
                    delay: 2000
                  },
                  data: null,
                  label: {
                    onMobile: {
                      enable: true
                    },
                    enable: true,
                    padding: '15px',
                    fontFamily: "Roboto",
                    fontSize: 14,
                    fontWeight: "700",
                    background: "#DA0037",
                    color: "#EEE",
                    text: "News",
                    logo: ""
                  },
                  news: {
                    background: "#EEE",
                    padding: "0 15px",
                    prefix: {
                      enable: true,
                      fontFamily: "Roboto",
                      fontSize: 14,
                      fontWeight: "700",
                      background: "#444",
                      color: "#EEE",
                      roundness:5,
                      padding: "5px 10px"
                    },
                    date: {
                      enable: true,
                      fontFamily: "Roboto",
                      fontSize: 14,
                      fontWeight: "700",
                      background: "none",
                      color: $('#news-date-color').val(),
                      roundness: 0,
                      padding: "0px"
                    },
                    heading: {
                      color: "#171717",
                      fontFamily: "Roboto",
                      fontSize: 16,
                      fontWeight: "400"
                    },
                    separator: {
                      size: 10,
                      background: "#DA0037"
                    }
                  },
                  navigation: {
                    onMobile: {
                      enable: true
                    },
                    enable: true,
                    autohide: false,
                    padding: "15px",
                    background: "#171717",
                    color: "#EEE",
                    hover: "#EEE"
                  }
                };
        
                var defaultNews = [
                  { date: 'June 23, 2022', prefix: 'CNN: World', heading: 'A Muslim teenager was killed at a protest in India. His family wants answers.', url: '#' },
                  { date: 'June 23, 2022', prefix: 'CNN: US Politics', heading: 'Biden administration agrees to cancel another $6 billion in student loan debt for defrauded borrowers.', url: 'https://edition.cnn.com/2022/06/23/politics/biden-student-loan-debt-cancellation-borrower-defense/index.html' },
                  { date: '26.05.2022 10:32', prefix: 'CNN: Buisiness', heading: 'Black former Tesla contractor turned down $15 million award in racial harassment suit, likely setting up new trial.', url: 'https://edition.cnn.com/2022/06/22/business/california-tesla-racism-lawsuit/index.html' },
                  { date: 'June 23, 2022', prefix: 'BBC: Climate', heading: "Just Stop Oil: Activists says they have 'a duty to protest'.", url: 'https://www.bbc.com/news/newsbeat-61635328' },
                  { date: 'June 23, 2022', prefix: 'BBC: Science', heading: 'Five major planets to line up in rare planetary conjunction.', url: 'https://www.bbc.com/news/science-environment-61910977' }
                ];
        
                var updateNews = customNews && customNews.length > 0 ? customNews : defaultNews;
        
                if (!settings.news.prefix.enable) {
                  for (i = 0; i < updateNews.length; i++) {
                    delete updateNews[i].prefix;
                  }
                }
                if (!settings.news.date.enable) {
                  for (i = 0; i < updateNews.length; i++) {
                    delete updateNews[i].date;
                  }
                }
                settings.data = updateNews;
            }
      
            var settings, themes;
            themes = [
          {
            label: {
              background: '#DA0037',
              color: '#EEE'
            },
            news: {
              background: '#EEE',
              heading: {
                color: '#171717'
              },
              separator: {
                background: '#DA0037'
              },
              prefix: {
                background: '#444',
                color: '#EEE'
              },
              date: {
                background: 'none',
                color: '#444'
              }
            },
            navigation: {
              background: '#171717',
              color: '#EEE',
              hover: '#EEE'
            }
          },
          {
            label: {
              background: '#DA0037',
              color: '#EEE'
            },
            news: {
              background: '#171717',
              heading: {
                color: '#EEE'
              },
              separator: {
                background: '#DA0037'
              },
              prefix: {
                background: '#DA0037',
                color: '#EEE'
              },
              date: {
                background: 'none',
                color: '#EEE'
              }
            },
            navigation: {
              background: '#EEEEEE',
              color: '#171717',
              hover: '#171717'
            }
          },
          {
            label: {
              background: '#1B1A17',
              color: '#F0A500'
            },
            news: {
              background: '#F0A500',
              heading: {
                color: '#1B1A17'
              },
              separator: {
                background: '#1B1A17'
              },
              prefix: {
                background: '#1B1A17',
                color: '#F0A500'
              },
              date: {
                background: 'none',
                color: '#1B1A17'
              }
            },
            navigation: {
              background: '#1B1A17',
              color: '#EEE',
              hover: '#F0A500'
            }
          },
          {
            label: {
              background: '#F0A500',
              color: '#1B1A17'
            },
            news: {
              background: '#1B1A17',
              heading: {
                color: '#EEE'
              },
              separator: {
                background: '#F0A500'
              },
              prefix: {
                background: '#EEE',
                color: '#1B1A17'
              },
              date: {
                background: 'none',
                color: '#F0A500'
              }
            },
            navigation: {
              background: '#EEE',
              color: '#1B1A17',
              hover: '#F0A500'
            }
          },
          {
            label: {
              background: '#222831',
              color: '#EEE'
            },
            news: {
              background: '#00ADB5',
              heading: {
                color: '#222831'
              },
              separator: {
                background: '#222831'
              },
              prefix: {
                background: '#EEE',
                color: '#00ADB5'
              },
              date: {
                background: 'none',
                color: '#222831'
              }
            },
            navigation: {
              background: '#222831',
              color: '#EEE',
              hover: '#00ADB5'
            }
          },
          {
            label: {
              background: '#00ADB5',
              color: '#EEE'
            },
            news: {
              background: '#222831',
              heading: {
                color: '#EEE'
              },
              separator: {
                background: '#00ADB5'
              },
              prefix: {
                background: '#EEE',
                color: '#00ADB5'
              },
              date: {
                background: 'none',
                color: '#EEE'
              }
            },
            navigation: {
              background: '#EEE',
              color: '#222831',
              hover: '#00ADB5'
            }
          },
          {
            label: {
              background: '#FF5722',
              color: '#EEE'
            },
            news: {
              background: '#303841',
              heading: {
                color: '#EEE'
              },
              separator: {
                background: '#FF5722'
              },
              prefix: {
                background: '#00ADB5',
                color: '#EEE'
              },
              date: {
                background: 'none',
                color: '#FF5722'
              }
            },
            navigation: {
              background: '#EEE',
              color: '#303841',
              hover: '#00ADB5'
            }
          },
          {
            label: {
              background: '#FF5722',
              color: '#EEE'
            },
            news: {
              background: '#EEEEEE',
              heading: {
                color: '#303841'
              },
              separator: {
                background: '#FF5722'
              },
              prefix: {
                background: '#00ADB5',
                color: '#EEE'
              },
              date: {
                background: 'none',
                color: '#FF5722'
              }
            },
            navigation: {
              background: '#303841',
              color: '#EEE',
              hover: '#00ADB5'
            }
          },
          {
            label: {
              background: '#EEE',
              color: '#FF5722'
            },
            news: {
              background: '#FF5722',
              heading: {
                color: '#222831'
              },
              separator: {
                background: '#222831'
              },
              prefix: {
                background: '#222831',
                color: '#EEE'
              },
              date: {
                background: 'none',
                color: '#222831'
              }
            },
            navigation: {
              background: '#303841',
              color: '#EEE',
              hover: '#FF5722'
            }
          },
          {
            label: {
              background: '#14274E',
              color: '#EEE'
            },
            news: {
              background: '#F1F6F9',
              heading: {
                color: '#14274E'
              },
              separator: {
                background: '#9BA4B4'
              },
              prefix: {
                background: '#9BA4B4',
                color: '#EEE'
              },
              date: {
                background: 'none',
                color: '#9BA4B4'
              }
            },
            navigation: {
              background: '#9BA4B4',
              color: '#14274E',
              hover: '#EEE'
            }
          }
        ];
    
            getSettings()

            $('#ent_wrapper_view').easyNewsTicker(settings);
      
    }
</script>

@endsection
