@extends('layouts/layoutMaster')

@section('title', 'Create Email Template')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss','resources/assets/vendor/libs/quill/katex.scss', 'resources/assets/vendor/libs/quill/editor.scss'])
@endsection

@section('vendor-script')
    @vite(['resources/assets/vendor/libs/quill/katex.js', 'resources/assets/vendor/libs/quill/quill.js'])
@endsection

@section('page-script')
   @vite(['resources/assets/js/form_email_editor.js'])
@endsection


@section('content')
    <div class="card">
        <div class="card-header border-bottom pb-1">
            <h5 class="card-title mb-1">Create Email Template</h5>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="{{ url('/dashboards') }}" class="d-flex align-items-center"><i
                                class="mdi mdi-home text-body fs-4"></i></a>
                    </li>
                    <span class="text-dark opacity-75 me-1 ms-1">
                        <i class="mdi mdi-chevron-double-right fs-4"></i>
                    </span>
                    <li class="breadcrumb-item">
                        <a href="javascript:;" class="d-flex align-items-center">Settings</a>
                    </li>
                    <span class="text-dark opacity-75 me-1 ms-1">
                        <i class="mdi mdi-chevron-double-right fs-4"></i>
                    </span>
                    <li class="breadcrumb-item">
                        <a href="javascript:;" class="d-flex align-items-center">Common</a>
                    </li>
                    <span class="text-dark opacity-75 me-1 ms-1">
                        <i class="mdi mdi-chevron-double-right fs-4"></i>
                    </span>
                    <li class="breadcrumb-item">
                        <a href="javascript:;" class="d-flex align-items-center">Email Template</a>
                    </li>
                </ol>
            </nav>
        </div>

        <div class="card-body">
            <!--begin::Heading-->
             <form id="addForm" action="/email_template_add" method="POST"  >
                @csrf
                <div class="row mt-4">
                        
                    <div class="col-lg-12 mb-3">
                        <label class="text-black mb-1 fs-6 fw-semibold">Email Template Name<span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="email_name" name='email_name' placeholder="Enter Subject Name" />
                        <div class="text-danger" id="email_name_err"></div>

                    </div>
                    <div class="col-lg-12 mb-3">
                        <label class="text-black mb-1 fs-6 fw-semibold">Subject of Email<span class="text-danger">*</span></label>
                        <input type="hidden" name="email_subject" id="email_subject">
                        <div class="col-lg-12">
                            <div id="create_exam_guideline_editor">
                                <div class="ql-editor" name="email_subject_text" id="email_subject_text" placeholder="Type Something..."></div>
                            </div>
                            <div class="text-danger" id="email_subject_err"></div>
                        </div>
                    </div>
                </div>
                <div class="d-flex justify-content-end align-items-center mt-4">
                    <a href="{{ url('/settings/email_template') }}" class="btn btn-secondary me-3">Cancel</a>
                    <button type="button" id="createbtn" class="btn btn-primary" onclick="addValidateForm()">Create Email
                        Template</button>
                </div>
            </form>
        </div>

    </div>
<script>
    function EditvalidateForm() {
        var exam_guidelines = $(".ql-editor").html().trim();
        var email_name = $("#email_name").val().trim();

       

        if (email_name == "") {
            $('#email_name_err').html('Enter Email Template Name is required...!');
            return false;
        } else {
            $('#email_name_err').html('');
        }
        if ($(".ql-editor").hasClass('ql-blank') || exam_guidelines === "" || exam_guidelines === '<p><br></p>') {
            $('#email_subject_err').html('Enter Subject of Email is required...!');
            return false;
        } else {
            $('#email_subject_err').html('');

            const data = exam_guidelines;
            $('#email_subject').val(data);
            return true;
        }
    }

    function addValidateForm() {
        let err = 0;
        var exam_guidelines = $(".ql-editor").html().trim();
        if (!$('#email_name').val()) { $('#email_name_err').text('Enter Email Template Name required'); err++; }
        else{
            $('#email_name_err').text('');
        } 

        if ($(".ql-editor").hasClass('ql-blank') || exam_guidelines === "" || exam_guidelines === '<p><br></p>') {
            $('#email_subject_err').text('Enter Subject of Email is required'); err++; 
        }
        else{
            $('#email_subject_err').text('');
        } 
        
        if (err > 0) return false;

        $('#createbtn').prop('disabled', true);
        const data = exam_guidelines;
        $('#email_subject').val(data);
        $('#addForm').submit();
    }

</script>


@endsection
