@extends('layouts/layoutMaster')
@section('style')
@section('title', 'Email Template')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/select2/select2.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
    @vite(['resources/assets/vendor/libs/select2/select2.js'])
@endsection

@section('content')

    <style>
        .credential-wrapper {
             min-height: 70vh;
        }

        /* Sidebar */
        .tab-sidebar {
            width: 250px;
            transition: all 0.3s ease;
            background: #fff;
            border-left: 1px solid #ddd;
        }

        .tab-sidebar.collapsed {
            width: 60px;
        }

        .tab-sidebar .nav-link {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px;
        }

        .tab-sidebar .nav-link i {
            font-size: 22px;
        }

        .nav-align-sideright .nav-link.active > label {
            background-color: #cfcfcf;
            color: #000;
            padding: 5px 8px;
            border-radius: 5px;
        }

        .tab-sidebar ul{
            /* align-items: end; */
        }
        

        /* Hide text when collapsed */
        .tab-sidebar.collapsed .tab-text {
            display: none;
        }
        .tab-sidebar.collapsed ul {
            align-items: center;
        }

        /* Toggle button */
        .toggle-btn {
            position: absolute;
            top: 15px;
            right: -15px;
            z-index: 10;
            background: #ab2b22;
            color: #fff;
            border: none;
            width: 30px;
            height: 30px;
            border-radius: 50%;
        }

        /* When sidebar collapsed */
        .tab-sidebar.collapsed + .tab-content .toggle-btn {
            right: -15px;
        }

        .tab-sidebar .right_nav{
            cursor:pointer !important;
            width:100%;
            display:flex;
            justify-content:end;
             align-items:center;
             gap:4px;
        }

        .tab-sidebar .right_nav:hover{
            color:#ab2b22 !important;
        }
    </style>

    <!-- Users List Table -->
    <div class="card">
        <div class="card-header pb-1">
           <ul class="nav nav-tabs flex-nowrap" role="tablist">
                <div class="scroll-container-wrapper">
                    <button class="scroll-btn left" id="scrollLeftBtn"><span class="scroll-arrow"><i
                                class="mdi mdi-chevron-left fs-2 text-white"></i></span></button>
                               
                    <div class="scroll-container" id="scrollContainer">
                        <li class="item nav-item">
                            <a href="{{ url('/settings/general_settings') }}"
                                type="button"
                                class="nav-link scroll-link "
                                role="tab">
                                General Settings
                            </a>
                        </li>        
                        <li class="item nav-item">
                            <a
                                href="{{ url('/settings/broadcast_theme') }}"
                                type="button"
                                class="nav-link scroll-link active"
                                aria-selected="true">
                                Common
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/credential_book') }}" type="button"
                                class="nav-link scroll-link ">
                                Entity
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/document') }}" type="button" class="nav-link scroll-link ">
                                HRM
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/applicant_status') }}" type="button"
                                class="nav-link scroll-link ">
                                Recruitment
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/interview_mode') }}" type="button"
                                class="nav-link scroll-link">
                                Interview
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/assessment/guidelines') }}" type="button"
                                class="nav-link scroll-link">
                                Assessment
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/department') }}" type="button"
                                class="nav-link scroll-link ">
                                Management
                            </a>
                        </li>
                        <li class="nav-item">
                                <a href="{{ url('/settings/business/department') }}" type="button"
                                    class="nav-link scroll-link ">
                                    Business
                                </a>
                            </li>

                        <li class="nav-item">
                            <a href="{{ url('/settings/api_config') }}" type="button"
                                class="nav-link scroll-link ">
                                API Config
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/admin/webhooks') }}" type="button"
                                class="nav-link scroll-link ">
                                Webhook Moniter
                            </a>
                        </li>
                    </div>
                    <button class="scroll-btn right" id="scrollRightBtn" style="display: block;"><i
                            class="mdi mdi-chevron-right fs-2 text-white"></i></button>
                </div>
            </ul>
        </div>
        <div class="card-body px-1 py-1">
            <div class="d-flex credential-wrapper">
                <!-- CONTENT -->
                <div class="tab-content flex-grow-1 position-relative">
                    <!-- Toggle Button -->
                    <button id="toggleSidebarSetting" class="toggle-btn toggle-right">
                        <i class="mdi mdi-chevron-right"></i>
                    </button>

                    <div class="d-flex align-items-center justify-content-between pb-0 mb-4 pt-0 mt-0" style="border-bottom: 1px solid gray;">
                        <div class="d-flex flex-column align-items-start">
                            <h5 class="card-title mb-1 text-black">Email Template</h5>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb custom-breadcrumb">
                                    <!-- Home -->
                                    <li class="breadcrumb-item">
                                        <a href="{{ url('/dashboard') }}">
                                            <i class="mdi mdi-cog"></i> Settings
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item" aria-current="page">
                                        <a href="javascript:void(0);">Common </a>
                                    </li>
                                    <li class="breadcrumb-item active" aria-current="page">
                                        <a href="javascript:void(0);" class="active-link">
                                            Email Template
                                        </a>
                                    </li>
                                </ol>
                            </nav>
                        </div>
                        <div class="d-flex justify-content-end align-items-center mb-2 gap-2">
                            
                            <a href="{{ url('/settings/email_template/email_template_add') }}"
                                class="btn btn-sm fw-bold btn-primary">
                                <span class="me-2"><i class="mdi mdi-plus"></i></span>Add Email Template
                            </a>
                        </div>
                    </div>        
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="d-flex align-items-center justify-content-between mb-4 ">
                                <div>
                                    <span>Show</span>
                                    <select id="perpage" class="form-select form-select-sm w-75px"
                                        onchange="loadThemes(1)">
                                        @php $options = [5,10, 25, 100, 500]; @endphp
                                        @foreach ($options as $option)
                                            <option value="{{ $option }}" {{ $perpage == $option ? 'selected' : '' }}>
                                                {{ $option }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="d-flex align-items-center justify-content-end flex-wrap gap-2">
                                    <div class="searchBar">
                                        <input type="text" id="search_filter" class="searchQueryInput"
                                            placeholder="Search Email Templat..."
                                            value="{{ $search_filter }}"/>
                                        
                                        <div class="searchAction">
                                            <div class="d-flex align-items-center">
                                                <a href="javascript:;"  class="searchSubmit" id="searchSubmit" >
                                                    <span class="mdi mdi-magnify fs-4 fw-bold"  style="color:#ab2b22;"></span>
                                                </a>
                                                <a href="javascript:;" class="refreshBar" id="refreshSearch" >
                                                    <span class="mdi mdi-refresh fs-4 fw-bold" style="color:#ab2b22;"></span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <table
                                class="table align-middle table-row-dashed table-striped table-hover gy-0 gs-1 list_page">
                                <thead>
                                    <tr class="text-start align-top fw-bold fs-6 gs-0 bg-primary">
                                        <th class="min-w-50px">S.No</th>
                                        <th class="min-w-100px">Email Template</th>
                                        <th class="min-w-50px">Status</th>
                                        <th class="min-w-50px">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="list-table-body" class="text-black fw-semibold fs-7">
                                   
                                    <tr class="skeleton-loader" id="skeleton-loader">
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="text-center my-3" id="pagination-container">
                            <!-- Pagination buttons will appear here -->
                        </div>
                    </div>
                </div>
                <!-- SIDEBAR -->
                <div id="tabSidebarSetting" class="tab-sidebar expanded right nav-align-sideright">
                    <ul class="nav nav-tabs flex-column" role="tablist">
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/broadcast_theme') }}" class="nav-link "  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Broadcast</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Broadcast"><i class="mdi mdi-broadcast fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/sms_template') }}" class="nav-link"  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">SMS Template</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="SMS Template"><i class="mdi mdi-message-processing fs-3"></i></span>
                                </label>
                                
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/email_template') }}" class="nav-link active"  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Email Template</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Email Template"><i class="mdi mdi-email fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/whatsapp_template') }}" class="nav-link" role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Whatsapp Template</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Whatsapp Template"><i class="mdi mdi-whatsapp fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/currency_format') }}" class="nav-link " role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Currency Format</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Currency Format"><i class="mdi mdi-currency-inr fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/country') }}" class="nav-link " role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Country</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Country"><i class="mdi mdi-map-legend fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/state') }}" class="nav-link" role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">State</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="State"><i class="mdi mdi-map-marker-radius fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/city') }}" class="nav-link " role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">City</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="City"><i class="mdi mdi mdi-city fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/timezone') }}" class="nav-link" role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Time Zone</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Time Zone"><i class="mdi mdi-web-clock fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/internal_cugs') }}" class="nav-link" role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Internal Cugs</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Internal Cugs"><i class="mdi mdi-phone-classic fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
   



    <!--begin::Modal - Delete Email Template-->
    <div class="modal fade" id="kt_modal_delete_email_template" tabindex="-1" aria-hidden="true"
        data-bs-keyboard="false" data-bs-backdrop="static">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-m">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <div class="swal2-icon swal2-danger swal2-icon-show" style="display: flex;">
                    <!-- <div class="swal2-icon-content"><i class="mdi mdi-trash fs-2 text-danger"></i></div> -->
                    <div>
                        <i class="fa-solid fa-trash text-danger" style="font-size: 35px;"></i>
                    </div>
                </div>
                <div class="swal2-html-container mb-4" id="swal2-html-container" style="display: block;">
                    <span id="delete_message">Are you sure you want to delete <br><b class="text-danger">Course
                            Friendly Payment Reminder – Invoice #invoice_id from EGC Global </b> Email template ?</span>
                </div>
                <div class="d-flex justify-content-center align-items-center pt-8 mb-4">
                    <button type="submit" class="btn btn-danger me-3" onclick="deleteFunc()">Yes,
                        delete!</button>
                    <button type="reset" class="btn btn-secondary text-black" data-bs-dismiss="modal">No,cancel</button>
                </div>
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - Delete Email Template-->


    <!-- Logo File Upload Start -->
    <!-- jQuery from CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Toastr CSS from CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <!-- Toastr JavaScript from CDN -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <style>
        /* Customize Toastr notification */
        .toast-success {
            background-color: green;
        }

        /* Customize Toastr notification */
        .toast-error {
            background-color: red;
        }
    </style>
  <script>
        // Display Toastr messages
            @if (Session::has('toastr'))
                var type = "{{ Session::get('toastr')['type'] }}";
                var message = "{{ Session::get('toastr')['message'] }}";
                toastr[type](message);
            @endif
    </script>
   

<script>
    let currentPage = 1;
    let isLoading = false;
    let abortController = new AbortController();

    function formatDate(date) {
        const options = { year: 'numeric', month: 'short', day: 'numeric', hour: '2-digit', minute: '2-digit', hour12: true };
        return new Date(date).toLocaleDateString('en-GB', options);
    }
   
    function buildRow(item,index) {
        return `
            <tr>
                <td><label class="fs-7 fw-medium">${index}</label></td>
                <td>
                    <label class="fs-7 fw-medium">${item.email_name}</label>
                </td>
                <td>
                    <label class="switch switch-square">
                        <input type="checkbox" class="switch-input" ${item.status == 0 ? 'checked' : ''} onchange="updatelevelStatus('${item.sno}', this.checked)"/>
                        <span class="switch-toggle-slider">
                            <span class="switch-on"></span>
                            <span class="switch-off"></span>
                        </span>
                    </label>
                </td>
                <td >
                    <span class="text-end">
                           <a href="{{ url('/settings/common/email_template/edit/${item.encrypted_id}') }}"
                                    data-bs-toggle="tooltip" data-bs-placement="bottom"
                                    title="Edit">
                                    <i class="mdi mdi-square-edit-outline fs-3 text-black"></i>
                            </a>
                        <button class="btn btn-icon btn-sm" type="button" 
                            data-bs-toggle="modal"
                            data-bs-target="#kt_modal_delete_email_template"
                            data-bs-toggle="tooltip" data-bs-placement="bottom"
                            title="Delete"  onclick="confirmDelete('${item.sno}', '${item.email_name}')">
                            <i class="mdi mdi-delete-outline fs-3 text-black"></i>
                        </button>
                    </span>
                </td>
            </tr>
        `;
    }
    function loadThemes(page = 1) {
        const perpage = document.getElementById('perpage').value;
        const search = document.getElementById('search_filter').value;
        const url = `/settings/email_template?page=${page}&sorting_filter=${perpage}&search_filter=${search}`;

        // Show skeleton loader and clear old data before fetching new data
        isLoading = true;
        document.getElementById('list-table-body').innerHTML = ''; // Clear old data
        document.getElementById('list-table-body').insertAdjacentHTML('beforeend', skeletenRow()); // Clear old data
        $('#skeleton-loader').show(); // Show skeleton loader

        if (abortController.signal) {
            abortController.abort(); // Abort the previous request
        }
        abortController = new AbortController();

         fetch(url, { headers: { 'X-Requested-With': 'XMLHttpRequest' }, signal: abortController.signal })
            .then(res => res.json())
            .then(res => {
                // Insert new data into the table
                if(res.data.length > 0){
                    res.data.forEach((item, index) => {
                        document.getElementById('list-table-body').insertAdjacentHTML('beforeend', buildRow(item, index + 1));
                    });

                }else{
                    document.getElementById('list-table-body').insertAdjacentHTML('beforeend', NoDataFound());
                }
                     $('[data-bs-toggle="tooltip"]').tooltip();

                // Update pagination and results info
                updatePagination(res.current_page, res.last_page, res.total, perpage);

                // Hide skeleton loader after data is fetched
                isLoading = false;
                $('#skeleton-loader').hide();
            })
            .catch(error => {
                if (error.name !== 'AbortError') { // Only handle abort error
                    console.error('Error loading data:', error);
                }
                // Hide skeleton loader in case of error
                $('#skeleton-loader').hide();
                isLoading = false;
            });
    }

    function skeletenRow(){
        return `
            <tr class="skeleton-loader" id="skeleton-loader">
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
            </tr>
            `;
    }

    function NoDataFound(){
        return `
            <tr><td colspan="4" class="text-center">No Data Found</td></tr>
            `;
    }

    function updatePagination(currentPage, lastPage, total, perpage) {
        let paginationContainer = document.getElementById('pagination-container');
        paginationContainer.innerHTML = ''; // Clear old pagination

        // Set the pagination container style
        paginationContainer.style.display = "flex";
        paginationContainer.style.justifyContent = "space-between";
        paginationContainer.style.alignItems = "center";

        // Showing result count info (e.g., Showing 1 to 25 of 3556 results)
        let start = (currentPage - 1) * perpage + 1;
        let end = Math.min(currentPage * perpage, total);
        let showingInfo = `Showing ${start} to ${end} of ${total} results`;
        paginationContainer.insertAdjacentHTML('beforeend', showingInfo);

        // Create Pagination Buttons

        // << First button
        let firstButton = `<li class="page-item ${currentPage === 1 ? 'disabled' : ''}" data-bs-toggle="tooltip" data-bs-placement="top" title="First Page"><button class=" page-link" onclick="loadThemes(1)" >«</button> </li>`;
        
        // < Previous button
        let prevButton = `<li class="page-item ${currentPage > 1 ? '' : 'disabled'}" data-bs-toggle="tooltip" data-bs-placement="top" title="Previous"><button class=" page-link" onclick="loadThemes(${currentPage - 1})" >‹</button> </li>`;
        
        // Next button
        let nextButton = `<li class="page-item ${currentPage < lastPage ? '' : 'disabled'}" data-bs-toggle="tooltip" data-bs-placement="top" title="Next"><button class="page-link" onclick="loadThemes(${currentPage + 1})" >›</button> </li>`;
        
        // >> Last button
        let lastButton = `<li class="page-item ${currentPage === lastPage ? 'disabled' : ''}" data-bs-toggle="tooltip" data-bs-placement="top" title="Last Page"><button class=" page-link" onclick="loadThemes(${lastPage})" >»</button> </li>`;

        // Page Number Buttons (Dynamically show a range of pages around the current page)
        let pageButtons = '';
        let range = 2; // Show 2 pages before and after the current page
        let startPage = Math.max(1, currentPage - range);
        let endPage = Math.min(lastPage, currentPage + range);

        // Generate page numbers
        for (let i = startPage; i <= endPage; i++) {
            pageButtons += `<li class="page-item ${i === currentPage ? 'active' : ''}"><button class="page-link " onclick="loadThemes(${i})">${i}</button> </li>`;
        }

        // Add the pagination buttons and page numbers
        paginationContainer.insertAdjacentHTML('beforeend', `
            <nav aria-label="Page navigation example">
                <ul class="pagination">
                    ${firstButton}
                    ${prevButton}
                    ${pageButtons}
                    ${nextButton}
                    ${lastButton}
                </ul>
            </nav>
        `);

        // Update perpage dropdown if changed
        document.getElementById('perpage').value = perpage;
    }

    function debounceSearch(e) {
        if (e.keyCode === 13) {
            loadThemes(1);  // Trigger the search when the user presses enter
        }
    }

    // Debounce function to handle input changes
    let debounceTimeout;
    function debounce(fn, delay) {
        return function() {
            clearTimeout(debounceTimeout);
            debounceTimeout = setTimeout(fn, delay);
        };
    };

  

    // SearchBar
    document.getElementById('search_filter').addEventListener('input', function() {
        const searchValue = document.getElementById('search_filter').value;
        if (searchValue) {
            document.getElementById('refreshSearch').style.display = 'inline-block';  // Show the refresh button
        } else {
            document.getElementById('refreshSearch').style.display = 'none';  // Hide the refresh button
        }
    });

     // Listen for changes in the perpage dropdown and reload data
    document.getElementById('perpage').addEventListener('change', () => loadThemes(1));

    // Listen for Enter key in the search filter and reload data
    document.getElementById('search_filter').addEventListener('keyup', debounceSearch);

    document.getElementById('refreshSearch').addEventListener('click', function() {
        document.getElementById('search_filter').value = '';  // Clear the search input
        loadThemes(1);  // Reload the table data without the search filter
    });
    document.getElementById('searchSubmit').addEventListener('click', function() {
        loadThemes(1);  // Reload the table data without the search filter
    });

    // Initial load
    loadThemes(1);

</script>

    <!-- status Change -->
 <script>
    function updatelevelStatus(Id, isChecked) {
        const status = isChecked ? 0 : 1;
        fetch(`/email_template_status/${Id}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}' // Include CSRF token
                },
                body: JSON.stringify({
                    status: status
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 200) {
                    toastr.success('Status Updated successfully!');
                    loadThemes(1);
                }
            })
            .catch(error => {});
    }
</script>

<!-- Delete Function -->
<script>
      function confirmDelete(id, name, sortname) {
  
          document.querySelector('#kt_modal_delete_email_template .btn-danger').setAttribute('data-id', id);
          $('#delete_message').html(
              'Are you sure you want to delete Email Template ?<br> <b class="text-black fw-bold fs-4">' +
              name +
              '</b>');
      }

      function deleteFunc() {
          var categoryId = document.querySelector('#kt_modal_delete_email_template .btn-danger').getAttribute('data-id');

          fetch('/email_template_delete/' + categoryId, {
                  method: 'DELETE',
                  headers: {
                      'Content-Type': 'application/json',
                      'X-CSRF-TOKEN': '{{ csrf_token() }}'
                  }
              })
              .then(response => response.json())
              .then(data => {
                  if (data.status === 200) {
                      toastr.success(data.message);
                      location.reload();
                  } else {
                      toastr.error(data.error_msg);
                  }
              })
              .catch(error => {

              });
      }
</script>


@endsection
