@extends('layouts/layoutMaster')
@section('style')
@section('title', 'Finacial Year')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/select2/select2.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
    @vite(['resources/assets/vendor/libs/select2/select2.js'])
@endsection

@section('content')

    <!-- Users List Table -->
    <div class="card">
        <div class="card-header pb-1">
            <ul class="nav nav-tabs flex-nowrap" role="tablist">
                <div class="scroll-container-wrapper">
                    <button class="scroll-btn left" id="scrollLeftBtn"><span class="scroll-arrow"><i
                                class="mdi mdi-chevron-left fs-2 text-white"></i></span></button>
                    <div class="scroll-container" id="scrollContainer">
                    <li class="item nav-item">
                        <a href="{{ url('/settings/general_settings') }}"
                            type="button"
                            class="nav-link scroll-link "
                            role="tab">
                            General Settings
                        </a>
                    </li>
                    <li class="item nav-item">
                        <a
                            href="{{ url('/settings/sms_template') }}"
                            type="button"
                            class="nav-link scroll-link active"
                            aria-selected="true">
                            Common
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/credential_book') }}" type="button"
                            class="nav-link scroll-link ">
                            Entity
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/document') }}" type="button" class="nav-link scroll-link ">
                            HRM
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/applicant_status') }}" type="button"
                            class="nav-link scroll-link ">
                            Recruitment
                        </a>
                    </li>
                    <li class="nav-item">
                            <a href="{{ url('/settings/department') }}" type="button"
                                class="nav-link scroll-link ">
                                Management
                            </a>
                        </li>
                    <li class="nav-item">
                            <a href="{{ url('/settings/business/department') }}" type="button"
                                class="nav-link scroll-link ">
                                Business
                            </a>
                        </li>
                    <li class="nav-item">
                        <a href="{{ url('/admin/webhooks') }}" type="button"
                            class="nav-link scroll-link ">
                            Webhook Moniter
                        </a>
                    </li>
                </div>
                    <button class="scroll-btn right" id="scrollRightBtn" style="display: block;"><i
                            class="mdi mdi-chevron-right fs-2 text-white"></i></button>
                </div>
            </ul>
        </div>
        <div class="card-body px-1 py-1">
            <div class="nav-align-right nav-tabs-shadow">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item">
                        <a href="{{ url('/settings/broadcast_theme') }}" type="button" class="nav-link " role="tab">
                            <label class="fs-6 right_nav">
                                Broadcast
                                <span><i class="mdi mdi-broadcast ms-2 fs-3"></i></span>
                            </label>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/sms_template') }}" type="button" class="nav-link" role="tab">
                            <label class="fs-6 right_nav">
                                SMS Template
                                <span><i class="mdi mdi-message-processing ms-2 fs-3"></i></span>
                            </label>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/email_template') }}" type="button" class="nav-link" role="tab">
                            <label class="fs-6 right_nav">
                                Email Template
                                <span><i class="mdi mdi-email ms-2 fs-3"></i></span>
                            </label>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/whatsapp_template') }}" type="button" class="nav-link " role="tab">
                            <label class="fs-6 right_nav">
                                Whatsapp Template
                                <span><i class="mdi mdi-whatsapp ms-2 fs-3"></i></span>
                            </label>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/finiancial_year') }}" type="button" class="nav-link active" role="tab">
                            <label class="fs-6 right_nav">
                                Finiancial Year
                                <span><i class="mdi mdi-finance ms-2 fs-3"></i></span>
                            </label>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/currency_format') }}" type="button" class="nav-link " role="tab">
                            <label class="fs-6 right_nav">
                                Currency Format
                                <span><i class="mdi mdi-currency-inr ms-2 fs-3"></i></span>
                            </label>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/country') }}" type="button" class="nav-link  " role="tab">
                            <label class="fs-6 right_nav">
                                Country
                                <span><i class="mdi mdi-map-legend ms-2 fs-3"></i></span>
                            </label>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/state') }}" type="button" class="nav-link " role="tab">
                            <label class="fs-6 right_nav">
                                State
                                <span><i class="mdi mdi-map-marker-radius ms-2 fs-3"></i></span>
                            </label>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/city') }}" type="button" class="nav-link " role="tab">
                            <label class="fs-6 right_nav">
                                City
                                <span><i class="mdi mdi-city ms-2 fs-3"></i></span>
                            </label>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/timezone') }}" type="button" class="nav-link " role="tab">
                            <label class="fs-6 right_nav">
                                Time Zone
                                <span><i class="mdi mdi-web-clock ms-2 fs-3"></i></span>
                            </label>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/internal_cugs') }}" type="button" class="nav-link " role="tab">
                            <label class="fs-6 right_nav">
                                Internal Cugs
                                <span><i class="mdi mdi-phone-classic ms-2 fs-3"></i></span>
                            </label>
                        </a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div class="d-flex align-items-center justify-content-between pb-0 mb-4 pt-0 mt-0" style="border-bottom: 1px solid gray;">
                        <div class="d-flex flex-column align-items-start">
                            <h5 class="card-title mb-1 text-black">Financial Year</h5>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb custom-breadcrumb">
                                    <!-- Home -->
                                    <li class="breadcrumb-item">
                                        <a href="{{ url('/dashboard') }}">
                                            <i class="mdi mdi-cog"></i> Settings
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item" aria-current="page">
                                        <a href="javascript:void(0);">Common </a>
                                    </li>
                                    <li class="breadcrumb-item active" aria-current="page">
                                        <a href="javascript:void(0);" class="active-link">
                                            Financial Year
                                        </a>
                                    </li>
                                </ol>
                            </nav>
                        </div>
                        <div class="d-flex justify-content-end align-items-center mb-2 gap-2">
                            <a href="#" class="btn btn-sm fw-bold btn-primary" data-bs-toggle="modal"
                                data-bs-target="#kt_modal_add_finiancial_year">
                                <span class="me-2"><i class="mdi mdi-plus"></i></span>Add Finiancial Year
                            </a>
                        </div>
                    </div>        
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="d-flex align-items-center justify-content-between gap-2 mb-2">
                                @php $perpage_count = $perpage ? $perpage : 10; @endphp
                                <div>
                                    <span>Show</span>
                                    <br>
                                    <select id="perpage" name="perpage" class="form-select form-select-sm w-60px" onchange="sort_filter(this.value);">
                                        @php
                                        $options = [10, 25, 100, 500]; // Define available options
                                        @endphp
                                        @php foreach ($options as $option): @endphp
                                        <option value="{{ $option }}" @php echo ($perpage_count == $option) ? 'selected' : ''; @endphp>
                                            @php echo $option; @endphp
                                        </option>
                                        @php endforeach; @endphp
                                    </select>
                                </div>
                                <form id="filter_form" method="POST" action="/settings/finiancial_year">
                                     @csrf
                                <div class="d-flex align-items-center justify-content-end flex-wrap gap-2">
                                    <div class="searchBar">
                                        <input type="hidden" name="page" value="{{ request('page', 1) }}">
                                            <input type="hidden" name="filter_on" value="1">
                                            <input type="hidden" class="sorting_filter_class" name="sorting_filter" id="sorting_filter" value="@php echo $perpage ? $perpage : 10; @endphp" />
                                        <input class="searchQueryInput" type="text"  placeholder="Enter Financial Year" id="search_filter" name="search_filter" value="{{ $search_filter ?? "" }}" />
                                        <button  class="searchQuerySubmit" type="submit" >
                                            <svg style="width:24px;height:24px" viewBox="0 0 24 24"><path fill="#ab2b22" d="M9.5,3A6.5,6.5 0 0,1 16,9.5C16,11.11 15.41,12.59 14.44,13.73L14.71,14H15.5L20.5,19L19,20.5L14,15.5V14.71L13.73,14.44C12.59,15.41 11.11,16 9.5,16A6.5,6.5 0 0,1 3,9.5A6.5,6.5 0 0,1 9.5,3M9.5,5C7,5 5,7 5,9.5C5,12 7,14 9.5,14C12,14 14,12 14,9.5C14,7 12,5 9.5,5Z" />
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                                </form>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <table
                                class="table align-middle table-row-dashed table-striped table-hover gy-0 gs-1 list_page">
                                <thead>
                                    <tr class="text-start align-top fw-bold fs-6 gs-0 bg-primary">
                                        <th class="min-w-50px">S.No</th>
                                        <th class="min-w-50px">Finiancial Year</th>
                                        <th class="min-w-100px">Month</th>
                                        <th class="min-w-50px">Status</th>
                                        <th class="min-w-50px">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (isset($financial_year))
                                    @php
                                    // Array of month names
                                    $months = [
                                    1 => 'January',
                                    2 => 'February',
                                    3 => 'March',
                                    4 => 'April',
                                    5 => 'May',
                                    6 => 'June',
                                    7 => 'July',
                                    8 => 'August',
                                    9 => 'September',
                                    10 => 'October',
                                    11 => 'November',
                                    12 => 'December',
                                    ];
                                    @endphp
                                    @foreach ($financial_year as $category)
                                    <tr>
                                        <td>
                                            <label class="fw-medium fs-7">{{ $loop->iteration }}</label>
                                        </td>
                                        <td>
                                            <label class="fs-7 fw-medium">{{ $category->financial_year_name }}</label>
                                            <a href="javascipt:;" data-bs-toggle="tooltip"
                                                data-bs-placement="right" title="-">
                                                <i class="mdi mdi mdi-help-circle text-dark"></i>
                                            </a>
                                        </td>
                                        <td>
                                            <label class="fs-7 max-w-150px text-truncate" data-bs-toggle="tooltip"
                                                data-bs-placement="right" title="
                                                @php
                                                    $monthsArray = json_decode($category->financial_month, true);
                                                    // Check if it's a valid array and has values
                                                    $monthNames = is_array($monthsArray) 
                                                        ? implode(', ', array_map(fn($m) => $months[(int)$m] ?? 'N/A', $monthsArray)) 
                                                        : 'N/A';
                                                @endphp
                                                {{ $monthNames }}
                                            ">
                                                {{ $monthNames }}
                                            </label>
                                        </td>
                                        <td>
                                            <label class="switch switch-square">
                                                <input type="checkbox" class="switch-input" {{ $category->status == 0 ? 'checked' : '' }} onchange="updateDepartmentStatus('{{ $category->sno }}', this.checked)" />
                                                <span class="switch-toggle-slider">
                                                    <span class="switch-on"></span>
                                                    <span class="switch-off"></span>
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <span class="text-end">
                                                <a href="#" data-bs-toggle="modal"
                                                    data-bs-target="#kt_modal_edit_finiancial_year"
                                                    data-bs-toggle="tooltip" data-bs-placement="bottom"
                                                    title="Edit" onclick="openEditModal('{{ $category->sno }}', '{{ $category->financial_year_name }}','{{ $category->financial_month }}','{{ $category->financial_year_desc }}',)">
                                                    <i class="mdi mdi-square-edit-outline fs-3 text-black"></i>
                                                </a>
                                                <a href="javascript:;" class="btn btn-icon btn-sm"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#kt_modal_delete_finiancial_year"
                                                    data-bs-toggle="tooltip" data-bs-placement="bottom"
                                                    title="Delete" onclick="confirmDelete('{{ $category->sno }}','{{ $category->financial_year_name }}','{{ $category->financial_year_id }}')">
                                                    <i class="mdi mdi-delete-outline fs-3 text-black"></i>
                                                </a>
                                            </span>
                                        </td>
                                    </tr>
                                    @endforeach
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!--begin::Modal - Add Finiancial Year -->
    <div class="modal fade" id="kt_modal_add_finiancial_year" tabindex="-1" aria-hidden="true"
        data-bs-keyboard="false" data-bs-backdrop="static" data-bs-focus="false">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-md">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div
                    class="modal-header d-flex align-items-center justify-content-between border border-bottom-1 pb-0 mb-4">
                    <div class="text-center mt-4">
                        <h3 class="text-center text-black">Create Finiancial Year</h3>
                    </div>
                    <!--begin::Close-->
                    <div class="btn btn-sm btn-icon btn-active-color-primary rounded" style="border: 2px solid #000;" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="#000" xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="#000" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="#000" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                    </div>
                    <!--end::Close-->
                </div>
                <!--end::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body pt-0 pb-10 px-10 px-xl-20">
                    <!--begin::Heading-->

                    <div class="row">
                        <!-- Basic -->
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold">Financial Year Name<span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="financial_name_add" name="financial_name"
                                placeholder="Enter Financial Year Name">
                            <div class="text-danger" id="financial_name_err"></div>
                        </div>
                        <div class="col-lg-12 mb-3" data-select2-id="11">
                            <label class="text-dark mb-1 fs-6 fw-semibold"> Months<span
                                    class="text-danger">*</span></label>
                            <select class="select3 form-select month_dropdown_add select2-hidden-accessible"
                                multiple="" id="month_dropdown_add" data-select2-id="month_dropdown_add"
                                tabindex="-1" aria-hidden="true">
                                <option value="">Select Months</option>
                                <option value="1">January</option>
                                <option value="2">February</option>
                                <option value="3">March</option>
                                <option value="4">April</option>
                                <option value="5">May</option>
                                <option value="6">June</option>
                                <option value="7">July</option>
                                <option value="8">August</option>
                                <option value="9">September</option>
                                <option value="10">October</option>
                                <option value="11">November</option>
                                <option value="12">December</option>
                            </select>
                        </div>

                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold">Description</label>
                            <textarea class="form-control" rows="1" name="financial_desc" placeholder="Enter Description"></textarea>
                        </div>
                    </div>
                    <div class="d-flex justify-content-between align-items-center mt-4">
                        <button type="reset" class="btn btn-outline-danger text-primary me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" id="create_sms_btn" class="btn btn-primary"
                            data-bs-dismiss="modal">Create
                            Finiancial Year</button>
                    </div>
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - Add Finiancial Year-->


    <!--begin::Modal - Edit Finiancial Year -->
    <div class="modal fade" id="kt_modal_edit_finiancial_year" tabindex="-1" aria-hidden="true"
        data-bs-keyboard="false" data-bs-backdrop="static" data-bs-focus="false">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-md">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div
                    class="modal-header d-flex align-items-center justify-content-between border border-bottom-1 pb-0 mb-4">
                    <div class="text-center mt-4">
                        <h3 class="text-center text-black">Update Finiancial Year</h3>
                    </div>
                    <!--begin::Close-->
                    <div class="btn btn-sm btn-icon btn-active-color-primary rounded" style="border: 2px solid #000;" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="#000" xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="#000" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="#000" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                    </div>
                    <!--end::Close-->
                </div>
                <!--end::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body pt-0 pb-10 px-10 px-xl-20">
                    <!--begin::Heading-->

                    <div class="row">
                        <!-- Basic -->
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold">Financial Year Name<span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="financial_name_add" name="financial_name"
                                placeholder="Enter Financial Year Name" value="2024">

                        </div>
                        <div class="col-lg-12 mb-3" data-select2-id="11">
                            <label class="text-dark mb-1 fs-6 fw-semibold"> Months<span
                                    class="text-danger">*</span></label>
                            <select class="select3 form-select month_dropdown_edit select2-hidden-accessible"
                                multiple="" id="month_dropdown_edit" data-select2-id="month_dropdown_edit"
                                tabindex="-1" aria-hidden="true">
                                <option value="">Select Months</option>
                                <option value="1">January</option>
                                <option value="2">February</option>
                                <option value="3" selected>March</option>
                                <option value="4">April</option>
                                <option value="5" selected>May</option>
                                <option value="6">June</option>
                                <option value="7"selected>July</option>
                                <option value="8">August</option>
                                <option value="9" selected>September</option>
                                <option value="10">October</option>
                                <option value="11">November</option>
                                <option value="12">December</option>
                            </select>
                        </div>

                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold">Description</label>
                            <textarea class="form-control" rows="1" name="financial_desc" placeholder="Enter Description">-</textarea>
                        </div>
                    </div>
                    <div class="d-flex justify-content-between align-items-center mt-4">
                        <button type="reset" class="btn btn-outline-danger text-primary me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" id="create_sms_btn" class="btn btn-primary"
                            data-bs-dismiss="modal">Update Finiancial Year</button>
                    </div>
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - Edit Finiancial Year-->

    <!--begin::Modal - Delete Finiancial Year-->
    <div class="modal fade" id="kt_modal_delete_finiancial_year" tabindex="-1" aria-hidden="true"
        data-bs-keyboard="false" data-bs-backdrop="static">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-m">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <div class="swal2-icon swal2-danger swal2-icon-show" style="display: flex;">
                    <!-- <div class="swal2-icon-content"><i class="mdi mdi-trash fs-2 text-danger"></i></div> -->
                    <div>
                        <i class="fa-solid fa-trash text-danger" style="font-size: 35px;"></i>
                    </div>
                </div>
                <div class="swal2-html-container mb-4" id="swal2-html-container" style="display: block;">
                    <span id="delete_message">Are you sure you want to delete <br><b class="text-danger">2024 </b>
                        Finiancial Year ?</span>
                </div>
                <div class="d-flex justify-content-center align-items-center pt-8 mb-4">
                    <button type="submit" class="btn btn-danger me-3" data-bs-dismiss="modal">Yes,
                        delete!</button>
                    <button type="reset" class="btn btn-secondary text-black" data-bs-dismiss="modal">No,cancel</button>
                </div>
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - Delete Finiancial Year-->




    <!-- Logo File Upload Start -->
    <!-- jQuery from CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Toastr CSS from CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <!-- Toastr JavaScript from CDN -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <style>
        /* Customize Toastr notification */
        .toast-success {
            background-color: green;
        }

        /* Customize Toastr notification */
        .toast-error {
            background-color: red;
        }
    </style>
<script>
    // Display Toastr messages
    @if(Session::has('toastr'))
    var type = "{{ Session::get('toastr')['type'] }}";
    var message = "{{ Session::get('toastr')['message'] }}";
    toastr[type](message);
    @endif

</script>
<script>
    function AddvalidateForm_department() {
        var err = 0;

        // Validate department Name
        var financial_name_add = document.getElementById("financial_name_add").value.trim();
        if (financial_name_add === "") {
            document.getElementById('financial_name_err').innerHTML = 'Enter Financial year is required...!';
            err++;
        } else {
            document.getElementById('financial_name_add').classList.remove('error_msg');
            document.getElementById('financial_name_err').innerHTML = '';
        }
        //Course Type
        var month_dropdown = $("#month_dropdown").val();
        if (month_dropdown == "") {
            $('#month_dropdown_err').html('Enter Financial Month is required...!');

            err++;
        } else {
            $('#month_dropdown_err').html('');
        }

        return err === 0; // Returns true if there are no errors
    }

</script>
<script>
    function EditvalidateForm_department() {
        var err = 0;

        // Validate branchtype Name
        var edit_financial_name = document.getElementById("edit_financial_name").value.trim();
        if (edit_financial_name === "") {
            document.getElementById('edit_financial_name_err').innerHTML = 'Enter Referral is required..!';
            err++;
        } else {
            document.getElementById('edit_financial_name').classList.remove('error_msg');
            document.getElementById('edit_financial_name_err').innerHTML = '';
        }
        //Course Type
        var edit_month_dropdown = $("#edit_month_dropdown").val();
        if (edit_month_dropdown == "") {
            $('#edit_month_dropdown_err').html('Enter Financial Month is required...!');

            err++;
        } else {
            $('#edit_month_dropdown_err').html('');
        }

        return err === 0; // Returns true if there are no errors
    }

</script>

<script>
    function openEditModal(sno, financial_year_name, financial_month, financial_year_desc) {
        console.log(financial_month);

        // Set the values for the other fields
        document.getElementById('edit_financial_year_Id').value = sno;
        document.getElementById('edit_financial_name').value = financial_year_name;
        document.getElementById('edit_financial_desc').value = financial_year_desc;

        // Clear previous selections
        const monthDropdown = document.getElementById('edit_month_dropdown');
        Array.from(monthDropdown.options).forEach(option => {
            option.selected = false; // Deselect all options
        });

        // Decode financial_month if it's a JSON string
        let monthsArray;
        try {
            monthsArray = JSON.parse(financial_month); // Decode the JSON string
        } catch (e) {
            console.error("Invalid financial_month format:", e);
            return; // Exit if parsing fails
        }

        // Select the options
        monthsArray.forEach(month => {
            const option = Array.from(monthDropdown.options).find(opt => opt.value === month.toString()); // Ensure comparison is string-based
            if (option) {
                option.selected = true; // Select the option
            }
        });
        monthDropdown.dispatchEvent(new Event('change'));
    }

</script>
<script>
    function updateDepartmentStatus(categoryId, isChecked) {
        const status = isChecked ? 0 : 1; // Set status based on checkbox state

        fetch(`/financial_year_status/${categoryId}`, {
                method: 'POST'
                , headers: {
                    'Content-Type': 'application/json'
                    , 'X-CSRF-TOKEN': '{{ csrf_token() }}' // Include CSRF token
                }
                , body: JSON.stringify({
                    status: status
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 200) {
                    //console.log('Referral status updated successfully:', data.message);
                    toastr.success('Financial Year status Updated successfully!');
                } else {
                    console.error('Error updating Financial Year status:', data.message);
                    toastr.error('Error updating Financial Year status');
                }
            })
            .catch(error => {
                console.error('Error updating Financial Year status:', error);
            });
    }

</script>
<script>
    function confirmDelete(id, name, ids) {
        document.querySelector('#kt_modal_delete_department .btn-danger').setAttribute(
            'data-id', id);
        $('#delete_message').html('Are you sure you want to delete <br> <b class="text-danger"> ' + name +
            '</b> Department ?');
    }

    function deleteDepartmentCategory() {

        var categoryId = document.querySelector('#kt_modal_delete_department .btn-danger').getAttribute('data-id');

        fetch('/financial_year_delete/' + categoryId, {
                method: 'DELETE'
                , headers: {
                    'Content-Type': 'application/json'
                    , 'X-CSRF-TOKEN': '{{ csrf_token() }}'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 200) {
                    toastr.success('Referral Deleted successfully!');
                    location.reload();

                } else {

                    console.error(data.error_msg);
                }
            })
            .catch(error => {
                console.error('Error:', error);
            });
    }

    

</script>
@endsection
