@extends('layouts/layoutMaster')
@section('style')
@section('title', 'TimeZone')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/select2/select2.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
    @vite(['resources/assets/vendor/libs/select2/select2.js'])
@endsection

@section('content')

    <style>
        .credential-wrapper {
             min-height: 70vh;
        }

        /* Sidebar */
        .tab-sidebar {
             width: 250px;
            transition: all 0.3s ease;
            background: #fff;
            border-left: 1px solid #ddd;
        }

        .tab-sidebar.collapsed {
            width: 60px;
        }

        .tab-sidebar .nav-link {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px;
        }

        .tab-sidebar .nav-link i {
            font-size: 22px;
        }

        .nav-align-sideright .nav-link.active > label {
            background-color: #cfcfcf;
            color: #000;
            padding: 5px 8px;
            border-radius: 5px;
        }

        .tab-sidebar ul{
            /* align-items: end; */
        }
        

        /* Hide text when collapsed */
        .tab-sidebar.collapsed .tab-text {
            display: none;
        }
        .tab-sidebar.collapsed ul {
            align-items: center;
        }

        /* Toggle button */
        .toggle-btn {
            position: absolute;
            top: 15px;
            right: -15px;
            z-index: 10;
            background: #ab2b22;
            color: #fff;
            border: none;
            width: 30px;
            height: 30px;
            border-radius: 50%;
        }

        /* When sidebar collapsed */
        .tab-sidebar.collapsed + .tab-content .toggle-btn {
            right: -15px;
        }

        .tab-sidebar .right_nav{
            cursor:pointer !important;
            width:100%;
            display:flex;
            justify-content:end;
             align-items:center;
             gap:4px;
        }

        .tab-sidebar .right_nav:hover{
            color:#ab2b22 !important;
        }
    </style>

    <!-- Users List Table -->
    <div class="card">
        <div class="card-header pb-1">
            <ul class="nav nav-tabs flex-nowrap" role="tablist">
                <div class="scroll-container-wrapper">
                    <button class="scroll-btn left" id="scrollLeftBtn"><span class="scroll-arrow"><i
                                class="mdi mdi-chevron-left fs-2 text-white"></i></span></button>
                               
                    <div class="scroll-container" id="scrollContainer">
                        <li class="item nav-item">
                            <a href="{{ url('/settings/general_settings') }}"
                                type="button"
                                class="nav-link scroll-link "
                                role="tab">
                                General Settings
                            </a>
                        </li>        
                        <li class="item nav-item">
                            <a
                                href="{{ url('/settings/broadcast_theme') }}"
                                type="button"
                                class="nav-link scroll-link active"
                                aria-selected="true">
                                Common
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/credential_book') }}" type="button"
                                class="nav-link scroll-link ">
                                Entity
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/document') }}" type="button" class="nav-link scroll-link ">
                                HRM
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/applicant_status') }}" type="button"
                                class="nav-link scroll-link ">
                                Recruitment
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/interview_mode') }}" type="button"
                                class="nav-link scroll-link">
                                Interview
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/assessment/guidelines') }}" type="button"
                                class="nav-link scroll-link">
                                Assessment
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/department') }}" type="button"
                                class="nav-link scroll-link ">
                                Management
                            </a>
                        </li>
                        <li class="nav-item">
                                <a href="{{ url('/settings/business/department') }}" type="button"
                                    class="nav-link scroll-link ">
                                    Business
                                </a>
                            </li>

                        <li class="nav-item">
                            <a href="{{ url('/settings/api_config') }}" type="button"
                                class="nav-link scroll-link ">
                                API Config
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/admin/webhooks') }}" type="button"
                                class="nav-link scroll-link ">
                                Webhook Moniter
                            </a>
                        </li>
                    </div>
                    <button class="scroll-btn right" id="scrollRightBtn" style="display: block;"><i
                            class="mdi mdi-chevron-right fs-2 text-white"></i></button>
                </div>
            </ul>
        </div>
        <div class="card-body px-1 py-1">
            <div class="d-flex credential-wrapper">
                <!-- CONTENT -->
                <div class="tab-content flex-grow-1 position-relative">
                    <!-- Toggle Button -->
                    <button id="toggleSidebarSetting" class="toggle-btn toggle-right">
                        <i class="mdi mdi-chevron-right"></i>
                    </button>
                    
                    <div class ="d-flex align-items-center justify-content-between pb-0 mb-4 pt-0 mt-0" style="border-bottom: 1px solid gray;">
                        <div class="d-flex flex-column align-items-start">
                            <h5 class="card-title mb-1 text-black">Timezone</h5>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb custom-breadcrumb">
                                    <!-- Home -->
                                    <li class="breadcrumb-item">
                                        <a href="{{ url('/dashboard') }}">
                                            <i class="mdi mdi-cog"></i> Settings
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item" aria-current="page">
                                        <a href="javascript:void(0);">Common </a>
                                    </li>
                                    <li class="breadcrumb-item active" aria-current="page">
                                        <a href="javascript:void(0);" class="active-link">
                                            Timezone
                                        </a>
                                    </li>
                                </ol>
                            </nav>
                        </div>
                        <div class="d-flex justify-content-end align-items-center mb-2 gap-2">
                            <a href="#" class="btn btn-sm fw-bold btn-primary" data-bs-toggle="modal"
                                data-bs-target="#kt_modal_add_TimeZone">
                                <span class="me-2"><i class="mdi mdi-plus"></i></span>Add TimeZone
                            </a>
                        </div>
                    </div>        
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="d-flex align-items-center justify-content-between mb-4 ">
                                <div>
                                    <span>Show</span>
                                    <select id="perpage" class="form-select form-select-sm w-75px"
                                        onchange="loadThemes(1)">
                                        @php $options = [5,10, 25, 100, 500]; @endphp
                                        @foreach ($options as $option)
                                            <option value="{{ $option }}" {{ $perpage == $option ? 'selected' : '' }}>
                                                {{ $option }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="d-flex align-items-center justify-content-end flex-wrap gap-2">
                                    <div class="searchBar">
                                        <input type="text" id="search_filter" class="searchQueryInput"
                                            placeholder="Search Time zone /country.."
                                            value="{{ $search_filter }}"/>
                                        
                                        <div class="searchAction">
                                            <div class="d-flex align-items-center">
                                                <a href="javascript:;"  class="searchSubmit" id="searchSubmit" >
                                                    <span class="mdi mdi-magnify fs-4 fw-bold"  style="color:#ab2b22;"></span>
                                                </a>
                                                <a href="javascript:;" class="refreshBar" id="refreshSearch" >
                                                    <span class="mdi mdi-refresh fs-4 fw-bold" style="color:#ab2b22;"></span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <table
                                class="table align-middle table-row-dashed table-striped table-hover gy-0 gs-1 list_page">
                                <thead>
                                    <tr class="text-start align-top fw-bold fs-6 gs-0 bg-primary">
                                        <th class="min-w-50px">S.No</th>
                                        <th class="min-w-100px">TimeZone</th>
                                        <th class="min-w-50px">UTC Offset</th>
                                        <th class="min-w-100px">Country</th>
                                        <th class="min-w-50px">Status</th>
                                        <th class="min-w-50px">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="list-table-body" class="text-black fw-semibold fs-7">
                                    <tr class="skeleton-loader" id="skeleton-loader">
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="text-center my-3" id="pagination-container">
                            <!-- Pagination buttons will appear here -->
                        </div>
                    </div>
                </div>
                <!-- SIDEBAR -->
                <div id="tabSidebarSetting" class="tab-sidebar expanded right nav-align-sideright">
                    <ul class="nav nav-tabs flex-column" role="tablist">
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/broadcast_theme') }}" class="nav-link "  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Broadcast</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Broadcast"><i class="mdi mdi-broadcast fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/sms_template') }}" class="nav-link "  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">SMS Template</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="SMS Template"><i class="mdi mdi-message-processing fs-3"></i></span>
                                </label>
                                
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/email_template') }}" class="nav-link "  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Email Template</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Email Template"><i class="mdi mdi-email fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/whatsapp_template') }}" class="nav-link" role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Whatsapp Template</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Whatsapp Template"><i class="mdi mdi-whatsapp fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/currency_format') }}" class="nav-link " role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Currency Format</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Currency Format"><i class="mdi mdi-currency-inr fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/country') }}" class="nav-link " role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Country</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Country"><i class="mdi mdi-map-legend fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/state') }}" class="nav-link " role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">State</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="State"><i class="mdi mdi-map-marker-radius fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/city') }}" class="nav-link " role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">City</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="City"><i class="mdi mdi mdi-city fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/timezone') }}" class="nav-link active" role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Time Zone</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Time Zone"><i class="mdi mdi-web-clock fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/internal_cugs') }}" class="nav-link " role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Internal Cugs</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Internal Cugs"><i class="mdi mdi-phone-classic fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            
        </div>
    </div>


    <!--begin::Modal - Add TimeZone -->
    <div class="modal fade" id="kt_modal_add_TimeZone" tabindex="-1" aria-hidden="true" data-bs-keyboard="false"
        data-bs-backdrop="static" data-bs-focus="false">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-md">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div
                    class="modal-header d-flex align-items-center justify-content-between border border-bottom-1 pb-0 mb-4">
                    <div class="text-center mt-4">
                        <h3 class="text-center text-black">Create TimeZone</h3>
                    </div>
                    <!--begin::Close-->
                    <div class="btn btn-sm btn-icon btn-active-color-primary rounded" style="border: 2px solid #000;" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="#000" xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="#000" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="#000" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                    </div>
                    <!--end::Close-->
                </div>
                <!--end::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body pt-0 pb-10 px-10 px-xl-20">
                    <!--begin::Heading-->
                    <form id="addForm" action="{{ route('add_time_zone') }}" method="POST" >
                            @csrf
                    <div class="row">
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold">Country<span
                                    class="text-danger">*</span></label>
                            <select id="country_id" name="country_id" class="select3 form-select ">
                                <option value="">Select Country</option>
                            </select>
                            <div class="text-danger" id="country_id_err"></div>
                        </div>
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold">Time Zone Name<span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control" placeholder="Enter Time Zone" id="time_zone" name="time_zone">
                            <div class="text-danger" id="time_zone_err"></div>
                        </div>
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold">UTC Offset<span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control" placeholder="Enter UTC Offset" id="utc_offset" name="utc_offset">
                            <div class="text-danger" id="utc_offset_err"></div>
                        </div>
                    </div>
                    <div class="d-flex justify-content-between align-items-center mt-4">
                        <button type="reset" class="btn btn-outline-danger text-primary me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" id="createbtn" class="btn btn-primary" onclick="addValidateForm()">Create
                            TimeZone</button>
                    </div>
                    </form>
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - Add TimeZone-->


    <!--begin::Modal - Edit TimeZone -->
    <div class="modal fade" id="kt_modal_edit_TimeZone" tabindex="-1" aria-hidden="true" data-bs-keyboard="false"
        data-bs-backdrop="static" data-bs-focus="false">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-md">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div
                    class="modal-header d-flex align-items-center justify-content-between border border-bottom-1 pb-0 mb-4">
                    <div class="text-center mt-4">
                        <h3 class="text-center text-black">Update TimeZone</h3>
                    </div>
                    <!--begin::Close-->
                    <div class="btn btn-sm btn-icon btn-active-color-primary rounded" style="border: 2px solid #000;" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="#000" xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="#000" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="#000" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                    </div>
                    <!--end::Close-->
                </div>
                <!--end::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body pt-0 pb-10 px-10 px-xl-20">
                    <!--begin::Heading-->
                    <form id="updateForm" action="{{ route('time_zone_update') }}" method="POST" >
                    @csrf
                    <div class="row">
                         <input type="hidden" id="edit_id" name="edit_id">
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold">Country<span
                                    class="text-danger">*</span></label>
                            <select id="country_id_edit" name="country_id" class="select3 form-select ">
                                <option value="">Select Country</option>
                            </select>
                            <div class="text-danger" id="country_id_edit_err"></div>
                        </div>
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold">Time Zone Name<span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control" placeholder="Enter Time Zone" id="time_zone_edit" name="time_zone" value="Africa/Cairo">
                            <div class="text-danger" id="time_zone_edit_err"></div>
                        </div>
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold">UTC Offset<span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control" placeholder="Enter UTC Offset" value="+02:00" id="utc_offset_edit" name="utc_offset">
                             <div class="text-danger" id="utc_offset_edit_err"></div>
                        </div>
                    </div>
                    <div class="d-flex justify-content-between align-items-center mt-4">
                        <button type="reset" class="btn btn-outline-danger text-primary me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" id="updatebtn" class="btn btn-primary"
                            onclick="editValidateForm()">Update TimeZone</button>
                    </div>
                    </form>
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - Edit TimeZone-->

    <!--begin::Modal - Delete TimeZone-->
    <div class="modal fade" id="kt_modal_delete_TimeZone" tabindex="-1" aria-hidden="true" data-bs-keyboard="false"
        data-bs-backdrop="static">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-m">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <div class="swal2-icon swal2-danger swal2-icon-show" style="display: flex;">
                    <!-- <div class="swal2-icon-content"><i class="mdi mdi-trash fs-2 text-danger"></i></div> -->
                    <div>
                        <i class="fa-solid fa-trash text-danger" style="font-size: 35px;"></i>
                    </div>
                </div>
                <div class="swal2-html-container mb-4" id="swal2-html-container" style="display: block;">
                    <span id="delete_message">Are you sure you want to delete <br><b class="text-danger">Bahamas </b>
                        TimeZone ?</span>
                </div>
                <div class="d-flex justify-content-center align-items-center pt-8 mb-4">
                    <button type="submit" class="btn btn-danger me-3" onclick="deleteFunc()">Yes,
                        delete!</button>
                    <button type="reset" class="btn btn-secondary text-black" data-bs-dismiss="modal">No,cancel</button>
                </div>
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - Delete TimeZone-->




    <!-- Logo File Upload Start -->
    <!-- jQuery from CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Toastr CSS from CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <!-- Toastr JavaScript from CDN -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <style>
        /* Customize Toastr notification */
        .toast-success {
            background-color: green;
        }

        /* Customize Toastr notification */
        .toast-error {
            background-color: red;
        }
    </style>
<script>
    // Display Toastr messages
        @if (Session::has('toastr'))
            var type = "{{ Session::get('toastr')['type'] }}";
            var message = "{{ Session::get('toastr')['message'] }}";
            toastr[type](message);
        @endif
</script>
<script>
    let currentPage = 1;
    let isLoading = false;
    let abortController = new AbortController();

    function formatDate(date) {
        const options = { year: 'numeric', month: 'short', day: 'numeric', hour: '2-digit', minute: '2-digit', hour12: true };
        return new Date(date).toLocaleDateString('en-GB', options);
    }
   
    function buildRow(item,index) {        
        return `
            <tr>
                <td><label class="fs-7 fw-medium">${index}</label></td>
                <td>
                    <label class="fs-7 fw-medium">${item.time_zone}</label>
                </td>
                <td>
                    <label class="badge bg-label-success fs-6 fw-medium text-black border  border-dark">${item.utc_offset}</label>
                </td>
                <td><label class="fs-7 fw-medium">${item.country_name}</label></td>
                <td>
                    <label class="switch switch-square">
                        <input type="checkbox" class="switch-input" ${item.status == 0 ? 'checked' : ''} onchange="updatelevelStatus('${item.sno}', this.checked)"/>
                        <span class="switch-toggle-slider">
                            <span class="switch-on"></span>
                            <span class="switch-off"></span>
                        </span>
                    </label>
                </td>
                <td >
                    <span class="text-end">
                        <button class="btn btn-icon btn-sm" type="button" data-bs-toggle="modal"
                            data-bs-target="#kt_modal_edit_TimeZone"
                            data-bs-toggle="tooltip" data-bs-placement="bottom"
                            title="Edit" onclick="openEditModal('${JSON.stringify(item.data).replace(/'/g, "\\'")}')">
                            <i class="mdi mdi-square-edit-outline fs-3 text-black"></i>
                        </button>
                        <button class="btn btn-icon btn-sm" type="button" 
                            data-bs-toggle="modal"
                            data-bs-target="#kt_modal_delete_TimeZone"
                            data-bs-toggle="tooltip" data-bs-placement="bottom"
                            title="Delete"  onclick="confirmDelete('${item.sno}', '${item.time_zone}','${item.utc_offset}', '${item.country_name}')">
                            <i class="mdi mdi-delete-outline fs-3 text-black"></i>
                        </button>
                    </span>
                </td>
            </tr>
        `;
    }
    function loadThemes(page = 1) {
        const perpage = document.getElementById('perpage').value;
        const search = document.getElementById('search_filter').value;
        const url = `/settings/timezone?page=${page}&sorting_filter=${perpage}&search_filter=${search}`;

        // Show skeleton loader and clear old data before fetching new data
        isLoading = true;
        document.getElementById('list-table-body').innerHTML = ''; // Clear old data
        document.getElementById('list-table-body').insertAdjacentHTML('beforeend', skeletenRow()); // Clear old data
        $('#skeleton-loader').show(); // Show skeleton loader

        if (abortController.signal) {
            abortController.abort(); // Abort the previous request
        }
        abortController = new AbortController();

         fetch(url, { headers: { 'X-Requested-With': 'XMLHttpRequest' }, signal: abortController.signal })
            .then(res => res.json())
            .then(res => {
                // Insert new data into the table
                if(res.data.length > 0){
                    res.data.forEach((item, index) => {
                        document.getElementById('list-table-body').insertAdjacentHTML('beforeend', buildRow(item, index + 1));
                    });

                }else{
                    document.getElementById('list-table-body').insertAdjacentHTML('beforeend', NoDataFound());
                }

                 $('[data-bs-toggle="tooltip"]').tooltip();
                // Update pagination and results info
                updatePagination(res.current_page, res.last_page, res.total, perpage);

                // Hide skeleton loader after data is fetched
                isLoading = false;
                $('#skeleton-loader').hide();
            })
            .catch(error => {
                if (error.name !== 'AbortError') { // Only handle abort error
                    console.error('Error loading data:', error);
                }
                // Hide skeleton loader in case of error
                $('#skeleton-loader').hide();
                isLoading = false;
            });
    }

    function skeletenRow(){
        return `
            <tr class="skeleton-loader" id="skeleton-loader">
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
            </tr>
            `;
    }

    function NoDataFound(){
        return `
            <tr><td colspan="6" class="text-center">No Data Found</td></tr>
            `;
    }

    function updatePagination(currentPage, lastPage, total, perpage) {
        let paginationContainer = document.getElementById('pagination-container');
        paginationContainer.innerHTML = ''; // Clear old pagination

        // Set the pagination container style
        paginationContainer.style.display = "flex";
        paginationContainer.style.justifyContent = "space-between";
        paginationContainer.style.alignItems = "center";

        // Showing result count info (e.g., Showing 1 to 25 of 3556 results)
        let start = (currentPage - 1) * perpage + 1;
        let end = Math.min(currentPage * perpage, total);
        let showingInfo = `Showing ${start} to ${end} of ${total} results`;
        paginationContainer.insertAdjacentHTML('beforeend', showingInfo);

        // Create Pagination Buttons

        // << First button
        let firstButton = `<li class="page-item ${currentPage === 1 ? 'disabled' : ''}" data-bs-toggle="tooltip" data-bs-placement="top" title="First Page"><button class=" page-link" onclick="loadThemes(1)" >«</button> </li>`;
        
        // < Previous button
        let prevButton = `<li class="page-item ${currentPage > 1 ? '' : 'disabled'}" data-bs-toggle="tooltip" data-bs-placement="top" title="Previous"><button class=" page-link" onclick="loadThemes(${currentPage - 1})" >‹</button> </li>`;
        
        // Next button
        let nextButton = `<li class="page-item ${currentPage < lastPage ? '' : 'disabled'}" data-bs-toggle="tooltip" data-bs-placement="top" title="Next"><button class="page-link" onclick="loadThemes(${currentPage + 1})" >›</button> </li>`;
        
        // >> Last button
        let lastButton = `<li class="page-item ${currentPage === lastPage ? 'disabled' : ''}" data-bs-toggle="tooltip" data-bs-placement="top" title="Last Page"><button class=" page-link" onclick="loadThemes(${lastPage})" >»</button> </li>`;

        // Page Number Buttons (Dynamically show a range of pages around the current page)
        let pageButtons = '';
        let range = 2; // Show 2 pages before and after the current page
        let startPage = Math.max(1, currentPage - range);
        let endPage = Math.min(lastPage, currentPage + range);

        // Generate page numbers
        for (let i = startPage; i <= endPage; i++) {
            pageButtons += `<li class="page-item ${i === currentPage ? 'active' : ''}"><button class="page-link " onclick="loadThemes(${i})">${i}</button> </li>`;
        }

        // Add the pagination buttons and page numbers
        paginationContainer.insertAdjacentHTML('beforeend', `
            <nav aria-label="Page navigation example">
                <ul class="pagination">
                    ${firstButton}
                    ${prevButton}
                    ${pageButtons}
                    ${nextButton}
                    ${lastButton}
                </ul>
            </nav>
        `);

        // Update perpage dropdown if changed
        document.getElementById('perpage').value = perpage;
    }

    function debounceSearch(e) {
        if (e.keyCode === 13) {
            loadThemes(1);  // Trigger the search when the user presses enter
        }
    }

    // Debounce function to handle input changes
    let debounceTimeout;
    function debounce(fn, delay) {
        return function() {
            clearTimeout(debounceTimeout);
            debounceTimeout = setTimeout(fn, delay);
        };
    };

  

    // SearchBar
    document.getElementById('search_filter').addEventListener('input', function() {
        const searchValue = document.getElementById('search_filter').value;
        if (searchValue) {
            document.getElementById('refreshSearch').style.display = 'inline-block';  // Show the refresh button
        } else {
            document.getElementById('refreshSearch').style.display = 'none';  // Hide the refresh button
        }
    });

     // Listen for changes in the perpage dropdown and reload data
    document.getElementById('perpage').addEventListener('change', () => loadThemes(1));

    // Listen for Enter key in the search filter and reload data
    document.getElementById('search_filter').addEventListener('keyup', debounceSearch);

    document.getElementById('refreshSearch').addEventListener('click', function() {
        document.getElementById('search_filter').value = '';  // Clear the search input
        loadThemes(1);  // Reload the table data without the search filter
    });
    document.getElementById('searchSubmit').addEventListener('click', function() {
        loadThemes(1);  // Reload the table data without the search filter
    });

    // Initial load
    loadThemes(1);

</script>



 <!-- status Change -->
 <script>
    function updatelevelStatus(Id, isChecked) {
        const status = isChecked ? 0 : 1;
        fetch(`/time_zone_status_change/${Id}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}' // Include CSRF token
                },
                body: JSON.stringify({
                    status: status
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 200) {
                    toastr.success('Status Updated successfully!');
                      loadThemes(currentPage);
                }
            })
            .catch(error => {});
    }
</script>

<!-- Delete Function -->
<script>
      function confirmDelete(id,time_zone,utc_offfset,country) {
  
          document.querySelector('#kt_modal_delete_time_zone_format .btn-danger').setAttribute('data-id', id);
          $('#delete_message').html(
              'Are you sure you want to delete Time Zone Format ?<br><br> <b class="text-black fw-bold fs-4">' +
              time_zone +' ('+utc_offfset+') '+'- '+ country +
              '</b>');
      }

      function deleteFunc() {
          var categoryId = document.querySelector('#kt_modal_delete_time_zone_format .btn-danger').getAttribute('data-id');

          fetch('/time_zone_delete/' + categoryId, {
                  method: 'DELETE',
                  headers: {
                      'Content-Type': 'application/json',
                      'X-CSRF-TOKEN': '{{ csrf_token() }}'
                  }
              })
              .then(response => response.json())
              .then(data => {
                  if (data.status === 200) {
                      toastr.success(data.message);
                      location.reload();
                  } else {
                      toastr.error(data.error_msg);
                  }
              })
              .catch(error => {

              });
      }
</script>

<script>
      function confirmDeletePermanent(id,name,country) {
  
          document.querySelector('#kt_modal_delete_permanent .btn-danger').setAttribute('data-id', id);
          $('#delete_message_permanent').html(
              'Are you sure you want to delete Permanently ?<br><br> <b class="text-black fw-bold fs-4">' +
              name +' - '+ country +
              '</b>');
      }
      function deletePermanentFunc() {
          var categoryId = document.querySelector('#kt_modal_delete_permanent .btn-danger').getAttribute('data-id');

          fetch('/batch_delete_permanently/' + categoryId, {
                  method: 'DELETE',
                  headers: {
                      'Content-Type': 'application/json',
                      'X-CSRF-TOKEN': '{{ csrf_token() }}'
                  }
              })
              .then(response => response.json())
              .then(data => {
                  if (data.status === 200) {
                      toastr.success(data.message);
                      location.reload();
                  } else {
                      toastr.error(data.error_msg);
                  }
              })
              .catch(error => {

              });
      }
</script>

<!-- add validate -->
 <script>
  function addValidateForm(){
    $("#createbtn").prop('disabled', true);
    var err =0;

    var country_id = document.getElementById("country_id").value.trim();
        if (country_id === "") {
            document.getElementById('country_id_err').innerHTML = 'Country is required...!';
            err++;
        } else {
            document.getElementById('country_id_err').innerHTML = '';
        }

      var time_zone = document.getElementById("time_zone").value.trim();
        if (time_zone === "") {
            document.getElementById('time_zone_err').innerHTML = ' Time Zone is required...!';
            err++;
        } else {
            document.getElementById('time_zone_err').innerHTML = '';
        }

        var utc_offset = document.getElementById("utc_offset").value.trim();
        if (utc_offset === "") {
            document.getElementById('utc_offset_err').innerHTML = ' UTC Offset is required...!';
            err++;
        } else {
            document.getElementById('utc_offset_err').innerHTML = '';
        }

    if(err>0){
        $("#createbtn").prop('disabled', false);
        return false;
       }else{
          $("#createbtn").prop('disabled', true);
          $('#addForm').submit();
       }
  }
 </script>

 <!-- edit Validate -->
 <script>
  function openEditModal(data) {
    $('#edit_id').val(data.sno);
    $('#time_zone_edit').val(data.time_zone);
    $('#utc_offset_edit').val(data.utc_offset);
    $('#country_id_edit').val(data.country_id);
    $('#description_edit').text(data.description);

    var country_id =data.country_id;
    $.ajax({
            url: "{{ route('country') }}",
            type: "GET",
            success: function(response) {
                if (response.status === 200 && response.data) {
                    var countryDropdown = $('#country_id_edit');
                    countryDropdown.empty();
                    countryDropdown.append('<option value="">Select Country</option>');
                    response.data.forEach(function(country) {
                        countryDropdown.append($('<option></option>').attr('value', country.id).text(country.name));
                    });
                    if(country_id){
                      countryDropdown.val(country_id).trigger('change');
                    }
                   
                }
            },
            error: function(error) {
                console.error('Error fetching countries:', error);
            }
        });


  }
  function editValidateForm(){
    var err =0;

    var country_id_edit = document.getElementById("country_id_edit").value.trim();
        if (country_id_edit === "") {
            document.getElementById('country_id_edit_err').innerHTML = 'Country is required...!';
            err++;
        } else {
            document.getElementById('country_id_edit_err').innerHTML = '';
        }

      var time_zone_edit = document.getElementById("time_zone_edit").value.trim();
        if (time_zone_edit === "") {
            document.getElementById('time_zone_edit_err').innerHTML = ' Time Zone is required...!';
            err++;
        } else {
            document.getElementById('time_zone_edit_err').innerHTML = '';
        }

        var utc_offset_edit = document.getElementById("utc_offset_edit").value.trim();
        if (utc_offset_edit === "") {
            document.getElementById('utc_offset_edit_err').innerHTML = ' UTC Offset is required...!';
            err++;
        } else {
            document.getElementById('utc_offset_edit_err').innerHTML = '';
        }

    if(err>0){
        $("#updatebtn").prop('disabled', false);
        return false;
       }else{
          $("#updatebtn").prop('disabled', true);
          $('#updateForm').submit();
       }
  }
 </script>

 <script>
      $(document).ready(function() {
        // Fetch and populate countries
        $.ajax({
            url: "{{ route('country') }}",
            type: "GET",
            success: function(response) {
                if (response.status === 200 && response.data) {
                    var countryDropdown = $('#country_id');
                    countryDropdown.empty();
                    countryDropdown.append('<option value="">Select Country</option>');
                    response.data.forEach(function(country) {
                        countryDropdown.append($('<option></option>').attr('value', country.id).text(country.name));
                    });
                    // countryDropdown.val(selectedCountryId).trigger('change'); // Set the selected country and trigger change
                }
            },
            error: function(error) {
                console.error('Error fetching countries:', error);
            }
        });
      })
 </script>
@endsection
