@extends('layouts/layoutMaster')
@section('style')
@section('title', 'Whatsapp Template')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/select2/select2.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
    @vite(['resources/assets/vendor/libs/select2/select2.js'])
@endsection

@section('content')

    <style>
        .credential-wrapper {
             min-height: 70vh;
        }

        /* Sidebar */
        .tab-sidebar {
            width: 250px;
            transition: all 0.3s ease;
            background: #fff;
            border-left: 1px solid #ddd;
        }

        .tab-sidebar.collapsed {
            width: 60px;
        }

        .tab-sidebar .nav-link {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px;
        }

        .tab-sidebar .nav-link i {
            font-size: 22px;
        }

        .nav-align-sideright .nav-link.active > label {
            background-color: #cfcfcf;
            color: #000;
            padding: 5px 8px;
            border-radius: 5px;
        }

        .tab-sidebar ul{
            /* align-items: end; */
        }
        

        /* Hide text when collapsed */
        .tab-sidebar.collapsed .tab-text {
            display: none;
        }
        .tab-sidebar.collapsed ul {
            align-items: center;
        }

        /* Toggle button */
        .toggle-btn {
            position: absolute;
            top: 15px;
            right: -15px;
            z-index: 10;
            background: #ab2b22;
            color: #fff;
            border: none;
            width: 30px;
            height: 30px;
            border-radius: 50%;
        }

        /* When sidebar collapsed */
        .tab-sidebar.collapsed + .tab-content .toggle-btn {
            right: -15px;
        }

        .tab-sidebar .right_nav{
            cursor:pointer !important;
            width:100%;
            display:flex;
            justify-content:end;
             align-items:center;
             gap:4px;
        }

        .tab-sidebar .right_nav:hover{
            color:#ab2b22 !important;
        }
    </style>
<!-- Users List Table -->
 <style>
  .whatsapp-preview {
        background: #ece5dd;
        padding: 20px;
        border-radius: 10px;
    }

    .chat-bubble {
        background: #fff;
        max-width: 280px;
        border-radius: 8px;
        overflow: hidden;
        font-size: 12px;
        line-height: 1.4;
    }
    #fetch_content {
        background: #ffffff52;
        max-width: 300px;
        max-height: 500px;
        border-radius: 8px;
         overflow: auto;
        font-size: 12px;
        line-height: 1.4;
    }

    .wa-doc-card {
        display: flex;
        align-items: center;
        padding: 10px 12px;
        gap: 12px;
        border-bottom: 1px solid #e9edef;
    }

    .wa-doc-icon {
        font-size: 28px;
    }

    .wa-doc-info {
        display: flex;
        flex-direction: column;
    }

    .wa-doc-name {
        font-weight: 600;
        font-size: 13px;
        color: #111b21;
    }

    .wa-doc-type {
        font-size: 11px;
        color: #667781;
        text-transform: uppercase;
    }


    .wa-header img {
        width: 100%;
        display: block;
    }

    .wa-body {
        padding: 12px 15px;
        white-space: pre-line;
    }

    .wa-footer {
        padding: 0 15px 10px;
        font-size: 12px;
        color: #667781;
    }

    .wa-buttons {
        border-top: 1px solid #e9edef;
    }

    .wa-button {
        text-align: center;
        padding: 10px;
        font-weight: 500;
        color: #00a884;
        cursor: pointer;
        border-top: 1px solid #e9edef;
    }

    .template-meta {
        background: #f8f9fa;
        padding: 12px;
        border-radius: 6px;
        font-size: 13px;
    }

 </style>

   <div class="card">
        <div class="card-header pb-1">
           <ul class="nav nav-tabs flex-nowrap" role="tablist">
                <div class="scroll-container-wrapper">
                    <button class="scroll-btn left" id="scrollLeftBtn"><span class="scroll-arrow"><i
                                class="mdi mdi-chevron-left fs-2 text-white"></i></span></button>
                               
                    <div class="scroll-container" id="scrollContainer">
                        <li class="item nav-item">
                            <a href="{{ url('/settings/general_settings') }}"
                                type="button"
                                class="nav-link scroll-link "
                                role="tab">
                                General Settings
                            </a>
                        </li>        
                        <li class="item nav-item">
                            <a
                                href="{{ url('/settings/broadcast_theme') }}"
                                type="button"
                                class="nav-link scroll-link active"
                                aria-selected="true">
                                Common
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/credential_book') }}" type="button"
                                class="nav-link scroll-link ">
                                Entity
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/document') }}" type="button" class="nav-link scroll-link ">
                                HRM
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/applicant_status') }}" type="button"
                                class="nav-link scroll-link ">
                                Recruitment
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/interview_mode') }}" type="button"
                                class="nav-link scroll-link">
                                Interview
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/assessment/guidelines') }}" type="button"
                                class="nav-link scroll-link">
                                Assessment
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/department') }}" type="button"
                                class="nav-link scroll-link ">
                                Management
                            </a>
                        </li>
                        <li class="nav-item">
                                <a href="{{ url('/settings/business/department') }}" type="button"
                                    class="nav-link scroll-link ">
                                    Business
                                </a>
                            </li>

                        <li class="nav-item">
                            <a href="{{ url('/settings/api_config') }}" type="button"
                                class="nav-link scroll-link ">
                                API Config
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/admin/webhooks') }}" type="button"
                                class="nav-link scroll-link ">
                                Webhook Moniter
                            </a>
                        </li>
                    </div>
                    <button class="scroll-btn right" id="scrollRightBtn" style="display: block;"><i
                            class="mdi mdi-chevron-right fs-2 text-white"></i></button>
                </div>
            </ul>
        </div>
        <div class="card-body px-1 py-1">
            <div class="d-flex credential-wrapper">
                <!-- CONTENT -->
                <div class="tab-content flex-grow-1 position-relative">
                    <!-- Toggle Button -->
                    <button id="toggleSidebarSetting" class="toggle-btn toggle-right">
                        <i class="mdi mdi-chevron-right"></i>
                    </button>
                    
                    <div class="d-flex align-items-center justify-content-between pb-0 mb-4 pt-0 mt-0" style="border-bottom: 1px solid gray;">
                        <div class="d-flex flex-column align-items-start">
                            <h5 class="card-title mb-1 text-black">Whatsapp Template</h5>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb custom-breadcrumb">
                                    <!-- Home -->
                                    <li class="breadcrumb-item">
                                        <a href="{{ url('/dashboard') }}">
                                            <i class="mdi mdi-cog"></i> Settings
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item" aria-current="page">
                                        <a href="javascript:void(0);">Common </a>
                                    </li>
                                    <li class="breadcrumb-item active" aria-current="page">
                                        <a href="javascript:void(0);" class="active-link">
                                            Whatsapp Template
                                        </a>
                                    </li>
                                </ol>
                            </nav>
                        </div>
                        <div class="d-flex justify-content-end align-items-center mb-2 gap-2">
                            <a href="javascript:;" class="btn btn-sm fw-bold btn-primary" data-bs-toggle="modal" data-bs-target="#kt_modal_add_whatsapp_template">
                                <span class="me-2"><i class="mdi mdi-plus"></i></span>Add Whatsapp Template <span id="balance_template_count" class="ms-2 badge bg-white text-primary fw-bold rounded-circle py-1 fs-8"></span>
                            </a>
                        </div>
                    </div>        
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="d-flex align-items-center justify-content-between mb-4 ">
                                <div>
                                    <span>Show</span>
                                    <select id="perpage" class="form-select form-select-sm w-75px"
                                        onchange="loadThemes(1)">
                                        @php $options = [5,10, 25, 100, 500]; @endphp
                                        @foreach ($options as $option)
                                            <option value="{{ $option }}" {{ $perpage == $option ? 'selected' : '' }}>
                                                {{ $option }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="d-flex align-items-center justify-content-end flex-wrap gap-2">
                                    <div class="searchBar">
                                        <input type="text" id="search_filter" class="searchQueryInput"
                                            placeholder="Search Email Templat..."
                                            value="{{ $search_filter }}"/>
                                        
                                        <div class="searchAction">
                                            <div class="d-flex align-items-center">
                                                <a href="javascript:;"  class="searchSubmit" id="searchSubmit" >
                                                    <span class="mdi mdi-magnify fs-4 fw-bold"  style="color:#ab2b22;"></span>
                                                </a>
                                                <a href="javascript:;" class="refreshBar" id="refreshSearch" >
                                                    <span class="mdi mdi-refresh fs-4 fw-bold" style="color:#ab2b22;"></span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <table
                                class="table align-middle table-row-dashed table-striped table-hover gy-0 gs-1 list_page">
                                <thead>
                                    <tr class="text-start align-top fw-bold fs-6 gs-0 bg-primary">
                                        <th class="min-w-50px">S.No</th>
                                        <th class="min-w-100px">Whatsapp Title</th>
                                        <th class="min-w-50px">Status</th>
                                        <th class="min-w-50px">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="list-table-body" class="text-black fw-semibold fs-7">
                                   
                                    <tr class="skeleton-loader" id="skeleton-loader">
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                    </tr>
                                     
                                </tbody>
                            </table>
                        </div>
                        <div class="text-center my-3" id="pagination-container">
                            <!-- Pagination buttons will appear here -->
                        </div>
                    </div>
                </div>
                <!-- SIDEBAR -->
                <div id="tabSidebarSetting" class="tab-sidebar expanded right nav-align-sideright">
                    <ul class="nav nav-tabs flex-column" role="tablist">
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/broadcast_theme') }}" class="nav-link "  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Broadcast</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Broadcast"><i class="mdi mdi-broadcast fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/sms_template') }}" class="nav-link "  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">SMS Template</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="SMS Template"><i class="mdi mdi-message-processing fs-3"></i></span>
                                </label>
                                
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/email_template') }}" class="nav-link "  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Email Template</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Email Template"><i class="mdi mdi-email fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/whatsapp_template') }}" class="nav-link active" role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Whatsapp Template</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Whatsapp Template"><i class="mdi mdi-whatsapp fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/currency_format') }}" class="nav-link " role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Currency Format</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Currency Format"><i class="mdi mdi-currency-inr fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/country') }}" class="nav-link " role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Country</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Country"><i class="mdi mdi-map-legend fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/state') }}" class="nav-link " role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">State</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="State"><i class="mdi mdi-map-marker-radius fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/city') }}" class="nav-link " role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">City</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="City"><i class="mdi mdi mdi-city fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/timezone') }}" class="nav-link " role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Time Zone</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Time Zone"><i class="mdi mdi-web-clock fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/internal_cugs') }}" class="nav-link " role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Internal Cugs</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Internal Cugs"><i class="mdi mdi-phone-classic fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

        </div>
    </div>

        <!--begin::Modal - Add Whats App Template-->
        <div class="modal fade" id="kt_modal_add_whatsapp_template" tabindex="-1" aria-hidden="true" data-bs-keyboard="false" data-bs-backdrop="static" data-bs-focus="false">
            <!--begin::Modal dialog-->
            <div class="modal-dialog modal-lg">
                <!--begin::Modal content-->
                <div class="modal-content rounded">
                    <!--begin::Modal header-->
                    <div class="modal-header justify-content-end border-0 pb-0">
                        <!--begin::Close-->
                        <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                            <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                            <span class="svg-icon svg-icon-1">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor" />
                                    <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="currentColor" />
                                </svg>
                            </span>
                            <!--end::Svg Icon-->
                        </div>
                        <!--end::Close-->
                    </div>
                    <!--end::Modal header-->
                    <!--begin::Modal body-->
                    <div class="modal-body pt-0 pb-10 px-10 px-xl-20">
                        <!--begin::Heading-->
                        <div class="mb-4 text-center">
                            <h3 class="text-center mb-4 text-black">Create WhatsApp Template</h3>
                        </div>
                        <div class="d-flex justify-content-end align-items-center">
                            {{-- <div class="badge bg-danger rounded text-white">
                                <label class="mb-1 fs-5 fw-bold">Balance - </label>
                                <label><i class="mdi mdi-currency-rupee fs-7 text-white"></i></label>
                                <label class="fs-5 fw-bold">50.00</label>
                            </div> --}}
                        </div>
                        <form id="addSlotForm" action="{{ route('whatsapp_template_add') }}" method="POST" onsubmit="return addvalidateForm()">
                            @csrf
                            <div class="row">
                                <div class="col-lg-6 mb-3">
                                    <label class="text-dark mb-1 fs-6 fw-semibold">Template<span class="text-danger">*</span></label>
                                    <select id="template_name" name="whatsapp_title_name" class="select3 form-select" data-bs-parent="#kt_modal_add_whatsapp_template" onchange="changeTemplateAdd(this.value)">
                                        <option value="">Select Template</option>
                                    </select>
                                    <div class="text-danger" id="template_name_err"></div>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label class="text-dark mb-1 fs-6 fw-semibold">Template Id</label>
                                     <input type="text" class="form-control" id="template_id" name="waba_template_id" placeholder="Enter Template Id" value="" readonly/>
                                    <div class="text-danger" id="template_id_err"></div>
                                </div>
                                <div class="col-lg-12 mb-3">
                                    <label class="text-dark mb-1 fs-6 fw-semibold">Message Content</label>
                                    <textarea class="form-control" rows="5" id="message_content_add" name="whatsapp_content" placeholder="Enter Message Content" readonly></textarea>
                                    <div class="text-danger" id="message_content_add_err"></div>
                                </div>
                            </div>
                            <div class="d-flex justify-content-center align-items-center mt-4">
                                <button type="reset" class="btn btn-secondary me-3" data-bs-dismiss="modal">Cancel</button>
                                <button type="submit" class="btn btn-primary">Create Whats App Template</button>
                            </div>
                        </form>
                    </div>

                    <!--end::Modal body-->
                </div>
                <!--end::Modal content-->
            </div>
            <!--end::Modal dialog-->
        </div>
        <!--end::Modal - Add Whats App Template-->

        <!--begin::Modal - Add Whats View Template-->
        <div class="modal fade" id="kt_modal_whatsapp_template_content_view" tabindex="-1" aria-hidden="true" data-bs-keyboard="false" data-bs-backdrop="static" data-bs-focus="false">
            <!--begin::Modal dialog-->
            <div class="modal-dialog modal-lg">
                <!--begin::Modal content-->
                <div class="modal-content rounded">
                    <!--begin::Modal header-->
                    <div class="modal-header justify-content-end border-0 pb-0">
                        <!--begin::Close-->
                        <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                            <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                            <span class="svg-icon svg-icon-1">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor" />
                                    <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="currentColor" />
                                </svg>
                            </span>
                            <!--end::Svg Icon-->
                        </div>
                        <!--end::Close-->
                    </div>
                    <!--end::Modal header-->
                    <!--begin::Modal body-->
                    <div class="modal-body pt-0 pb-10 px-10 px-xl-20">
                        <!--begin::Heading-->
                        <div class="mb-4 text-center">
                            <h3 class="text-center mb-4 text-black">View WhatsApp Template</h3>
                        </div>
                        <div class="row">
                            <div id="template_meta" class="mb-4"></div>
                            <div class="whatsapp-preview">
                                <div class="d-flex justify-content-evenly">
                                    <div>
                                        <h5>Sample Template</h5>
                                        <div class="chat-bubble">
                                            <div id="wa_header"></div>
                                            <div id="wa_body"></div>
                                            <div id="wa_footer"></div>
                                            <div id="wa_buttons"></div>
                                        </div>
                                    </div>
                                    <div>
                                        <h5>Template Payload</h5>
                                        <div id="fetch_content"></div>
                                    </div>
                                </div>
                            </div>
                            
                        </div>
                    </div>

                    <!--end::Modal body-->
                </div>
                <!--end::Modal content-->
            </div>
            <!--end::Modal dialog-->
        </div>
        <!--end::Modal - View Whats App Template-->
        
        <!--begin::Modal - Update Whats App Template-->
        <div class="modal fade" id="kt_modal_edit_whatsapp_template" tabindex="-1" aria-hidden="true" data-bs-keyboard="false" data-bs-backdrop="static" data-bs-focus="false">
            <!--begin::Modal dialog-->
            <div class="modal-dialog modal-md">
                <!--begin::Modal content-->
                <div class="modal-content rounded">
                    <!--begin::Modal header-->
                    <div class="modal-header justify-content-end border-0 pb-0">
                        <!--begin::Close-->
                        <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                            <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                            <span class="svg-icon svg-icon-1">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor" />
                                    <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="currentColor" />
                                </svg>
                            </span>
                            <!--end::Svg Icon-->
                        </div>
                        <!--end::Close-->
                    </div>
                    <!--end::Modal header-->
                    <!--begin::Modal body-->
                    <div class="modal-body pt-0 pb-10 px-10 px-xl-20">
                        <!--begin::Heading-->
                        <div class="mb-4 text-center">
                            <h3 class="text-center mb-4 text-black">Update Whatsapp Template</h3>
                        </div>
                        <div class="d-flex justify-content-end align-items-center">
                          
                        </div>
                        <form id="addSlotForm" action="{{ route('whatsapp_template_update') }}" method="POST" onsubmit="return editvalidateForm()">
                            @csrf
                            <div class="row">
                                <div class="col-lg-12 mb-3">
                                    <label class="text-dark mb-1 fs-6 fw-semibold">Title Name<span class="text-danger">*</span></label>
                                    <input type="hidden" name="edit_id" id="edit_id">
                                    <input type="text" class="form-control" id="title_edit" name="whatsapp_title_name" placeholder="Enter Title Name" value="" />
                                    <div class="text-danger" id="title_edit_err"></div>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label class="text-dark mb-1 fs-6 fw-semibold">Start Date<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control common_date_time" placeholder="Select Start Date" id="whatsapp_start_edit" name="start_date" value="" />
                                    <div class="text-danger" id="whatsapp_start_edit_err"></div>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label class="text-dark mb-1 fs-6 fw-semibold">End Date<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control common_date_time" placeholder="Select End Date" id="whatsapp_end_edit" name="end_date" value="30-Sep-2024" />
                                    <div class="text-danger" id="whatsapp_end_edit_err"></div>
                                </div>
                                <div class="col-lg-12 mb-3">
                                    <label class="text-dark mb-1 fs-6 fw-semibold">Template<span class="text-danger">*</span></label>
                                    <select id="template_edit" name="waba_template_id" class="select3 form-select" data-bs-parent="#kt_modal_edit_whatsapp_template" onchange="changeTemplateEdit(this.value)">
                                        <option value="">Select Template</option>
                                    </select>
                                    <div class="text-danger" id="template_edit_err"></div>
                                </div>
                                <div class="col-lg-12 mb-3">
                                    <label class="text-dark mb-1 fs-6 fw-semibold">Message Content</label>
                                    <textarea class="form-control" rows="3" id="message_content_edit" placeholder="Enter Message Content" disabled></textarea>
                                </div>
                            </div>
                            <div class="d-flex justify-content-center align-items-center mt-4">
                                <button type="reset" class="btn btn-secondary me-3" data-bs-dismiss="modal">Cancel</button>
                                <button type="submit" class="btn btn-primary">Update Whatsapp Template</button>
                            </div>
                        </form>
                    </div>
                    <!--end::Modal body-->
                </div>
                <!--end::Modal content-->
            </div>
            <!--end::Modal dialog-->
        </div>
        <!--end::Modal - Update Whats App Template-->
        <!--begin::Modal - Delete Whats App Template-->
        <div class="modal fade" id="kt_modal_delete_whatsapp_template" tabindex="-1" aria-hidden="true" data-bs-keyboard="false" data-bs-backdrop="static">
            <!--begin::Modal dialog-->
            <div class="modal-dialog modal-m">
                <!--begin::Modal content-->
                <div class="modal-content rounded">
                    <div class="swal2-icon swal2-danger swal2-icon-show" style="display: flex;">
                        <div class="swal2-icon-content">?</div>
                    </div>
                    <div class="swal2-html-container" id="swal2-html-container" style="display: block;">
                        <span id="delete_message"></span>
                    </div>
                    <div class="d-flex justify-content-center align-items-center pt-8 pb-8">
                        <button type="submit" class="btn btn-danger me-3" onclick="deleteWhatsappStatus()">Yes, delete!</button>
                        <button type="reset" class="btn btn-secondary" data-bs-dismiss="modal">No,cancel</button>
                    </div>
                </div>
                <!--end::Modal content-->
            </div>
            <!--end::Modal dialog-->
        </div>
        <!--end::Modal - Delete Whats App Template-->


        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
        <style>
            /* Customize Toastr notification */
            .toast-success {
                background-color: green;
            }

            /* Customize Toastr notification */
            .toast-error {
                background-color: red;
            }

            .error_msg {
                border: solid 2px red !important;
                border-color: red !important;
            }

        </style>

        <script>
            // Display Toastr messages
            @if(Session::has('toastr'))
            var type = "{{ Session::get('toastr')['type'] }}";
            var message = "{{ Session::get('toastr')['message'] }}";
            toastr[type](message);
            @endif

        </script>
       
<script>
    let currentPage = 1;
    let isLoading = false;
    let abortController = new AbortController();

    function formatDate(date) {
        const options = { year: 'numeric', month: 'short', day: 'numeric', hour: '2-digit', minute: '2-digit', hour12: true };
        return new Date(date).toLocaleDateString('en-GB', options);
    }
   
    function buildRow(item,index) {
        return `
            <tr>
                <td><label class="fs-7 fw-medium">${index}</label></td>
                <td>
                    <label class="fs-7 fw-medium d-block">${item.whatsapp_title_name}</label>
                    <span class="badge bg-info text-white fw-bold fs-8">${item.waba_template_id}</span>
                </td>
                <td>
                    <label class="switch switch-square">
                        <input type="checkbox" class="switch-input" ${item.status == 0 ? 'checked' : ''} onchange="updatelevelStatus('${item.sno}', this.checked)"/>
                        <span class="switch-toggle-slider">
                            <span class="switch-on"></span>
                            <span class="switch-off"></span>
                        </span>
                    </label>
                </td>
                <td >
                    <span class="text-end">
                           <button class="btn btn-icon btn-sm view-message" type="button" 
                            data-bs-toggle="modal"
                            data-bs-target="#kt_modal_whatsapp_template_content_view"
                            data-bs-toggle="tooltip" data-bs-placement="bottom"
                            title="View"  data-template="${encodeURIComponent(JSON.stringify(item.template_content))}">
                            <i class="mdi mdi-eye-outline fs-3 text-black"></i>
                        </button>
                        <button class="btn btn-icon btn-sm" type="button" 
                            data-bs-toggle="modal"
                            data-bs-target="#kt_modal_delete_whatsapp_template"
                            data-bs-toggle="tooltip" data-bs-placement="bottom"
                            title="Delete"  onclick="confirmDelete('${item.sno}', '${item.whatsapp_title_name}')">
                            <i class="mdi mdi-delete-outline fs-3 text-black"></i>
                        </button>
                    </span>
                </td>
            </tr>
        `;
    }
    function loadThemes(page = 1) {
        const perpage = document.getElementById('perpage').value;
        const search = document.getElementById('search_filter').value;
        const url = `/settings/whatsapp_template?page=${page}&sorting_filter=${perpage}&search_filter=${search}`;

        // Show skeleton loader and clear old data before fetching new data
        isLoading = true;
        document.getElementById('list-table-body').innerHTML = ''; // Clear old data
        document.getElementById('list-table-body').insertAdjacentHTML('beforeend', skeletenRow()); // Clear old data
        $('#skeleton-loader').show(); // Show skeleton loader

        if (abortController.signal) {
            abortController.abort(); // Abort the previous request
        }
        abortController = new AbortController();

         fetch(url, { headers: { 'X-Requested-With': 'XMLHttpRequest' }, signal: abortController.signal })
            .then(res => res.json())
            .then(res => {
                // Insert new data into the table
                if(res.data.length > 0){
                    res.data.forEach((item, index) => {
                        document.getElementById('list-table-body').insertAdjacentHTML('beforeend', buildRow(item, index + 1));
                    });

                }else{
                    document.getElementById('list-table-body').insertAdjacentHTML('beforeend', NoDataFound());
                }
                     

                // Update pagination and results info
                updatePagination(res.current_page, res.last_page, res.total, perpage);

                // Hide skeleton loader after data is fetched
                isLoading = false;
                $('#skeleton-loader').hide();
                $('[data-bs-toggle="tooltip"]').tooltip();
            })
            .catch(error => {
                if (error.name !== 'AbortError') { // Only handle abort error
                    console.error('Error loading data:', error);
                }
                // Hide skeleton loader in case of error
                $('#skeleton-loader').hide();
                isLoading = false;
            });
    }

    function skeletenRow(){
        return `
            <tr class="skeleton-loader" id="skeleton-loader">
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
                <td class="skeleton-cell">
                    <div class="skeleton"></div>
                </td>
            </tr>
            `;
    }

    function NoDataFound(){
        return `
            <tr><td colspan="4" class="text-center">No Data Found</td></tr>
            `;
    }

    function updatePagination(currentPage, lastPage, total, perpage) {
        let paginationContainer = document.getElementById('pagination-container');
        paginationContainer.innerHTML = ''; // Clear old pagination

        // Set the pagination container style
        paginationContainer.style.display = "flex";
        paginationContainer.style.justifyContent = "space-between";
        paginationContainer.style.alignItems = "center";

        // Showing result count info (e.g., Showing 1 to 25 of 3556 results)
        let start = total > 0 ? (currentPage - 1) * perpage + 1 : 0;
        let end = Math.min(currentPage * perpage, total);
        let showingInfo = `Showing ${start} to ${end} of ${total} results`;
        paginationContainer.insertAdjacentHTML('beforeend', showingInfo);

        // Create Pagination Buttons

        // << First button
        let firstButton = `<li class="page-item ${currentPage === 1 ? 'disabled' : ''}" data-bs-toggle="tooltip" data-bs-placement="top" title="First Page"><button class=" page-link" onclick="loadThemes(1)" >«</button> </li>`;
        
        // < Previous button
        let prevButton = `<li class="page-item ${currentPage > 1 ? '' : 'disabled'}" data-bs-toggle="tooltip" data-bs-placement="top" title="Previous"><button class=" page-link" onclick="loadThemes(${currentPage - 1})" >‹</button> </li>`;
        
        // Next button
        let nextButton = `<li class="page-item ${currentPage < lastPage ? '' : 'disabled'}" data-bs-toggle="tooltip" data-bs-placement="top" title="Next"><button class="page-link" onclick="loadThemes(${currentPage + 1})" >›</button> </li>`;
        
        // >> Last button
        let lastButton = `<li class="page-item ${currentPage === lastPage ? 'disabled' : ''}" data-bs-toggle="tooltip" data-bs-placement="top" title="Last Page"><button class=" page-link" onclick="loadThemes(${lastPage})" >»</button> </li>`;

        // Page Number Buttons (Dynamically show a range of pages around the current page)
        let pageButtons = '';
        let range = 2; // Show 2 pages before and after the current page
        let startPage = Math.max(1, currentPage - range);
        let endPage = Math.min(lastPage, currentPage + range);

        // Generate page numbers
        for (let i = startPage; i <= endPage; i++) {
            pageButtons += `<li class="page-item ${i === currentPage ? 'active' : ''}"><button class="page-link " onclick="loadThemes(${i})">${i}</button> </li>`;
        }

        // Add the pagination buttons and page numbers
        paginationContainer.insertAdjacentHTML('beforeend', `
            <nav aria-label="Page navigation example">
                <ul class="pagination">
                    ${firstButton}
                    ${prevButton}
                    ${pageButtons}
                    ${nextButton}
                    ${lastButton}
                </ul>
            </nav>
        `);

        // Update perpage dropdown if changed
        document.getElementById('perpage').value = perpage;
    }

    function debounceSearch(e) {
        if (e.keyCode === 13) {
            loadThemes(1);  // Trigger the search when the user presses enter
        }
    }

    // Debounce function to handle input changes
    let debounceTimeout;
    function debounce(fn, delay) {
        return function() {
            clearTimeout(debounceTimeout);
            debounceTimeout = setTimeout(fn, delay);
        };
    };

  

    // SearchBar
    document.getElementById('search_filter').addEventListener('input', function() {
        const searchValue = document.getElementById('search_filter').value;
        if (searchValue) {
            document.getElementById('refreshSearch').style.display = 'inline-block';  // Show the refresh button
        } else {
            document.getElementById('refreshSearch').style.display = 'none';  // Hide the refresh button
        }
    });

     // Listen for changes in the perpage dropdown and reload data
    document.getElementById('perpage').addEventListener('change', () => loadThemes(1));

    // Listen for Enter key in the search filter and reload data
    document.getElementById('search_filter').addEventListener('keyup', debounceSearch);

    document.getElementById('refreshSearch').addEventListener('click', function() {
        document.getElementById('search_filter').value = '';  // Clear the search input
        loadThemes(1);  // Reload the table data without the search filter
    });
    document.getElementById('searchSubmit').addEventListener('click', function() {
        loadThemes(1);  // Reload the table data without the search filter
    });

    // Initial load
    loadThemes(1);

</script>

        <script>
            function confirmDelete(id, name) {

                document.querySelector('#kt_modal_delete_whatsapp_template .btn-danger').setAttribute(
                    'data-id', id);
                $('#delete_message').html('Are you sure you want to delete <br> <b class="text-danger"> ' + name +
                    '</b> Whatsapp Template ?');
            }

            function deleteWhatsappStatus() {

                var categoryId = document.querySelector('#kt_modal_delete_whatsapp_template .btn-danger').getAttribute('data-id');

                fetch('/whatsapp_template_delete/' + categoryId, {
                        method: 'DELETE'
                        , headers: {
                            'Content-Type': 'application/json'
                            , 'X-CSRF-TOKEN': '{{ csrf_token() }}' // Include CSRF token if using Laravel CSRF protection
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.status === 200) {
                            toastr.success('Whatsapp Template Deleted successfully!');
                            location.reload();

                        } else {

                            console.error(data.error_msg);
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                    });
            }

            function updatelevelStatus(categoryId, isChecked) {
                const status = isChecked ? 0 : 1; // Set status based on checkbox state

                fetch(`/whatsapp_template_status_change/${categoryId}`, {
                        method: 'POST'
                        , headers: {
                            'Content-Type': 'application/json'
                            , 'X-CSRF-TOKEN': '{{ csrf_token() }}' // Include CSRF token
                        }
                        , body: JSON.stringify({
                            status: status
                        })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.status === 200) {
                            toastr.success('Whatsapp Template status Updated successfully!');
                        } else {
                            console.error('Error updating Whatsapp Template status:', data.message);
                        }
                    })
                    .catch(error => {
                        console.error('Error updating Whatsapp Template status:', error);
                    });
            }
        </script>
        <script>
            function addvalidateForm() {
                var err = 0;
                
                // Validate Template
                var template_name = document.getElementById("template_name").value;
                if (template_name === "") {
                    document.getElementById('template_name_err').innerHTML = 'Template is required...!';
                    document.getElementById('template_name').classList.add('error_msg');
                    err++;
                } else {
                    document.getElementById('template_name').classList.remove('error_msg');
                    document.getElementById('template_name_err').innerHTML = '';
                }


                // Validate Title Name
                var message_content_add = document.getElementById("message_content_add").value.trim();
                if (message_content_add === "") {
                    document.getElementById('message_content_add_err').innerHTML = 'Template Content is required...!';
                    document.getElementById('message_content_add').classList.add('error_msg');
                    err++;
                } else {
                    document.getElementById('message_content_add').classList.remove('error_msg');
                    document.getElementById('message_content_add_err').innerHTML = '';
                }
                
                return err == 0;
            }
        </script>
        <script>
            function editvalidateForm() {
                var err = 0;

                // Validate Title Name
                var title_edit = document.getElementById("title_edit").value.trim();
                if (title_edit === "") {
                    document.getElementById('title_edit_err').innerHTML = 'Title Name is required...!';
                    document.getElementById('title_edit').classList.add('error_msg');
                    err++;
                } else {
                    document.getElementById('title_edit').classList.remove('error_msg');
                    document.getElementById('title_edit_err').innerHTML = '';
                }
                // Validate start date
                var whatsapp_start_edit = document.getElementById("whatsapp_start_edit").value.trim();
                if (whatsapp_start_edit === "") {
                    document.getElementById('whatsapp_start_edit_err').innerHTML = 'Start Date is required...!';
                    document.getElementById('whatsapp_start_edit').classList.add('error_msg');
                    err++;
                } else {
                    document.getElementById('whatsapp_start_edit').classList.remove('error_msg');
                    document.getElementById('whatsapp_start_edit_err').innerHTML = '';
                }

                // Validate End date
                var whatsapp_end_edit = document.getElementById("whatsapp_end_edit").value.trim();
                if (whatsapp_end_edit === "") {
                    document.getElementById('whatsapp_end_edit_err').innerHTML = 'End Date is required...!';
                    document.getElementById('whatsapp_end_edit').classList.add('error_msg');
                    err++;
                } else {
                    document.getElementById('whatsapp_end_edit').classList.remove('error_msg');
                    document.getElementById('whatsapp_end_edit_err').innerHTML = '';
                }

                // Validate Template
                var template_edit = document.getElementById("template_edit").value.trim();
                if (template_edit === "") {
                    document.getElementById('template_edit_err').innerHTML = 'Template is required...!';
                    document.getElementById('template_edit').classList.add('error_msg');
                    err++;
                } else {
                    document.getElementById('template_edit').classList.remove('error_msg');
                    document.getElementById('template_edit_err').innerHTML = '';
                }



                return err == 0;
            }
        </script>

        <script>
            function openEditModal(val) {
                fetch('{{ route('whatsapp_templates') }}')
                    .then(response => response.json())
                    .then(data => {
                        let select = document.getElementById('template_edit');
                        let messageContent = document.getElementById('message_content_edit');
                        select.innerHTML = ''; // Clear existing options
                        // Add the empty option
                        let defaultOption = document.createElement('option');
                        defaultOption.value = '';
                        defaultOption.textContent = 'Select Template';
                        select.appendChild(defaultOption);
                        data.data.forEach(template => {
                            let option = document.createElement('option');
                            option.value = template.id;
                            option.textContent = template.name;
                            if (val.waba_template_id == template.id) {
                                option.selected = true;
                                messageContent.innerText = template.components[1].text;
                            }
                            select.appendChild(option);


                        });
                    })
                    .catch(() => {
                        document.getElementById('template').innerHTML = '<option>Error loading templates</option>';
                    });

                document.getElementById('edit_id').value = val.sno;
                document.getElementById('title_edit').value = val.whatsapp_title_name;
                document.getElementById('whatsapp_start_edit').value = val.start_date;
                document.getElementById('whatsapp_end_edit').value = val.end_date;
                document.getElementById('template_edit').value = val.waba_template_id;

            }
        </script>

        <script>
            let template_count = 0;
            let template_names = @json($whatsappTemplateNames);
            document.addEventListener('DOMContentLoaded', function() {
                fetch('{{ route('whatsapp_templates') }}')
                    .then(response => response.json())
                    .then(data => {
                        template_count = 0;
                        let select = document.getElementById('template_name');
                        select.innerHTML = ''; // Clear existing options
                        // Add the empty option
                        let defaultOption = document.createElement('option');
                        defaultOption.value = '';
                        defaultOption.textContent = 'Select Template';
                        select.appendChild(defaultOption);
                        data.data.forEach(template => {
                            if(!template_names.includes(template.name)){
                                template_count +=1;
                                let option = document.createElement('option');
                                option.value = template.name;
                                option.textContent = template.name;
                                select.appendChild(option);
                            }
                            
                        });
                        $('#balance_template_count').text(template_count)
                    })
                    .catch(() => {
                        document.getElementById('template').innerHTML = '<option>Error loading templates</option>';
                    });


            });

        </script>

        <script>
            function changeTemplateAdd(val) {
                fetch('{{ route('whatsapp_templates') }}')
                    .then(response => response.json())
                    .then(data => {
                        let messageContent = document.getElementById('message_content_add');
                        data.data.forEach(template => {
                            if (val == template.name) {
                               messageContent.value = JSON.stringify(template, null, 2);
                                $('#template_id').val(template.id);

                            }

                        });
                    })
                    .catch(() => {
                        // document.getElementById('template').innerHTML = '<option>Error loading templates</option>';
                    });
            }
        </script>
        <script>
            function changeTemplateEdit(val) {
                fetch('{{ route('whatsapp_templates') }}')
                    .then(response => response.json())
                    .then(data => {
                        let messageContent = document.getElementById('message_content_edit');
                        data.data.forEach(template => {
                            if (val == template.id) {
                                messageContent.innerText = template.components[1].text;
                            }

                        });
                    })
                    .catch(() => {
                        // document.getElementById('template').innerHTML = '<option>Error loading templates</option>';
                    });

            }
        </script>

        <script>
            $(document).on('click', '.view-message', function () {
                try {
                    const template = JSON.parse(
                        decodeURIComponent(this.dataset.template)
                    );
                    viewContent(template);

                } catch (err) { 
                    console.error('Payload parse failed', err);

                }
            });
        </script>

        <script>
            function viewContent(template) {

                // ---- META ----
                $('#template_meta').html(`
                    <div class="template-meta">
                        <b>Name:</b> ${template.name}<br>
                        <b>Parameter Format:</b> ${template.parameter_format}<br>
                        <b>Category:</b> ${template.category}<br>
                        <b>Language:</b> ${template.language}<br>
                        <b>Status:</b> ${template.status}
                    </div>
                `);

                // ---- CLEAR UI ----
                $('#wa_header, #wa_body, #wa_footer, #wa_buttons').html('');

                // ---- RAW PAYLOAD ----
                $('#fetch_content').html(
                    '<pre>' + JSON.stringify(template.components, null, 2) + '</pre>'
                );

                template.components.forEach(component => {

                    // ===== HEADER =====
                    if (component.type === "HEADER") {

                        // IMAGE
                        if (component.format === "IMAGE") {
                            const img = component.example?.header_handle?.[0];
                            if (img) {
                                $('#wa_header').html(`
                                    <div class="wa-header">
                                        <img src="${img}">
                                    </div>
                                `);
                            }
                        }

                        // TEXT
                        if (component.format === "TEXT") {
                            $('#wa_header').html(`
                                <div class="wa-body"><b>${component.text}</b></div>
                            `);
                        }

                        if (component.format === "DOCUMENT") {
                            const docUrl = component.example?.header_handle?.[0];

                            // Force WhatsApp sample filename
                            // const fileName = "sampleddocs";
                            const fileName = component.example?.filename || "sample_document.pdf";

                            if (docUrl) {
                                $('#wa_header').html(`
                                    <div class="wa-header">
                                        <div class="wa-doc-card">
                                            <div class="wa-doc-icon">📄</div>

                                            <div class="wa-doc-info">
                                                <div class="wa-doc-name">${fileName}</div>
                                                <div class="wa-doc-type">pdf</div>
                                            </div>
                                        </div>
                                    </div>
                                `);
                            }
                        }
                    }



                    // ===== BODY =====
                    if (component.type === "BODY") {

                        let bodyText = component.text;

                        // Replace params only if examples exist
                        if (component.example) {
                            let examples = [];

                            if (template.parameter_format === "NAMED") {
                                examples = component.example.body_text_named_params || [];
                            } else {
                                examples = component.example.body_text?.[0] || [];
                            }

                            bodyText = replaceParams(bodyText, template.parameter_format, examples);
                        }

                        $('#wa_body').html(`<div class="wa-body">${bodyText}</div>`);
                    }

                    // ===== FOOTER =====
                    if (component.type === "FOOTER") {
                        $('#wa_footer').html(`
                            <div class="wa-footer">${component.text}</div>
                        `);
                    }

                    // ===== BUTTONS =====
                    if (component.type === "BUTTONS") {

                        let btnHtml = '';

                        component.buttons.forEach(btn => {

                            // URL BUTTON
                            if (btn.type === "URL") {
                                btnHtml += `
                                    <div class="wa-button" onclick="window.open('${btn.url}','_blank')">
                                        ${btn.text}
                                    </div>
                                `;
                            }

                            // QUICK REPLY BUTTON
                            if (btn.type === "QUICK_REPLY") {
                                btnHtml += `
                                    <div class="wa-button">
                                        ${btn.text}
                                    </div>
                                `;
                            }

                        });

                        $('#wa_buttons').html(`<div class="wa-buttons">${btnHtml}</div>`);
                    }

                });
            }
        </script>


        <script>
            function replaceParams(text, format, exampleParams) {
                if (format === "NAMED") {
                    exampleParams.forEach(p => {
                        let value = (p.example.toLowerCase() === "sundaresh" || p.example.toLowerCase() === "sunda") ? "Alex" : p.example;
                        const regex = new RegExp('\\{\\{' + p.param_name + '\\}\\}', 'g');
                        text = text.replace(regex, value);
                    });
                }

                if (format === "POSITIONAL") {
                    exampleParams.forEach((value, index) => {
                        value = (value.toLowerCase() === "sundaresh" | value.toLowerCase() === "sunda") ? "Alex" : value;
                        const regex = new RegExp('\\{\\{' + (index + 1) + '\\}\\}', 'g');
                        text = text.replace(regex, value);
                    });
                }

                return text;
            }
        </script>


        @endsection
