@extends('layouts/layoutMaster')
@section('style')
@section('title', 'Level')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/select2/select2.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
    @vite(['resources/assets/vendor/libs/select2/select2.js'])
@endsection

@section('content')


    <style>
        .credential-wrapper {
            min-height: 70vh;
        }

        /* Sidebar */
        .tab-sidebar {
             width: 250px;
            transition: all 0.3s ease;
            background: #fff;
            border-left: 1px solid #ddd;
        }

        .tab-sidebar.collapsed {
            width: 60px;
        }

        .tab-sidebar .nav-link {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px;
        }

        .tab-sidebar .nav-link i {
            font-size: 22px;
        }

        .nav-align-sideright .nav-link.active > label {
            background-color: #cfcfcf;
            color: #000;
            padding: 5px 8px;
            border-radius: 5px;
        }

        .tab-sidebar ul{
            /* align-items: end; */
        }
        

        /* Hide text when collapsed */
        .tab-sidebar.collapsed .tab-text {
            display: none;
        }
        .tab-sidebar.collapsed ul {
            align-items: center;
        }

        /* Toggle button */
        .toggle-btn {
            position: absolute;
            top: 15px;
            right: -15px;
            z-index: 10;
            background: #ab2b22;
            color: #fff;
            border: none;
            width: 30px;
            height: 30px;
            border-radius: 50%;
        }

        /* When sidebar collapsed */
        .tab-sidebar.collapsed + .tab-content .toggle-btn {
            right: -15px;
        }

        .tab-sidebar .right_nav{
            cursor:pointer !important;
            width:100%;
            display:flex;
            justify-content:end;
             align-items:center;
              gap:4px;
        }

        .tab-sidebar .right_nav:hover{
            color:#ab2b22 !important;
        }
    </style>

    <!-- Users List Table -->
    <div class="card">
        <div class="card-header pb-1">
            <ul class="nav nav-tabs flex-nowrap" role="tablist">
                <div class="scroll-container-wrapper">
                    <button class="scroll-btn left" id="scrollLeftBtn"><span class="scroll-arrow"><i
                                class="mdi mdi-chevron-left fs-2 text-white"></i></span></button>
                               
                    <div class="scroll-container" id="scrollContainer">
                        <li class="item nav-item">
                            <a href="{{ url('/settings/general_settings') }}"
                                type="button"
                                class="nav-link scroll-link "
                                role="tab">
                                General Settings
                            </a>
                        </li>        
                        <li class="item nav-item">
                            <a
                                href="{{ url('/settings/broadcast_theme') }}"
                                type="button"
                                class="nav-link scroll-link "
                                aria-selected="true">
                                Common
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/credential_book') }}" type="button"
                                class="nav-link scroll-link active">
                                Entity
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/document') }}" type="button" class="nav-link scroll-link ">
                                HRM
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/applicant_status') }}" type="button"
                                class="nav-link scroll-link ">
                                Recruitment
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/interview_mode') }}" type="button"
                                class="nav-link scroll-link">
                                Interview
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/assessment/guidelines') }}" type="button"
                                class="nav-link scroll-link">
                                Assessment
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/department') }}" type="button"
                                class="nav-link scroll-link ">
                                Management
                            </a>
                        </li>
                        <li class="nav-item">
                                <a href="{{ url('/settings/business/department') }}" type="button"
                                    class="nav-link scroll-link ">
                                    Business
                                </a>
                            </li>

                        <li class="nav-item">
                            <a href="{{ url('/settings/api_config') }}" type="button"
                                class="nav-link scroll-link ">
                                API Config
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/admin/webhooks') }}" type="button"
                                class="nav-link scroll-link ">
                                Webhook Moniter
                            </a>
                        </li>
                    </div>
                    <button class="scroll-btn right" id="scrollRightBtn" style="display: block;"><i
                            class="mdi mdi-chevron-right fs-2 text-white"></i></button>
                </div>
            </ul>
        </div>
        <div class="card-body px-1 py-1">
            
            <div class="d-flex credential-wrapper">
                <!-- CONTENT -->
                <div class="tab-content flex-grow-1 position-relative">
                    <!-- Toggle Button -->
                    <button id="toggleSidebarSetting" class="toggle-btn toggle-right">
                        <i class="mdi mdi-chevron-right"></i>
                    </button>

                    <div class="d-flex align-items-center justify-content-between pb-0 mb-4 pt-0 mt-0" style="border-bottom: 1px solid gray;">
                        <div class="d-flex flex-column align-items-start">
                            <h5 class="card-title mb-1 text-black">Level</h5>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb custom-breadcrumb">
                                    <!-- Home -->
                                    <li class="breadcrumb-item">
                                        <a href="{{ url('/dashboard') }}">
                                            <i class="mdi mdi-cog"></i> Settings
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item" aria-current="page">
                                        <a href="javascript:void(0);">Entity </a>
                                    </li>
                                    <li class="breadcrumb-item active" aria-current="page">
                                        <a href="javascript:void(0);" class="active-link">
                                            Level
                                        </a>
                                    </li>
                                </ol>
                            </nav>
                        </div>
                        <div class="d-flex justify-content-end align-items-center mb-2 gap-2">
                            <a href="#" class="btn btn-sm fw-bold btn-primary" data-bs-toggle="modal"
                                data-bs-target="#kt_modal_add_Level">
                                <span class="me-2"><i class="mdi mdi-plus"></i></span>Add Level
                            </a>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="d-flex align-items-center justify-content-between gap-2 mb-2">
                                <div>
                                    <span>Show</span>
                                    <br>
                                    <select id="perpage" name="perpage" class="form-select form-select-sm w-60px">
                                        <option value="10">10</option>
                                        <option value="25" selected>25</option>
                                        <option value="50">50</option>
                                        <option value="100">100</option>
                                    </select>
                                </div>
                                <div class="d-flex align-items-center justify-content-end flex-wrap gap-2">
                                    <div class="searchBar">
                                        <input class="searchQueryInput" type="text" name="searchQueryInput" placeholder="Enter Level" value="" />
                                        <a href="{{url('settings/level')}}" class="searchQuerySubmit" type="submit" name="searchQuerySubmit">
                                            <svg style="width:24px;height:24px" viewBox="0 0 24 24"><path fill="#ab2b22" d="M9.5,3A6.5,6.5 0 0,1 16,9.5C16,11.11 15.41,12.59 14.44,13.73L14.71,14H15.5L20.5,19L19,20.5L14,15.5V14.71L13.73,14.44C12.59,15.41 11.11,16 9.5,16A6.5,6.5 0 0,1 3,9.5A6.5,6.5 0 0,1 9.5,3M9.5,5C7,5 5,7 5,9.5C5,12 7,14 9.5,14C12,14 14,12 14,9.5C14,7 12,5 9.5,5Z" />
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <table
                                class="table align-middle table-row-dashed table-striped table-hover gy-0 gs-1 list_page">
                                <thead>
                                    <tr class="text-start align-top fw-bold fs-6 gs-0 bg-primary">
                                        <th class="min-w-50px">S.No</th>
                                        <th class="min-w-100px">Level</th>
                                        <th class="min-w-100px">Job Role</th>
                                        <th class="min-w-100px">Per Hour Cost</th>
                                        <th class="min-w-50px">Status</th>
                                        <th class="min-w-50px">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <label class="fs-7 fw-medium">1</label>
                                        </td>
                                        <td>
                                            <label class="fs-7 fw-medium">L1</label>
                                            <a href="javascipt:;" data-bs-toggle="tooltip" data-bs-placement="right"
                                                title="-">
                                                <i class="mdi mdi mdi-help-circle text-dark"></i>
                                            </a>
                                        </td>
                                        <td>
                                            <label class="fs-7 fw-medium">Designer</label>
                                        </td>
                                        <td>
                                            <label class="fs-7 fw-medium text-primary">300.00</label>
                                        </td>
                                        <td>
                                            <label class="switch switch-square">
                                                <input type="checkbox" class="switch-input" checked />
                                                <span class="switch-toggle-slider">
                                                    <span class="switch-on"></span>
                                                    <span class="switch-off"></span>
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <span class="text-end">
                                                <a href="#" data-bs-toggle="modal"
                                                    data-bs-target="#kt_modal_edit_Level" data-bs-toggle="tooltip"
                                                    data-bs-placement="bottom" title="Edit">
                                                    <i class="mdi mdi-square-edit-outline fs-3 text-black"></i>
                                                </a>
                                                <a href="javascript:;" class="btn btn-icon btn-sm"
                                                    data-bs-toggle="modal" data-bs-target="#kt_modal_delete_Level"
                                                    data-bs-toggle="tooltip" data-bs-placement="bottom"
                                                    title="Delete">
                                                    <i class="mdi mdi-delete-outline fs-3 text-black"></i>
                                                </a>
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label class="fs-7 fw-medium">2</label>
                                        </td>
                                        <td>
                                            <label class="fs-7 fw-medium">L2</label>
                                            <a href="javascipt:;" data-bs-toggle="tooltip"
                                                data-bs-placement="right" title="-">
                                                <i class="mdi mdi mdi-help-circle text-dark"></i>
                                            </a>
                                        </td>
                                        <td>
                                            <label class="fs-7 fw-medium">Tester</label>
                                        </td>
                                        <td>
                                            <label class="fs-7 fw-medium text-primary">200.00</label>
                                        </td>
                                        <td>
                                            <label class="switch switch-square">
                                                <input type="checkbox" class="switch-input" checked />
                                                <span class="switch-toggle-slider">
                                                    <span class="switch-on"></span>
                                                    <span class="switch-off"></span>
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <span class="text-end">
                                                <a href="#" data-bs-toggle="modal"
                                                    data-bs-target="#kt_modal_edit_Level" data-bs-toggle="tooltip"
                                                    data-bs-placement="bottom" title="Edit">
                                                    <i class="mdi mdi-square-edit-outline fs-3 text-black"></i>
                                                </a>
                                                <a href="javascript:;" class="btn btn-icon btn-sm"
                                                    data-bs-toggle="modal" data-bs-target="#kt_modal_delete_Level"
                                                    data-bs-toggle="tooltip" data-bs-placement="bottom"
                                                    title="Delete">
                                                    <i class="mdi mdi-delete-outline fs-3 text-black"></i>
                                                </a>
                                            </span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- SIDEBAR -->
                <div id="tabSidebarSetting" class="tab-sidebar expanded right nav-align-sideright">
                    <ul class="nav nav-tabs flex-column" role="tablist">
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/credential_book') }}" class="nav-link "  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Credential Book</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Credential Book"><i class="mdi mdi-book-lock-open-outline fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/social_media') }}" class="nav-link"  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Social Media</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Social Media"><i class="mdi mdi-web-plus fs-3"></i></span>
                                </label>
                                
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/webhook_url') }}" class="nav-link"  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Webhook URL</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Webhook URL"><i class="mdi mdi-webhook fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a class="nav-link" href="{{ url('/settings/grade') }}"  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Grade</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Grade"><i class="mdi mdi-police-badge-outline fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a class="nav-link active" href="{{ url('/settings/level') }}"  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Level</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Level"><i class="mdi mdi-podium-gold fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>


    <!--begin::Modal - Add  Level -->
    <div class="modal fade" id="kt_modal_add_Level" tabindex="-1" aria-hidden="true" data-bs-keyboard="false"
        data-bs-backdrop="static" data-bs-focus="false">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-md">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div
                    class="modal-header d-flex align-items-center justify-content-between border border-bottom-1 pb-0 mb-4">
                    <div class="text-center mt-4">
                        <h3 class="text-center text-black">Create Level</h3>
                    </div>
                    <!--begin::Close-->
                    <div class="btn btn-sm btn-icon btn-active-color-primary rounded" style="border: 2px solid #000;" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="#000" xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="#000" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="#000" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                    </div>
                    <!--end::Close-->
                </div>

                <!--end::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body pt-0 pb-10 px-10 px-xl-20">
                    <!--begin::Heading-->
                    <div class="row">
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold"> Level Name<span
                                    class="text-danger "></span></label>
                            <input type="text" class="form-control" placeholder="Enter Level Name">

                        </div>
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold">Job Position<span
                                    class="text-danger">*</span></label>
                            <select name="Level_Add_Id" id="Level_Add_Id"
                                class="select3 form-select select2-hidden-accessible" data-select2-id="Level_Add_Id"
                                tabindex="-1" aria-hidden="true">
                                <option value="" data-select2-id="15">Select job role</option>
                                <option value="50">Tester</option>
                                <option value="46">Telecaller</option>
                                <option value="45">Sales executive</option>
                                <option value="44">CRE</option>
                                <option value="43">Quality Analyst</option>
                                <option value="42">Business head</option>
                                <option value="41">Central head</option>
                                <option value="40">Designer</option>
                                <option value="39">Developer</option>
                            </select>

                        </div>
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold">Per Hour Cost<span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control"
                                placeholder="Enter level perhourcost">
                        </div>
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold">Description</label>
                            <textarea class="form-control" rows="1" name="level_desc" placeholder="Enter Description"></textarea>
                        </div>
                    </div>
                    <div class="d-flex justify-content-between align-items-center mt-4">
                        <button type="reset" class="btn btn-outline-danger text-primary me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" id="create_sms_btn" class="btn btn-primary"
                            data-bs-dismiss="modal">Create
                            Level</button>
                    </div>
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - Add  Level-->


    <!--begin::Modal - Edit  Level -->
    <div class="modal fade" id="kt_modal_edit_Level" tabindex="-1" aria-hidden="true" data-bs-keyboard="false"
        data-bs-backdrop="static" data-bs-focus="false">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-md">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div
                    class="modal-header d-flex align-items-center justify-content-between border border-bottom-1 pb-0 mb-4">
                    <div class="text-center mt-4">
                        <h3 class="text-center text-black">Update Level</h3>
                    </div>
                    <!--begin::Close-->
                    <div class="btn btn-sm btn-icon btn-active-color-primary rounded" style="border: 2px solid #000;" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="#000" xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="#000" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="#000" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                    </div>
                    <!--end::Close-->
                </div>
                <!--end::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body pt-0 pb-10 px-10 px-xl-20">
                    <!--begin::Heading-->

                    <div class="row">
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold"> Level Name<span
                                    class="text-danger "></span></label>
                            <input type="text" class="form-control" placeholder="Enter Level Name" value="L1">

                        </div>
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold">Job Position<span
                                    class="text-danger">*</span></label>
                            <select name="Level_Edit_Id" id="Level_Edit_Id"
                                class="select3 form-select select2-hidden-accessible" data-select2-id="Level_Edit_Id"
                                tabindex="-1" aria-hidden="true">
                                <option value="" data-select2-id="15">Select job role</option>
                                <option value="50" selected>Tester</option>
                                <option value="46">Telecaller</option>
                                <option value="45">Sales executive</option>
                                <option value="44">CRE</option>
                                <option value="43">Quality Analyst</option>
                                <option value="42">Business head</option>
                                <option value="41">Central head</option>
                                <option value="40">Designer</option>
                                <option value="39">Developer</option>
                            </select>

                        </div>
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold">Per Hour Cost<span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control" placeholder="Enter level perhourcost" value="300">

                        </div>
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold">Description</label>
                            <textarea class="form-control" rows="1" name="level_desc" placeholder="Enter Description">-</textarea>
                        </div>
                    </div>
                    <div class="d-flex justify-content-between align-items-center mt-4">
                        <button type="reset" class="btn btn-outline-danger text-primary me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" id="create_sms_btn" class="btn btn-primary"
                            data-bs-dismiss="modal">Update Level</button>
                    </div>
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - Edit  Level-->

    <!--begin::Modal - Delete  Level-->
    <div class="modal fade" id="kt_modal_delete_Level" tabindex="-1" aria-hidden="true" data-bs-keyboard="false"
        data-bs-backdrop="static">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-m">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <div class="swal2-icon swal2-danger swal2-icon-show" style="display: flex;">
                    <!-- <div class="swal2-icon-content"><i class="mdi mdi-trash fs-2 text-danger"></i></div> -->
                    <div>
                        <i class="fa-solid fa-trash text-danger" style="font-size: 35px;"></i>
                    </div>
                </div>
                <div class="swal2-html-container mb-4" id="swal2-html-container" style="display: block;">
                    <span id="delete_message">Are you sure you want to delete <br><b class="text-danger">Level C </b>
                        Level ?</span>
                </div>
                <div class="d-flex justify-content-center align-items-center pt-8 mb-4">
                    <button type="submit" class="btn btn-danger me-3" data-bs-dismiss="modal">Yes,
                        delete!</button>
                    <button type="reset" class="btn btn-secondary text-black" data-bs-dismiss="modal">No,cancel</button>
                </div>
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - Delete  Level-->




    <!-- Logo File Upload Start -->
    <!-- jQuery from CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Toastr CSS from CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <!-- Toastr JavaScript from CDN -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <style>
        /* Customize Toastr notification */
        .toast-success {
            background-color: green;
        }

        /* Customize Toastr notification */
        .toast-error {
            background-color: red;
        }
    </style>

@endsection
