@extends('layouts/layoutMaster')
@section('style')
@section('title', 'General Settings')

@section('vendor-style')
@vite([
'resources/assets/vendor/libs/select2/select2.scss',
])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
@vite([
'resources/assets/vendor/libs/select2/select2.js',
])
@endsection

@section('content')

<!-- Users List Table -->
<div class="card">
    <div class="card-header pb-1">
        <ul class="nav nav-tabs flex-nowrap" role="tablist">
            <div class="scroll-container-wrapper">
                <button class="scroll-btn left" id="scrollLeftBtn"><span class="scroll-arrow"><i class="mdi mdi-chevron-left fs-2 text-white"></i></span></button>
                <div class="scroll-container" id="scrollContainer">
                    <li class="item nav-item">
                        <a href="{{ url('/settings/general_settings') }}"
                            type="button"
                            class="nav-link scroll-link active"
                            role="tab">
                            General Settings
                        </a>
                    </li>        
                    <li class="item nav-item">
                        <a
                            href="{{ url('/settings/broadcast_theme') }}"
                            type="button"
                            class="nav-link scroll-link"
                            aria-selected="true">
                            Common
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/credential_book') }}" type="button"
                            class="nav-link scroll-link ">
                            Entity
                        </a>
                    </li>
                     <li class="nav-item">
                        <a href="{{ url('/settings/document') }}" type="button" class="nav-link scroll-link ">
                            HRM
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/applicant_status') }}" type="button"
                            class="nav-link scroll-link ">
                            Recruitment
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/interview_mode') }}" type="button"
                            class="nav-link scroll-link">
                            Interview
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/assessment/guidelines') }}" type="button"
                            class="nav-link scroll-link">
                            Assessment
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/department') }}" type="button"
                            class="nav-link scroll-link ">
                            Management
                        </a>
                    </li>
                    <li class="nav-item">
                            <a href="{{ url('/settings/business/department') }}" type="button"
                                class="nav-link scroll-link ">
                                Business
                            </a>
                        </li>

                    <li class="nav-item">
                        <a href="{{ url('/settings/api_config') }}" type="button"
                            class="nav-link scroll-link ">
                            API Config
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/admin/webhooks') }}" type="button"
                            class="nav-link scroll-link ">
                            Webhook Moniter
                        </a>
                    </li>
                </div>
                <button class="scroll-btn right" id="scrollRightBtn" style="display: block;"><i class="mdi mdi-chevron-right fs-2 text-white"></i></button>
            </div>  
        </ul>
    </div>
    <div class="card-body">
        <form id="validationForm" class="needs-validation" novalidate  method="POST" action="{{ route('general_settings_update') }}" enctype="multipart/form-data">
            @csrf
            <div class="row">
                <div class="col-lg-6">
                    <div class="row">
                        <label class="col-lg-6 text-dark fs-6 fw-semibold">Logo<span
                                class="text-danger">*</span></label>
                        <div class="col-lg-6">
                            <div class="align-items-sm-center gap-4">
                                @if($logoUrl)
                                <img src="{{ $logoUrl }}" alt="user-avatar" class="d-block w-px-120 h-px-120 rounded border border-gray-600 border-solid" id="uploadedlogo" />

                                @else
                                <img src="{{asset('assets/common/logo_small.png')}}" alt="user-avatar" class="d-block w-px-120 h-px-120 rounded border border-gray-600 border-solid" id="uploadedlogo" />
                                @endif

                                <div class="button-wrapper">
                                    <div class="d-flex align-items-start mt-2 mb-2">
                                        <label for="upload" class="btn btn-sm btn-primary me-2" tabindex="0"
                                            data-bs-toggle="tooltip" data-bs-placement="top" title="Upload Logo">
                                            <i class="mdi mdi-tray-arrow-up"></i>
                                            <input type="file" name="logo" id="upload" class="file-in" hidden
                                                accept="image/png, image/jpeg" />
                                        </label>

                                        <button type="button" class="btn btn-sm btn-outline-danger file-reset"
                                            data-bs-toggle="tooltip" data-bs-placement="top" title="Reset Logo">
                                            <i class="mdi mdi-reload"></i>
                                        </button>
                                    </div>
                                    <div class="small">Allowed JPG, PNG. Max size of 800K</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="row">
                        <label class="col-lg-6 text-dark fs-6 fw-semibold">Fav Icon<span
                                class="text-danger">*</span></label>
                        <div class="col-lg-6">
                            <div class="align-items-sm-center gap-4">
                               
                                    @if($favUrl)
                                         <img src="{{ $favUrl }}" alt="Fav Icon" class="d-block w-px-120 h-px-120 rounded border border-gray-600 border-solid" id="fav_uploadedlogo" />
                                    @else
                                     <img src="{{asset('assets/common/logo_small.png')}}" alt="Fav Icon" class="d-block w-px-120 h-px-120 rounded border border-gray-600 border-solid" id="fav_uploadedlogo" />
                                    @endif
                                <div class="button-wrapper">
                                    <div class="d-flex align-items-start mt-2 mb-2">
                                        <label for="fav_upload" class="btn btn-sm btn-primary me-2" tabindex="0"
                                            data-bs-toggle="tooltip" data-bs-placement="top" title="Upload Fav Icon">
                                            <i class="mdi mdi-tray-arrow-up"></i>
                                            <input type="file" name="fav_icon" id="fav_upload" class="fav_file-in"
                                                hidden accept="image/png, image/jpeg" />
                                        </label>
                                        <button type="button" class="btn btn-sm btn-outline-danger fav_file-reset"
                                            data-bs-toggle="tooltip" data-bs-placement="top" title="Reset Fav Icon">
                                            <i class="mdi mdi-reload"></i>
                                        </button>
                                    </div>
                                    <div class="small">Allowed JPG, PNG. Max size of 800K</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-4 mb-2">
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-2 fs-6 fw-semibold">Title<span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="title" name="title" placeholder="Enter Title"
                        value="{{ $title ?? '' }}" required  />
                    <div class="invalid-feedback">Please enter the Title.</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Website<span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="website" name="url" placeholder="Enter Website (URL)"
                        value="{{ $url ?? '' }}" required />
                    <div class="invalid-feedback">Please enter the Website (URL).</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Email ID<span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="emailid" name="email_id" placeholder="Enter Email ID"
                        value="{{ $email_id ?? '' }}" required />
                    <div class="invalid-feedback">Please enter the Email ID.</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Phone No<span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="phoneno" name="phone_number"
                        placeholder="Enter Phone No" value="{{ $phone_number ?? '' }}" required />
                    <div class="invalid-feedback">Please enter the Phone No.</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Mobile No<span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="mobileno" name="mobile_number"
                        placeholder="Enter Mobile No" value="{{ $mobile_number ?? '' }}" required />
                    <div class="invalid-feedback">Please enter the Mobile No.</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Whatsapp No<span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="whatsappno" name="whatsapp_number"
                        placeholder="Enter Whatsapp No" value="{{ $whatsapp_number ?? '' }}" required />
                    <div class="invalid-feedback">Please enter the Whatsapp No.</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Date Format<span class="text-danger">*</span></label>
                    <select id="date_format" class="select3 form-select selectpicker w-100" data-style="btn-default"
                        name="date_format" data-live-search="true">
                         <option value="d-m-Y" <?php if ($date_format=='d-m-Y' ) { echo 'selected' ; } else { echo '' ; }
                            ?>>dd-mm-yyyy</option>

                        <option value="Y-m-d" <?php if ($date_format=='Y-m-d' ) { echo 'selected' ; } else { echo '' ; }
                            ?>>yyyy-mm-dd</option>

                        <option value="Y/m/d" <?php if ($date_format=='Y/m/d' ) { echo 'selected' ; } else { echo '' ; }
                            ?>>yyyy/mm/dd</option>

                        <option value="d-M-Y" <?php if ($date_format=='d-M-Y' ) { echo 'selected' ; } else { echo '' ; }
                            ?>>dd-mmm-yyyy</option>

                        <option value="d/M/Y" <?php if ($date_format=='d/M/Y' ) { echo 'selected' ; } else { echo '' ; }
                            ?>>dd/mmm/yyyy</option>
                    </select>
                    <div class="invalid-feedback">Please Select Date Format</div>
                </div>

                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Registered Name</label>
                    <input type="text" class="form-control" id="registered_name" name="registered_name"
                        placeholder="Enter Registered Name" value="{{ $registered_name ?? '' }}"  required />
                    <div class="invalid-feedback">Please enter the Registered Name.</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Tax No</label>
                    <input type="text" class="form-control" id="" name="tax_no" placeholder="Enter Tax No"
                        value="{{ $tax_no ?? '' }}" required />
                    <div class="invalid-feedback">Please enter the Tax No.</div>
                </div>

                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Country<span class="text-danger">*</span></label>
                    <select id="countryId" name="country" class="select3 form-select">
                        <option value="">Select Country</option>
                    </select>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">State<span class="text-danger">*</span></label>
                    <select id="stateId" name="state" class="select3 form-select">
                        <option value="">Select State</option>
                    </select>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">City<span class="text-danger">*</span></label>
                    <select id="cityId" name="city" class="select3 form-select">
                        <option value="">Select City</option>
                    </select>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Area / Street<span
                            class="text-danger">*</span></label>
                    <textarea class="form-control" rows="2" id="" name="address"
                        placeholder="Enter Area / Street">{{ $address ?? '' }}</textarea>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Pincode<span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="" name="pincode" placeholder="Enter Pincode"
                        value="{{ $pincode ?? '' }}" required />
                    <div class="invalid-feedback">Please enter the Pincode.</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Payment Remainder Days<span
                            class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="" name="pay_rem_day" maxlength="1"
                        placeholder="Enter Payment Remainder Days" value="{{ $payment_remainder ?? '' }}"
                        oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');"
                        required />
                    <div class="invalid-feedback">Payment Remainder Days Required.</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Currency Format<span
                            class="text-danger">*</span></label>
                    <select id="currency_format" class="select3 form-select selectpicker w-100" data-style="btn-default"
                            name="currency_format" data-live-search="true">
                            <option value="">Select Currency Format</option>
                    </select>
                    <div class="invalid-feedback">Currency format Required.</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-black mb-1 fs-6 fw-semibold">Minimum Product Cost (MPC) Value<span class="text-danger">*</span></label>
                    <input type="text" class="form-control" placeholder="Enter Minimum Product cost" id="min_product_cost"
                        name="min_product_cost" maxlength="10" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" value="{{$general->min_product_cost ?? ''}}"/>
                    <div class="text-danger" id="min_product_cost_err"></div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-black mb-1 fs-6 fw-semibold">Call Tracker Company ID</label>
                    <input type="text" class="form-control" placeholder="Enter Call Tracker Company ID"
                        maxlength="2" id="call_tracker_id" name="call_tracker_id" value="{{$general->call_tracker_branch_id ?? ''}}"
                        oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');" />
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-black mb-1 fs-6 fw-semibold">Company Short Name<span
                            class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="company_short_name" name="company_short_name" value="{{$general->company_short_name ?? ''}}" placeholder="Enter Company Short Name" oninput="this.value = this.value.replace(/^\w/, function(txt) { return txt.toUpperCase(); });" maxlength="6"/>
                    <div class="error_msg text-danger"></div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-black mb-1 fs-6 fw-semibold">Company Color<span
                            class="text-danger">*</span></label>
                    <input type="color" class="form-control" id="company_base_color" name="company_base_color" value="{{$general->company_base_color ?? ''}}" placeholder="Enter Company Color">
                    <div class="error_msg text-danger"></div>
                </div>
            </div>
            <div class="divider">
                <div class="text-black mb-4 fs-5 fw-semibold divider-text">Bank Details</div>
            </div>
            <div class="row mb-6">
                <div class="col-lg-4 mb-3">
                    <label class="text-black mb-1 fs-6 fw-semibold">Bank Name<span
                            class="text-danger">*</span></label>
                    <input type="text" class="form-control" placeholder="Enter Bank Name" id="bank_name"
                        name="bank_name" maxlength="70" value="{{$general->bank_name ?? ''}}"/>
                    <div class="text-danger" id="bank_name_err"></div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-black mb-1 fs-6 fw-semibold">Bank Branch Name<span
                            class="text-danger">*</span></label>
                    <input type="text" class="form-control" placeholder="Enter Bank Branch Name" id="bank_branch"
                        name="bank_branch" maxlength="70" value="{{$general->bank_branch ?? ''}}"/>
                    <div class="text-danger" id="bank_branch_err"></div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-black mb-1 fs-6 fw-semibold">Account Holder<span
                            class="text-danger">*</span></label>
                    <input type="text" class="form-control" placeholder="Enter Account Holder" id="bank_holder"
                        name="bank_holder" maxlength="70" value="{{$general->bank_holder ?? ''}}"/>
                    <div class="text-danger" id="bank_holder_err"></div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-black mb-1 fs-6 fw-semibold">Account No<span
                            class="text-danger">*</span></label>
                    <input type="text" class="form-control" placeholder="Enter Account No" id="bank_account_no"
                        name="bank_account_no" maxlength="20" value="{{$general->bank_account_no ?? ''}}"/>
                    <div class="text-danger" id="bank_account_no_err"></div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-black mb-1 fs-6 fw-semibold">IFSC Code<span
                            class="text-danger">*</span></label>
                    <input type="text" class="form-control" placeholder="Enter IFSC Code" id="bank_ifsc"
                        name="bank_ifsc" maxlength="150" value="{{$general->bank_ifsc ?? ''}}"/>
                    <div class="text-danger" id="bank_ifsc_err"></div>
                </div>
            </div>
            <div class="divider">
                <div class="text-black mb-4 fs-5 fw-semibold divider-text">Social Media</div>
            </div>
            <div class="row mb-6">
                @if(isset($social_media_list))
                    @foreach($social_media_list as $slist)
                    <div class="col-lg-4 mb-3">
                        <div class="form-check mb-2">
                            <input class="form-check-input toggle-field" type="checkbox" id="checkSocialMedia_{{$slist->sno}}" data-target="#socialMediaField_{{$slist->sno}}">
                            <label class="text-black mb-1 fs-6 fw-semibold" for="checkSocialMedia_{{$slist->sno}}">{{$slist->social_media_name}}</label>
                        </div>
                        <div id="socialMediaField_{{$slist->sno}}" class="d-none">
                            <input type="text" class="form-control" name="social_media[{{$slist->sno}}]" placeholder="Enter {{$slist->social_media_name}} URL" />
                        </div>
                        <div class="error_msg text-danger"></div>
                    </div>
                    @endforeach
                @endif
            </div>
            <div class="divider">
                <div class="text-black mb-4 fs-5 fw-semibold divider-text">API Details</div>
            </div>
            <div class="row mb-6">
                <div class="col-lg-8 mb-3">
                    <label class="text-black mb-1 fs-6 fw-semibold">Cloud Call API Key</label>
                    <textarea class="form-control" rows="1" placeholder="Enter Cloud Call API Key" id="cloud_call_api_key"
                        name="cloud_call_api_key" maxlength="150">{{$general->cloud_call_api_key ?? ''}}</textarea>
                </div>
            </div>
            <div class="d-flex justify-content-between align-items-center mt-4">     
                <a href="{{url('/settings/general_settings')}}" class="btn btn-outline-danger text-primary fw-bold">Cancel</a>
                 <button type="submit" class="btn btn-primary">Update</button>
            </div>
        </form>
    </div>
</div>
<!-- Logo File Upload Start -->
<!-- jQuery from CDN -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Toastr CSS from CDN -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

<!-- Toastr JavaScript from CDN -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<style>
    /* Customize Toastr notification */
    .toast-success {
        background-color: green;
    }

    /* Customize Toastr notification */
    .toast-error {
        background-color: red;
    }
</style>
<script>
    let social_media_details = @json($social_media_details);
    const form = document.getElementById('validationForm');
const emailInput = document.getElementById('emailid');
const phoneInput = document.getElementById('phoneno');
const mobileInput = document.getElementById('mobileno');
const whatsappInput = document.getElementById('whatsappno');

emailInput.addEventListener('input', function(event) {
    if (!validateEmail(emailInput.value)) {
        displayError(emailInput, "Please enter a valid email address.");
    } else {
        clearError(emailInput);
    }
});

phoneInput.addEventListener('input', function(event) {
    if (!validatePhoneNumber(phoneInput.value)) {
        displayError(phoneInput, "Please enter a 10-digit phone number.");
    } else {
        clearError(phoneInput);
    }
});

form.addEventListener('submit', function(event) {
    event.preventDefault();

    if (!form.checkValidity() || !validateEmail(emailInput.value)) {
        displayError(emailInput, "Please enter a valid email address.");
        event.stopPropagation();
    } else if (!validatePhoneNumber(phoneInput.value)) {
        displayError(phoneInput, "Please enter a 10-digit phone number.");
        event.stopPropagation();
    } else {
        form.submit();
        toastr.success('General Setting updated successfully!');
    }

    form.classList.add('was-validated');
});

function validateEmail(email) {
    const emailRegex =
        /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return emailRegex.test(email);
}

function validatePhoneNumber(phoneNumber) {
    // Remove non-numeric characters from phone number
    const numericPhoneNumber = phoneNumber.replace(/\D/g, '');
    return numericPhoneNumber.length === 10; // Assuming you want exactly 10 digits
}

function displayError(input, message) {
    const feedbackElement = input.nextElementSibling;
    feedbackElement.innerText = message;
    input.classList.add('is-invalid');
}

function clearError(input) {
    const feedbackElement = input.nextElementSibling;
    feedbackElement.innerText = "";
    input.classList.remove('is-invalid');
}
</script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
    const logoFileInput = document.querySelector('.file-in');
    const logoResetButton = document.querySelector('.file-reset');
    const faviconFileInput = document.querySelector('.fav_file-in');
    const faviconResetButton = document.querySelector('.fav_file-reset');

    // Function to reset logo image and input
    logoResetButton.addEventListener('click', function() {
        const logoImage = document.getElementById('uploadedlogo');
         const resetLogoImage = "{{ $logoUrl ?? asset('assets/common/logo_small.png') }}"; // Replace with the initial logo path
        logoImage.src = resetLogoImage;
        logoFileInput.value = null;
    });

    // Function to reset favicon image and input
    faviconResetButton.addEventListener('click', function() {
        const faviconImage = document.getElementById('fav_uploadedlogo');
        const resetFaviconImage ="{{ $logoUrl ?? asset('assets/common/logo_small.png') }}";  // Replace with the initial favicon path
        faviconImage.src = resetFaviconImage;
        faviconFileInput.value = null;
    });

    // Function to preview logo image
    logoFileInput.addEventListener('change', function() {
        const logoImage = document.getElementById('uploadedlogo');
        if (this.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                logoImage.src = e.target.result;
            };
            reader.readAsDataURL(this.files[0]);
        }
    });

    // Function to preview favicon image
    faviconFileInput.addEventListener('change', function() {
        const faviconImage = document.getElementById('fav_uploadedlogo');
        if (this.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                faviconImage.src = e.target.result;
            };
            reader.readAsDataURL(this.files[0]);
        }
    });
});
</script>

<script>
    $(document).ready(function() {
        var selectedCountryId = "{{ $country }}";
        var selectedStateId = "{{ $state }}";
        var selectedCityId = "{{ $city }}";
        var selectedCurrencyId = "{{ $currency_id }}";

        // Fetch and populate countries
        $.ajax({
            url: "{{ route('country') }}",
            type: "GET",
            success: function(response) {
                if (response.status === 200 && response.data) {
                    var countryDropdown = $('select[name="country"]');
                    countryDropdown.empty();
                    countryDropdown.append('<option value="">Select Country</option>');
                    response.data.forEach(function(country) {
                        countryDropdown.append($('<option></option>').attr('value', country.id).text(country.name));
                    });
                    countryDropdown.val(selectedCountryId).trigger('change'); // Set the selected country and trigger change
                }
            },
            error: function(error) {
                console.error('Error fetching countries:', error);
            }
        });

        // fetch currency Format
         $.ajax({
            url: "{{ route('currency_format') }}",
            type: "GET",
            success: function(response) {
                if (response.status === 200 && response.data) {
                    var currencyDropdown = $('select[name="currency_format"]');
                    currencyDropdown.empty();
                    currencyDropdown.append('<option value="">Select Currency Format</option>');
                    response.data.forEach(function(currency) {
                    var optionText = currency.currency_code + ' - ' + currency.country_name + " - " + currency.currency_symbol ;
                        currencyDropdown.append($('<option></option>').attr('value', currency.sno).text(optionText));
                    });
                    currencyDropdown.val(selectedCurrencyId).trigger('change'); // Set the selected country and trigger change
                }
            },
            error: function(error) {
                console.error('Error fetching currency format:', error);
            }
        });

        // Event listener for country change
        $('select[name="country"]').on('change', function() {
            var countryId = $(this).val();
            var stateDropdown = $('select[name="state"]');
            var cityDropdown = $('select[name="city"]');

            stateDropdown.empty().append('<option value="">Select State</option>');
            cityDropdown.empty().append('<option value="">Select City</option>');

            if (countryId) {
                // Fetch and populate states based on selected country
                $.ajax({
                    url: "{{ route('state') }}",
                    type: "GET",
                    data: { country_id: countryId },
                    success: function(response) {
                        if (response.status === 200 && response.data) {
                            response.data.forEach(function(state) {
                                stateDropdown.append($('<option></option>').attr('value', state.id).text(state.name));
                            });
                            stateDropdown.val(selectedStateId).trigger('change'); // Set the selected state and trigger change
                        }
                    },
                    error: function(error) {
                        console.error('Error fetching states:', error);
                    }
                });
            }
        });

        // Event listener for state change
        $('select[name="state"]').on('change', function() {
            var stateId = $(this).val();
            var countryId = $('select[name="country"]').val();
            var cityDropdown = $('select[name="city"]');

            cityDropdown.empty().append('<option value="">Select City</option>');

            if (countryId && stateId) {
                // Fetch and populate cities based on selected state and country
                $.ajax({
                    url: "{{ route('city') }}",
                    type: "GET",
                    data: { country_id: countryId, state_id: stateId },
                    success: function(response) {
                        if (response.status === 200 && response.data) {
                            response.data.forEach(function(city) {
                                cityDropdown.append($('<option></option>').attr('value', city.id).text(city.name));
                            });
                            cityDropdown.val(selectedCityId).trigger('change'); // Set the selected city
                            console.log(selectedCityId)
                        }
                    },
                    error: function(error) {
                        console.error('Error fetching cities:', error);
                    }
                });
            }
        });
    });

</script>
<script>
document.addEventListener("DOMContentLoaded", function() {
    document.querySelectorAll(".toggle-field").forEach(function(checkbox) {
        checkbox.addEventListener("change", function() {
            const target = document.querySelector(this.dataset.target);
            if (this.checked) {
                target.classList.remove("d-none");
            } else {
                target.classList.add("d-none");
            }
        });
    });
});
</script>
<script>
    $(document).ready(function() {
        if (social_media_details) {
            const socialMediaDetails = JSON.parse(social_media_details);
            Object.keys(socialMediaDetails).forEach(key => {
                const checkbox = document.getElementById(`checkSocialMedia_${key}`);
                if (checkbox) {
                    checkbox.checked = true;  // Check the checkbox if URL exists
                    const inputField = document.querySelector(`#socialMediaField_${key} input`);
                    if (inputField) {
                        inputField.value = socialMediaDetails[key]; // Set the URL in the input field
                    }
                    const target = document.querySelector(`#socialMediaField_${key}`);
                    if (checkbox.checked) {
                        target.classList.remove("d-none"); // Show the target if checked
                    } else {
                        target.classList.add("d-none"); // Hide the target if unchecked
                    }
                }
            });
        } 
    });
</script>
@endsection