@extends('layouts/layoutMaster')
@section('style')
@section('title', 'Onboard Checklist')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/select2/select2.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
    @vite(['resources/assets/vendor/libs/select2/select2.js'])
@endsection

@section('content')

    <style>
        .credential-wrapper {
             min-height: 70vh;
        }

        /* Sidebar */
        .tab-sidebar {
            width: 280px;
            transition: all 0.3s ease;
            background: #fff;
            border-left: 1px solid #ddd;
        }

        .tab-sidebar.collapsed {
            width: 60px;
        }

        .tab-sidebar .nav-link {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px;
        }

        .tab-sidebar .nav-link i {
            font-size: 22px;
        }

        .nav-align-sideright .nav-link.active > label {
            background-color: #cfcfcf;
            color: #000;
            padding: 5px 8px;
            border-radius: 5px;
        }

        .tab-sidebar ul{
            /* align-items: end; */
        }
        

        /* Hide text when collapsed */
        .tab-sidebar.collapsed .tab-text {
            display: none;
        }
        .tab-sidebar.collapsed ul {
            align-items: center;
        }

        /* Toggle button */
        .toggle-btn {
            position: absolute;
            top: 15px;
            right: -15px;
            z-index: 10;
            background: #ab2b22;
            color: #fff;
            border: none;
            width: 30px;
            height: 30px;
            border-radius: 50%;
        }

        /* When sidebar collapsed */
        .tab-sidebar.collapsed + .tab-content .toggle-btn {
            right: -15px;
        }

        .tab-sidebar .right_nav{
            cursor:pointer !important;
            width:100%;
            display:flex;
            justify-content:end;
            align-items:center;
            gap:4px;
        }

        .tab-sidebar .right_nav:hover{
            color:#ab2b22 !important;
        }
    </style>
    <!-- Users List Table -->
    <div class="card">
        <div class="card-header pb-1">
            <ul class="nav nav-tabs flex-nowrap" role="tablist">
                <div class="scroll-container-wrapper">
                    <button class="scroll-btn left" id="scrollLeftBtn"><span class="scroll-arrow"><i
                                class="mdi mdi-chevron-left fs-2 text-white"></i></span></button>
                               
                    <div class="scroll-container" id="scrollContainer">
                        <li class="item nav-item">
                            <a href="{{ url('/settings/general_settings') }}"
                                type="button"
                                class="nav-link scroll-link "
                                role="tab">
                                General Settings
                            </a>
                        </li>        
                        <li class="item nav-item">
                            <a
                                href="{{ url('/settings/broadcast_theme') }}"
                                type="button"
                                class="nav-link scroll-link "
                                aria-selected="true">
                                Common
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/credential_book') }}" type="button"
                                class="nav-link scroll-link ">
                                Entity
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/document') }}" type="button" class="nav-link scroll-link active">
                                HRM
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/applicant_status') }}" type="button"
                                class="nav-link scroll-link ">
                                Recruitment
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/interview_mode') }}" type="button"
                                class="nav-link scroll-link">
                                Interview
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/assessment/guidelines') }}" type="button"
                                class="nav-link scroll-link">
                                Assessment
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/department') }}" type="button"
                                class="nav-link scroll-link ">
                                Management
                            </a>
                        </li>
                        <li class="nav-item">
                                <a href="{{ url('/settings/business/department') }}" type="button"
                                    class="nav-link scroll-link ">
                                    Business
                                </a>
                            </li>

                        <li class="nav-item">
                            <a href="{{ url('/settings/api_config') }}" type="button"
                                class="nav-link scroll-link ">
                                API Config
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/admin/webhooks') }}" type="button"
                                class="nav-link scroll-link ">
                                Webhook Moniter
                            </a>
                        </li>
                    </div>
                    <button class="scroll-btn right" id="scrollRightBtn" style="display: block;"><i
                            class="mdi mdi-chevron-right fs-2 text-white"></i></button>
                </div>
            </ul>
        </div>
        <div class="card-body px-1 py-1">
            <div class="d-flex credential-wrapper">
                <!-- CONTENT -->
                <div class="tab-content flex-grow-1 position-relative">
                    <!-- Toggle Button -->
                    <button id="toggleSidebarSetting" class="toggle-btn toggle-right">
                        <i class="mdi mdi-chevron-right"></i>
                    </button>

                    <div class="d-flex align-items-center justify-content-between pb-0 mb-4 pt-0 mt-0" style="border-bottom: 1px solid gray;">
                        <div class="d-flex flex-column align-items-start">
                            <h5 class="card-title mb-1 text-black">Onboard Checklist</h5>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb custom-breadcrumb">
                                    <!-- Home -->
                                    <li class="breadcrumb-item">
                                        <a href="{{ url('/dashboard') }}">
                                            <i class="mdi mdi-cog"></i> Settings
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item" aria-current="page">
                                        <a href="javascript:void(0);">HRM </a>
                                    </li>
                                    <li class="breadcrumb-item active" aria-current="page">
                                        <a href="javascript:void(0);" class="active-link">
                                            Onboard Checklist
                                        </a>
                                    </li>
                                </ol>
                            </nav>
                        </div>
                        <div class="d-flex justify-content-end align-items-center mb-2 gap-2">
                            <a href="#" class="btn btn-sm fw-bold btn-primary" data-bs-toggle="modal" data-bs-target="#kt_modal_add_Onboard">
                                <span class="me-2"><i class="mdi mdi-plus"></i></span>Add Onboard
                            </a>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="d-flex align-items-center justify-content-between mb-4 ">
                                <div>
                                    <span>Show</span>
                                    <select id="perpage" class="form-select form-select-sm w-75px"
                                        onchange="loadThemes(1)">
                                        @php $options = [5,10, 25, 100, 500]; @endphp
                                        @foreach ($options as $option)
                                            <option value="{{ $option }}" {{ $perpage == $option ? 'selected' : '' }}>
                                                {{ $option }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="d-flex align-items-center justify-content-end flex-wrap gap-2">
                                    <div class="searchBar">
                                        <input type="text" id="search_filter" class="searchQueryInput"
                                            placeholder="Search Onboarding Checklist..."
                                            value="{{ $search_filter }}"/>
                                        
                                        <div class="searchAction">
                                            <div class="d-flex align-items-center">
                                                <a href="javascript:;"  class="searchSubmit" id="searchSubmit" >
                                                    <span class="mdi mdi-magnify fs-4 fw-bold"  style="color:#ab2b22;"></span>
                                                </a>
                                                <a href="javascript:;" class="refreshBar" id="refreshSearch" >
                                                    <span class="mdi mdi-refresh fs-4 fw-bold" style="color:#ab2b22;"></span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <table
                                class="table align-middle table-row-dashed table-striped table-hover gy-0 gs-1 list_page">
                                <thead>
                                    <tr class="text-start align-top fw-bold fs-6 gs-0 bg-primary text-white">
                                        <th class="min-w-50px">S.No</th>
                                        <th class="min-w-50px">
                                            <label >Job Role </label> /
                                            <label data-bs-toggle="tooltip" data-bs-placement="bottom" title="Orientation Staging">O. Staging</label>
                                        </th>
                                        <th class="min-w-50px">
                                            <label data-bs-toggle="tooltip" data-bs-placement="bottom" title="Department">Dept </label> /
                                            <label>Entity</label>
                                        </th>
                                        <th class="min-w-50px text-center">Metrics / Checklist</th>
                                        <th class="min-w-50px">Status</th>
                                        <th class="min-w-50px text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="list-table-bodyd" class="text-black fw-semibold fs-7">
                                    <tr class="skeleton-loader" id="skeleton-loader">
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                        <td class="skeleton-cell">
                                            <div class="skeleton"></div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>1</td>
                                        <td>
                                            <label class="fw-semibold text-black fs-7 text-truncate d-block"
                                            style="max-width: 150px;" title="HR Manager">
                                            HR Manager
                                            </label>
                                            <div class="d-block">
                                            <label class="fw-semibold fs-8 text-dark">Company Introduction</label>
                                            </div>

                                        </td>
                                        <td align="start">
                                        <div class="d-flex align-items-start justify-content-center flex-column gap-1">
                                            <label class="fw-semibold fs-7  badge bg-label-slack d-block">
                                            Management
                                            </label>
                                            <label class="fw-semibold fs-8 text-dark ms-2"  data-bs-toggle="tooltip" data-bs-placement="bottom" title="Department">HR Department</label>
                                        </div>
                                        </td>
                                        <td>
                                        <div class="d-flex gap-1 justify-content-center align-items-center">
                                            <label class="badge bg-label-info fs-7 fw-bold  border border-dark" style="color: #046d85 !important"  data-bs-toggle="tooltip" data-bs-placement="bottom" title="Metrics Count">
                                            2
                                            </label>
                                            <label >|</label>
                                            <label class="badge bg-label-warning text-black fs-7 fw-bold border border-dark" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Checklist Count">
                                            1
                                            </label>
                                        </div>
                                        </td>
                                        <td>
                                        <label class="switch switch-square">
                                            <input type="checkbox" class="switch-input" checked />
                                            <span class="switch-toggle-slider">
                                            <span class="switch-on"></span>
                                            <span class="switch-off"></span>
                                            </span>
                                        </label>
                                        </td>
                                        <td>
                                            <span class="text-end">
                                                <a href="#" data-bs-toggle="modal"
                                                    data-bs-target="#kt_modal_edit_Onboard"
                                                    data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit">
                                                    <i class="mdi mdi-square-edit-outline fs-3 text-black"></i>
                                                </a>
                                                <a href="javascript:;" class="btn btn-icon btn-sm" data-bs-toggle="modal"
                                                    data-bs-target="#kt_modal_delete_Onboard"
                                                    data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                                    <i class="mdi mdi-delete-outline fs-3 text-black"></i>
                                                </a>
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>2</td>
                                        <td>
                                            <label class="fw-semibold text-black fs-7 text-truncate d-block"
                                            style="max-width: 150px;" title="HR Manager">
                                            HR Manager
                                            </label>
                                            <div class="d-block">
                                            <label class="fw-semibold fs-8 text-dark">Company Introduction</label>
                                            </div>
                                        </td>
                                        <td align="start">
                                        <div class="d-flex align-items-start justify-content-center flex-column gap-1">
                                            <label class="fw-semibold fs-7  badge bg-label-slack d-block">
                                            Business
                                            </label>
                                            <label class="fw-semibold fs-8 text-dark ms-2"  data-bs-toggle="tooltip" data-bs-placement="bottom" title="Entity">Epro</label>
                                        </div>
                                        </td>
                                        <td>
                                        <div class="d-flex gap-1 justify-content-center align-items-center">
                                            <label class="badge bg-label-info fs-7 fw-bold  border border-dark" style="color: #046d85 !important"  data-bs-toggle="tooltip" data-bs-placement="bottom" title="Metrics Count">
                                            1
                                            </label>
                                            <label >|</label>
                                            <label class="badge bg-label-warning text-black fs-7 fw-bold border border-dark" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Checklist Count">
                                            0
                                            </label>
                                        </div>
                                        </td>

                                        <td>
                                        <label class="switch switch-square">
                                            <input type="checkbox" class="switch-input" checked />
                                            <span class="switch-toggle-slider">
                                            <span class="switch-on"></span>
                                            <span class="switch-off"></span>
                                            </span>
                                        </label>
                                        </td>
                                        <td>
                                            <span class="text-end">
                                                <a href="#" data-bs-toggle="modal"
                                                    data-bs-target="#kt_modal_edit_Onboard"
                                                    data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit">
                                                    <i class="mdi mdi-square-edit-outline fs-3 text-black"></i>
                                                </a>
                                                <a href="javascript:;" class="btn btn-icon btn-sm" data-bs-toggle="modal"
                                                    data-bs-target="#kt_modal_delete_Onboard"
                                                    data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                                    <i class="mdi mdi-delete-outline fs-3 text-black"></i>
                                                </a>
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>3</td>
                                        <td>
                                            <label class="fw-semibold text-black fs-7 text-truncate d-block"
                                            style="max-width: 150px;" title="HR Manager">
                                            HR Manager
                                            </label>
                                            <div class="d-block">
                                            <label class="fw-semibold fs-8 text-dark">Company Introduction</label>
                                            </div>

                                        </td>
                                        <td align="start">
                                        <div class="d-flex align-items-start justify-content-center flex-column gap-1">
                                            <label class="fw-semibold fs-7  badge bg-label-slack d-block">
                                            Business
                                            </label>
                                            <label class="fw-semibold fs-8 text-dark ms-2"  data-bs-toggle="tooltip" data-bs-placement="bottom" title="Entity">PhDiZone</label>
                                        </div>
                                        </td>

                                        <td align="center">
                                        -
                                        </td>

                                        <td>
                                        <label class="switch switch-square">
                                            <input type="checkbox" class="switch-input" checked />
                                            <span class="switch-toggle-slider">
                                            <span class="switch-on"></span>
                                            <span class="switch-off"></span>
                                            </span>
                                        </label>
                                        </td>
                                        <td>
                                            <span class="text-end">
                                                <a href="#" data-bs-toggle="modal"
                                                    data-bs-target="#kt_modal_edit_Onboard"
                                                    data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit">
                                                    <i class="mdi mdi-square-edit-outline fs-3 text-black"></i>
                                                </a>
                                                <a href="javascript:;" class="btn btn-icon btn-sm" data-bs-toggle="modal"
                                                    data-bs-target="#kt_modal_delete_Onboard"
                                                    data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                                    <i class="mdi mdi-delete-outline fs-3 text-black"></i>
                                                </a>
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>4</td>
                                        <td>
                                            <label class="fw-semibold text-black fs-7 text-truncate d-block"
                                            style="max-width: 150px;" title="HR Manager">
                                            HR Manager
                                            </label>
                                            <div class="d-block">
                                            <label class="fw-semibold fs-8 text-dark">Company Introduction</label>
                                            </div>

                                        </td>
                                        <td align="start">
                                        <div class="d-flex align-items-start justify-content-center flex-column gap-1">
                                            <label class="fw-semibold fs-7  badge bg-label-slack d-block">
                                            Business
                                            </label>
                                            <label class="fw-semibold fs-8 text-dark ms-2"  data-bs-toggle="tooltip" data-bs-placement="bottom" title="Entity">SEO</label>
                                        </div>
                                        </td>
                                        <td>
                                        <div class="d-flex gap-1 justify-content-center align-items-center">
                                            <label class="badge bg-label-info fs-7 fw-bold  border border-dark" style="color: #046d85 !important" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Metrics Count">
                                            4
                                            </label>
                                            <label >|</label>
                                            <label class="badge bg-label-warning text-black fs-7 fw-bold border border-dark" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Checklist Count">
                                            2
                                            </label>
                                        </div>
                                        </td>

                                        <td>
                                        <label class="switch switch-square">
                                            <input type="checkbox" class="switch-input" checked />
                                            <span class="switch-toggle-slider">
                                            <span class="switch-on"></span>
                                            <span class="switch-off"></span>
                                            </span>
                                        </label>
                                        </td>
                                        <td>
                                            <span class="text-end">
                                                <a href="#" data-bs-toggle="modal"
                                                    data-bs-target="#kt_modal_edit_Onboard"
                                                    data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit">
                                                    <i class="mdi mdi-square-edit-outline fs-3 text-black"></i>
                                                </a>
                                                <a href="javascript:;" class="btn btn-icon btn-sm" data-bs-toggle="modal"
                                                    data-bs-target="#kt_modal_delete_Onboard"
                                                    data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                                    <i class="mdi mdi-delete-outline fs-3 text-black"></i>
                                                </a>
                                            </span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <table class="table align-middle table-row-dashed table-striped table-hover gy-0 gs-1 list_page">
                            <thead>
                              
                            </thead>
                            <tbody class="text-black fw-semibold fs-7">
                              
                            </tbody>
                          </table>
                        </div>
                        <div class="text-center my-3" id="pagination-container">
                            <!-- Pagination buttons will appear here -->
                        </div>
                    </div>
                </div>
                <!-- SIDEBAR -->
                <div id="tabSidebarSetting" class="tab-sidebar expanded right nav-align-sideright">
                    <ul class="nav nav-tabs flex-column" role="tablist">
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/document') }}" class="nav-link "  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Documents</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Documents"><i class="fa-solid fa-folder-open  fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/document_checklist') }}" class="nav-link"  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Document Checklist</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Document Checklist"><i class="fa-solid fa-list-check  fs-3"></i></span>
                                </label>
                                
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/onboarding_staging') }}" class="nav-link "  role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Onboard Staging</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Onboard Staging"><i class="mdi mdi-calendar-account-outline fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/questionnaire') }}" class="nav-link" role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">HR Questions</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="HR Questions"><i class="mdi mdi-file-question-outline fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/onboarding_question') }}" class="nav-link" role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Onboarding Questions</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Onboarding Questions"><i class="mdi mdi-file-edit fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/metrics') }}" class="nav-link " role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text"> Metrics</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title=" Metrics"><i class="mdi mdi-pen-plus fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        <li class="nav-item px-1">
                            <a href="{{ url('/settings/onboarding') }}" class="nav-link active" role="tab">
                                <label class="fs-6 right_nav">
                                    <span class="tab-text">Onboard Checklist</span>
                                    <span class="tab-icon" data-bs-toggle="tooltip" data-bs-placement="right" title="Onboard Checklist"><i class="mdi mdi-account-plus fs-3"></i></span>
                                </label>
                            </a>
                        </li>
                        
                      
                        
                    </ul>
                </div>
            </div>
            
        </div>
    </div>


    <!--begin::Modal - Delete Onboard-->
    <div class="modal fade" id="kt_modal_delete_Onboard" tabindex="-1" aria-hidden="true"
        data-bs-keyboard="false" data-bs-backdrop="static">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-m">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <div class="swal2-icon swal2-danger swal2-icon-show" style="display: flex;">
                    <!-- <div class="swal2-icon-content"><i class="mdi mdi-trash fs-2 text-danger"></i></div> -->
                    <div>
                        <i class="fa-solid fa-trash text-danger" style="font-size: 35px;"></i>
                    </div>
                </div>
                <div class="swal2-html-container mb-4" id="swal2-html-container" style="display: block;">
                    <span id="delete_message">Are you sure you want to delete <br><b class="text-danger">Management</b>
                        ?</span>
                </div>
                <div class="d-flex justify-content-center align-items-center pt-8 mb-4">
                    <button type="submit" class="btn btn-danger me-3" data-bs-dismiss="modal">Yes,
                        delete!</button>
                    <button type="reset" class="btn btn-secondary text-black" data-bs-dismiss="modal">No,cancel</button>
                </div>
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - Delete Onboard-->

    <!--begin::Modal - Add Onboard -->
    <div class="modal fade" id="kt_modal_add_Onboard" tabindex="-1" aria-hidden="true" data-bs-keyboard="false"
        data-bs-backdrop="static" data-bs-focus="false">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-lg">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div
                    class="modal-header d-flex align-items-center justify-content-between border border-bottom-1 pb-0 mb-4">
                    <div class="text-center mt-4">
                        <h3 class="text-center text-black">Create Onboard Checklist</h3>
                    </div>
                    <!--begin::Close-->
                    <div class="btn btn-sm btn-icon btn-active-color-primary rounded" style="border: 2px solid #000;" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="#000" xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="#000" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="#000" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                    </div>
                    <!--end::Close-->
                </div>
                <!--end::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body pt-0 pb-10 px-10 px-xl-20">
                    <!--begin::Heading-->
                    <div class="row">

                         <div class="col-lg-12 mb-3">
                            <div class="form-check form-check-inline mb-3">
                                <label class="form-check-label" for="management">
                                    <input class="form-check-input required-field" type="radio" name="companyTypeAdd"
                                        id="management" value="1" checked/>
                                    Management
                                </label>
                            </div>
                            <div class="form-check form-check-inline mb-3">
                                <label class="form-check-label" for="business">
                                    <input class="form-check-input required-field" type="radio" name="companyTypeAdd"
                                        id="business" value="2" />
                                    Business
                                </label>
                            </div>
                        </div>


                        <div class="col-lg-6 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold management_field">Department<span class="text-danger">*</span></label>
                            <select id="DepartmentAdd" class="select3 form-select">
                                <option value="">Select Department</option>
                                <option value="1">Department 1</option>
                                <option value="2">Department 2</option>
                            </select>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold management_field">Job Role<span class="text-danger">*</span></label>
                            <select id="JobAddM" class="select3 form-select">
                                <option value="">Select Job Role</option>
                                <option value="1">Job Role 1</option>
                                <option value="2">Job Role 2</option>
                            </select>
                        </div>



                        <div class="col-lg-6 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold business_field">Company<span class="text-danger">*</span></label>
                            <select id="CompanyeAdd" class="select3 form-select">
                                <option value="">Select Company</option>
                                <option value="1">Company 1</option>
                                <option value="2">Company 2</option>
                            </select>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold business_field">Entity<span class="text-danger">*</span></label>
                            <select id="EntityAdd" class="select3 form-select">
                                <option value="">Select Entity</option>
                                <option value="1">Entity 1</option>
                                <option value="2">Entity 2</option>
                            </select>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold business_field">Job Role<span class="text-danger">*</span></label>
                            <select id="JobAddB" class="select3 form-select">
                                <option value="">Select Job Role</option>
                                <option value="1">Job Role 1</option>
                                <option value="2">Job Role 2</option>
                            </select>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold ">Orientation Staging<span class="text-danger">*</span></label>
                            <select id="OrientationAdd" class="select3 form-select">
                                <option value="">Select Orientation Staging</option>
                                <option value="1">Orientation Staging 1</option>
                                <option value="2">Orientation Staging 2</option>
                            </select>
                        </div>
                        <div class="col-lg-6 mb-4">
                            <label class="fw-semibold mb-1 text-black">
                                <input  class="form-check-input me-2 metric_checkbox" type="checkbox" />
                                Metrics
                            </label>
                        </div>
                        <div class="col-lg-12 mb-2 metric_div" style="display:none;">
                            <label class="text-black fw-semibold fs-6"><u>Metrics List</u></label>
                        </div>
                        <div class="col-lg-12  mb-2 scroll-y max-h-200px metric_div" style="display:none;">
                          <div class="row">
                            <div class="col-lg-6 mb-4">
                                <label class="fw-semibold mb-1 text-black">
                                    <input class="form-check-input me-2" type="checkbox" />Culture Score
                                </label>
                            </div>
                            <div class="col-lg-6 mb-4">
                                <label class="fw-semibold mb-1 text-black">
                                    <input class="form-check-input me-2" type="checkbox" />First Impression
                                </label>
                            </div>
                            <div class="col-lg-6 mb-4">
                                <label class="fw-semibold mb-1 text-black">
                                    <input class="form-check-input me-2" type="checkbox" />On-Time Presence
                                </label>
                            </div>
                            <div class="col-lg-6 mb-4">
                                <label class="fw-semibold mb-1 text-black">
                                    <input class="form-check-input me-2" type="checkbox" />Knowledge
                                </label>
                            </div>
                          </div>
                        </div>
                        <div class="col-lg-12 scroll-y max-h-200px ">
                              <div id="checklist-wrapper" >
                                  <div class="checklist-row  bg-gray-200 rounded px-2 py-2 mb-2">
                                      <div class="row">
                                          {{-- <div class="d-flex align-items-end mb-2 justify-content-end">
                                              <a href="javascript:;" class="btn btn-outline-danger px-2 py-1 checklist_del"
                                                  style="display: none !important;">
                                                  <i class="fa-solid fa-xmark fs-4"></i>
                                              </a>
                                          </div> --}}
                                          <div class="col-lg-11 mb-3">
                                              <label class="text-black mb-1 fs-6 fw-semibold">Checklist<span
                                                      class="text-danger">*</span></label>
                                              <input type="text" class="form-control" id="contact_person_name" name="contact_person_name"
                                                  placeholder="Enter Checklist"
                                                  oninput="this.value = this.value.replace(/^\w/, function(txt) { return txt.toUpperCase(); });" />
                                          </div>
                                          <div class="col-lg-1 d-flex align-items-center mt-2 justify-content-center">
                                              <div class="d-flex align-items-end mb-2 justify-content-end">
                                                  <a href="javascript:;" class="btn text-danger px-2 py-1 checklist_del"
                                                      style="display: none !important;">
                                                      <i class="fa-solid fa-trash-can fs-4"></i>
                                                  </a>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                        </div>
                        <div class="mb-1 d-flex align-items-center justify-content-end">
                            <button type="button" class="btn btn-primary" id="add-altmobile-btn">
                                <i class="mdi mdi-plus me-1"></i>Add More
                            </button>
                        </div>

                    </div>
                    <div class="d-flex justify-content-between align-items-center mt-4">
                        <button type="reset" class="btn btn-outline-danger text-primary me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" id="create_sms_btn" class="btn btn-primary"
                            data-bs-dismiss="modal">Create
                            Onboard Checklist</button>
                    </div>
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - Add Onboard-->

    <!--begin::Modal - Edit Onboard -->
    <div class="modal fade" id="kt_modal_edit_Onboard" tabindex="-1" aria-hidden="true" data-bs-keyboard="false"
        data-bs-backdrop="static" data-bs-focus="false">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-lg">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div
                    class="modal-header d-flex align-items-center justify-content-between border border-bottom-1 pb-0 mb-4">
                    <div class="text-center mt-4">
                        <h3 class="text-center text-black">Update Onboard Checklist</h3>
                    </div>
                    <!--begin::Close-->
                    <div class="btn btn-sm btn-icon btn-active-color-primary rounded" style="border: 2px solid #000;" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="#000" xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="#000" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="#000" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                    </div>
                    <!--end::Close-->
                </div>
                <!--end::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body pt-0 pb-10 px-10 px-xl-20">
                    <!--begin::Heading-->
                    <div class="row">

                         <div class="col-lg-12 mb-3">
                            <div class="form-check form-check-inline mb-3">
                                <label class="form-check-label" for="management">
                                    <input class="form-check-input required-field" type="radio" name="companyTypeEdit"
                                        id="managementEdit" value="1" checked />
                                    Management
                                </label>
                            </div>
                            <div class="form-check form-check-inline mb-3">
                                <label class="form-check-label" for="business">
                                    <input class="form-check-input required-field" type="radio" name="companyTypeEdit"
                                        id="businessEdit" value="2" />
                                    Business
                                </label>
                            </div>
                        </div>


                        <div class="col-lg-6 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold management_fieldEdit">Department<span class="text-danger">*</span></label>
                            <select id="DepartmentEdit" class="select3 form-select">
                                <option value="">Select Department</option>
                                <option value="1"selected>Department 1</option>
                                <option value="2">Department 2</option>
                            </select>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold management_fieldEdit">Job Role<span class="text-danger">*</span></label>
                            <select id="JobEditM" class="select3 form-select">
                                <option value="">Select Job Role</option>
                                <option value="1"selected>Job Role 1</option>
                                <option value="2">Job Role 2</option>
                            </select>
                        </div>



                        <div class="col-lg-6 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold business_fieldEdit">Company<span class="text-danger">*</span></label>
                            <select id="CompanyeEdit" class="select3 form-select">
                                <option value="">Select Company</option>
                                <option value="1">Company 1</option>
                                <option value="2">Company 2</option>
                            </select>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold business_fieldEdit">Entity<span class="text-danger">*</span></label>
                            <select id="EntityEdit" class="select3 form-select">
                                <option value="">Select Entity</option>
                                <option value="1">Entity 1</option>
                                <option value="2">Entity 2</option>
                            </select>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold business_fieldEdit">Job Role<span class="text-danger">*</span></label>
                            <select id="JobEditB" class="select3 form-select">
                                <option value="">Select Job Role</option>
                                <option value="1">Job Role 1</option>
                                <option value="2">Job Role 2</option>
                            </select>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold">Orientation Staging<span class="text-danger">*</span></label>
                            <select id="OrientationEdit" class="select3 form-select">
                                <option value="">Select Orientation Staging</option>
                                <option value="1" selected>Orientation Staging 1</option>
                                <option value="2">Orientation Staging 2</option>
                            </select>
                        </div>
                        <div class="col-lg-6 mb-4">
                            <label class="fw-semibold mb-1 text-black">
                                <input  class="form-check-input me-2 metric_checkbox" type="checkbox" checked/>
                                Metrics
                            </label>
                        </div>
                        <div class="col-lg-12 mb-2 metric_div">
                            <label class="text-black fw-semibold fs-6"><u>Metrics List</u></label>
                        </div>
                        <div class="col-lg-12 mb-2 scroll-y max-h-200px metric_div">
                          <div class="row">
                            <div class="col-lg-6 mb-4">
                                <label class="fw-semibold mb-1 text-black">
                                    <input class="form-check-input me-2" type="checkbox" checked/>Culture Score
                                </label>
                            </div>
                            <div class="col-lg-6 mb-4">
                                <label class="fw-semibold mb-1 text-black">
                                    <input class="form-check-input me-2" type="checkbox" checked/>First Impression
                                </label>
                            </div>
                            <div class="col-lg-6 mb-4">
                                <label class="fw-semibold mb-1 text-black">
                                    <input class="form-check-input me-2" type="checkbox" />On-Time Presence
                                </label>
                            </div>
                            <div class="col-lg-6 mb-4">
                                <label class="fw-semibold mb-1 text-black">
                                    <input class="form-check-input me-2" type="checkbox" />Knowledge
                                </label>
                            </div>
                          </div>
                        </div>
                        <div class="col-lg-12 scroll-y max-h-200px ">
                              <div id="checklist-wrapperEdit" >
                                  <div class="checklist-rowEdit  bg-gray-200 rounded px-2 py-2 mb-2">
                                      <div class="row">
                                          {{-- <div class="d-flex align-items-end mb-2 justify-content-end">
                                              <a href="javascript:;" class="btn btn-outline-danger px-2 py-1 checklist_del"
                                                  style="display: none !important;">
                                                  <i class="fa-solid fa-xmark fs-4"></i>
                                              </a>
                                          </div> --}}
                                          <div class="col-lg-11 mb-3">
                                              <label class="text-black mb-1 fs-6 fw-semibold">Checklist<span
                                                      class="text-danger">*</span></label>
                                              <input type="text" class="form-control" id="contact_person_name" name="contact_person_name"
                                                  placeholder="Enter Checklist"
                                                  oninput="this.value = this.value.replace(/^\w/, function(txt) { return txt.toUpperCase(); });" value="Checklist"/>
                                          </div>
                                          <div class="col-lg-1 d-flex align-items-center mt-2 justify-content-center">
                                              <div class="d-flex align-items-end mb-2 justify-content-end">
                                                  <a href="javascript:;" class="btn text-danger px-2 py-1 checklist_delEdit"
                                                      style="display: none !important;">
                                                      <i class="fa-solid fa-trash-can fs-4"></i>
                                                  </a>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                        </div>
                        <div class="mb-1 d-flex align-items-center justify-content-end">
                            <button type="button" class="btn btn-primary" id="Edit-altmobile-btnEdit">
                                <i class="mdi mdi-plus me-1"></i>Add More
                            </button>
                        </div>

                    </div>
                    <div class="d-flex justify-content-between align-items-center mt-4">
                        <button type="reset" class="btn btn-outline-danger text-primary me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" id="create_sms_btn" class="btn btn-primary"
                            data-bs-dismiss="modal">Update
                            Onboard Checklist</button>
                    </div>
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - Edit Onboard-->




    <!-- Logo File Upload Start -->
    <!-- jQuery from CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Toastr CSS from CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <!-- Toastr JavaScript from CDN -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <style>
        /* Customize Toastr notification */
        .toast-success {
            background-color: green;
        }

        /* Customize Toastr notification */
        .toast-error {
            background-color: red;
        }
    </style>




<script>
$(document).ready(function() {
    $('#InputTypeedit').select2({ width: '100%' });

    $('#InputTypeedit').on('change', function() {
        var value = $(this).val();
        if(value === 'number') {
            $('#number-field-container_edit').removeClass('d-none');
        } else {
            $('#number-field-container_edit').addClass('d-none');
        }
    });
});
</script>

<script>
$(document).ready(function() {

  // ---------- ADD FORM ----------
  function toggleAddFields() {
    if ($('#management').is(':checked')) {
      $('.management_field').closest('.col-lg-6').show();
      $('.business_field').closest('.col-lg-6').hide();
    } else if ($('#business').is(':checked')) {
      $('.business_field').closest('.col-lg-6').show();
      $('.management_field').closest('.col-lg-6').hide();
    }
  }

  toggleAddFields(); // Run on load
  $('input[name="companyTypeAdd"]').change(toggleAddFields); // Run on change

  // ---------- EDIT FORM ----------
  function toggleEditFields() {
    if ($('#managementEdit').is(':checked')) {
      $('.management_fieldEdit').closest('.col-lg-6').show();
      $('.business_fieldEdit').closest('.col-lg-6').hide();
    } else if ($('#businessEdit').is(':checked')) {
      $('.business_fieldEdit').closest('.col-lg-6').show();
      $('.management_fieldEdit').closest('.col-lg-6').hide();
    }
  }

  toggleEditFields(); // Run on load
  $('input[name="companyTypeEdit"]').change(toggleEditFields); // Run on change
});
</script>
<script>
    $(document).ready(function() {
        $('.metric_checkbox').change(function() {
            if ($(this).is(':checked')) {
                $('.metric_div').slideDown(); // show with animation
            } else {
                $('.metric_div').slideUp(); // hide with animation
            }
        });
    });
</script>

<script>
    $(document).ready(function() {

        // Function to update labels dynamically
        function updateContactLabels() {
            $("#checklist-wrapper .checklist-row").each(function(index) {
                const personLabel = $(this).find('label[for="contact_person_name"]');
                const mobileLabel = $(this).find('label[for="contact_person_no"]');

                if (index === 0) {
                    personLabel.text("Contact Person");
                    mobileLabel.text("Contact Person Mobile Number");
                    $(this).find('.checklist_del').hide(); // hide delete for first
                } else {
                    personLabel.text("Contact Person " + (index + 1));
                    mobileLabel.text("Contact Person " + (index + 1) + " Mobile Number");
                    $(this).find('.checklist_del').show(); // show delete for added rows
                }
            });
        }

        // Add new contact row
        $("#add-altmobile-btn").click(function() {
            const clone = $(".checklist-row:first").clone(); // clone first row

            // Clear input values
            clone.find("input").val("");

            // Ensure delete button visible
            clone.find(".checklist_del").show();

            // Append cloned row
            $("#checklist-wrapper").append(clone);

            // Update labels
            updateContactLabels();
        });

        // Delete a contact row
        $(document).on("click", ".checklist_del", function() {
            $(this).closest(".checklist-row").remove();
            updateContactLabels(); // re-label after deletion
        });

        // Initial label setup
        updateContactLabels();
    });
</script>



<script>
    $(document).ready(function() {

        // Function to update labels dynamically
        function updateContactLabels() {
            $("#checklist-wrapperEdit .checklist-rowEdit").each(function(index) {
                const personLabel = $(this).find('label[for="contact_person_name"]');
                const mobileLabel = $(this).find('label[for="contact_person_no"]');

                if (index === 0) {
                    personLabel.text("Contact Person");
                    mobileLabel.text("Contact Person Mobile Number");
                    $(this).find('.checklist_delEdit').hide(); // hide delete for first
                } else {
                    personLabel.text("Contact Person " + (index + 1));
                    mobileLabel.text("Contact Person " + (index + 1) + " Mobile Number");
                    $(this).find('.checklist_delEdit').show(); // show delete for added rows
                }
            });
        }

        // Add new contact row
        $("#Edit-altmobile-btnEdit").click(function() {
            const clone = $(".checklist-rowEdit:first").clone(); // clone first row

            // Clear input values
            clone.find("input").val("");

            // Ensure delete button visible
            clone.find(".checklist_delEdit").show();

            // Append cloned row
            $("#checklist-wrapperEdit").append(clone);

            // Update labels
            updateContactLabels();
        });

        // Delete a contact row
        $(document).on("click", ".checklist_delEdit", function() {
            $(this).closest(".checklist-rowEdit").remove();
            updateContactLabels(); // re-label after deletion
        });

        // Initial label setup
        updateContactLabels();
    });
</script>
@endsection
