@extends('layouts/layoutMaster')
@section('style')
@section('title', 'Feedback Question Add')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/select2/select2.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
    @vite(['resources/assets/vendor/libs/select2/select2.js'])
@endsection

@section('content')

    <!-- Users List Table -->
    <div class="card">
        <div class="card-body px-1 py-1">
            <div class="nav-align-right nav-tabs-shadow">

                <div class="tab-content">
                    <div class="d-flex align-items-center justify-content-between pb-0 mb-4 pt-0 mt-0" style="border-bottom: 1px solid gray;">
                        <div class="d-flex flex-column align-items-start">
                            <h5 class="card-title mb-1 text-black">Feedback Question</h5>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb custom-breadcrumb">
                                    <!-- Home -->
                                    <li class="breadcrumb-item">
                                        <a href="{{ url('/dashboard') }}">
                                            <i class="mdi mdi-cog"></i> Settings
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item" aria-current="page">
                                        <a href="javascript:void(0);">Interview</a>
                                    </li>
                                    <li class="breadcrumb-item active" aria-current="page">
                                        <a href="javascript:void(0);" class="active-link">
                                            Feedback Question
                                        </a>
                                    </li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                    <form id="add_customer_type_option_form" action="{{ route('add_feedback_question') }}" method="POST" >
                        @csrf
                    <div class="row">
                        <div class="col-lg-4 mb-3 ">
                            <label class="text-black mb-1 fs-6 fw-semibold">Feedback Section<span
                                    class="text-danger">*</span></label>
                            <select id="section_id" name="section_id" class="select3 form-select required-field">
                                <option value="">Select Section</option>
                                    @if(isset($sectionList))
                                    @foreach($sectionList as $clist)
                                    <option value="{{$clist->sno}}">{{$clist->section_name}}</option>
                                    @endforeach
                                    @endif
                            </select>
                              <div class="text-danger error_msg" id="section_id_err"></div>
                        </div>
                         <div class="col-lg-4 mb-3" id="interview_category_div" style="display:none;">
                            <label class="text-black mb-1 fs-6 fw-semibold">Interview Category<span
                                    class="text-danger">*</span></label>
                            <select id="interview_category_id" name="interview_category_id" class="select3 form-select required-field">
                                <option value="">Select Interview Category</option>
                                    @if(isset($interviewCategoryList))
                                        @foreach($interviewCategoryList as $ilist)
                                            <option value="{{$ilist->sno}}">{{$ilist->interview_category_name}}</option>
                                        @endforeach
                                    @endif
                            </select>
                            <div class="text-danger error_msg" id="interview_category_id_err"></div>
                        </div>
                        <div class="col-lg-4 mb-3">
                            <label class="text-black mb-1 fs-6 fw-semibold">Language<span class="text-danger">*</span></label>
                            <div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="language" id="language_english"
                                        value="15" checked />
                                    <label class="form-check-label" for="language_english">English</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="language" id="language_tamil"
                                        value="79" />
                                    <label class="form-check-label" for="language_tamil">Tamil</label>
                                </div>
                            </div>
                        </div>
                       
                     
                    </div>
                    <div class="row">
                        <div id="questions_container">
                        </div>
                        <div class="mb-1 mt-1">
                            <button type="button" class="btn btn-primary" id="add_Question">
                                <i class="mdi mdi-plus me-1"></i>
                            </button>
                        </div>

                        <div class="d-flex justify-content-between align-items-center mt-4">
                            <a href="{{url('/settings/interview_question')}}" class="btn btn-outline-danger text-primary fw-bold waves-effect">Cancel</a>
                            <button type="button" class="btn btn-primary" id="saveQuestions" onclick="AddvalidateForm()">Create Question</button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>




    <!-- Logo File Upload Start -->
    <!-- jQuery from CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Toastr CSS from CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <!-- Toastr JavaScript from CDN -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <style>
        /* Customize Toastr notification */
        .toast-success {
            background-color: green;
        }

        /* Customize Toastr notification */
        .toast-error {
            background-color: red;
        }
    </style>



<!-- Label Value Function Start -->
<script>
    function payment_mode_option_label_func() {
        var payment_mode_option_label_value = document.getElementById("payment_mode_option_label_value").value;
        var payment_mode_option_check_box = document.getElementById("payment_mode_option_check_box");
        var payment_mode_option_radio_button = document.getElementById("payment_mode_option_radio_button");
        var payment_mode_option_list_box = document.getElementById("payment_mode_option_list_box");

        if (payment_mode_option_label_value == "check_box") {
            payment_mode_option_check_box.style.display = "block";
            payment_mode_option_radio_button.style.display = "none";
            payment_mode_option_list_box.style.display = "none";
        } else if (payment_mode_option_label_value == "radio_button") {
            payment_mode_option_check_box.style.display = "none";
            payment_mode_option_radio_button.style.display = "block";
            payment_mode_option_list_box.style.display = "none";
        } else if (payment_mode_option_label_value == "list_box") {
            payment_mode_option_check_box.style.display = "none";
            payment_mode_option_radio_button.style.display = "none";
            payment_mode_option_list_box.style.display = "block";
        } else {
            payment_mode_option_check_box.style.display = "none";
            payment_mode_option_radio_button.style.display = "none";
            payment_mode_option_list_box.style.display = "none";
        }
    }
</script>


<script>
function createQuestionBlock(isDefault = false) {
    // Delete button only for non-default blocks
    var deleteButtonHTML = isDefault ? '' : `
        <div class="col-lg-1">
            <a href="javascript:;" class="btn btn-outline-danger mt-4 px-1 py-2 del-question">
                <i class="mdi mdi-delete fs-4"></i>
            </a>
        </div>
    `;

    var block = `
    <div class="altmobile-row rounded mb-3">
       <div class="payment_mode_question_block px-2 py-2">
            <div class="row my-2">
              <div class="col-lg-11">
                  <div class="row">
                      <div class="col-lg-12 mb-3">
                          <label class="text-dark mb-1 fs-6 fw-semibold">Question Name<span class="text-danger">*</span></label>
                          <input type="text" class="form-control label-name" name="label_names[]" placeholder="Enter Question Name" />
                         
                      </div>
                      <div class="col-lg-4 mb-3">
                          <label class="text-dark mb-1 fs-6 fw-semibold">Input Value<span class="text-danger">*</span></label>
                          <select class="select3 form-select input-value-select" name="label_values[]" data-bs-parent="#questions_container">
                              <option>Select Input Value</option>
                              <option value="text_field">Text Field</option>
                              <option value="check_box">Check Box</option>
                              <option value="radio_button">Radio Button</option>
                              <option value="list_box">List Box</option>
                          </select>
                         
                      </div>

                      <div class="col-lg-6 mb-3 mt-3 option-blocks"></div>


                  </div>
              </div>
              ${deleteButtonHTML}
          </div>
          <hr class="bg-light m-1">
        </div>
    </div>
    `;
    return block;
}

// Add default block on page load
$(document).ready(function(){
    var $firstBlock = $(createQuestionBlock(true));
    $('#questions_container').append($firstBlock);
    initializeBlock($firstBlock);
});

// Add new question block
$('#add_Question').on('click', function() {
    var $block = $(createQuestionBlock(false));
    $('#questions_container').append($block);
    initializeBlock($block);
});

// Initialize block behavior
function initializeBlock($block){
    $block.find('.select3').select2({width: '100%'});
    handleInputValueChange($block);

    // Delete question block
    $block.find('.del-question').on('click', function() {
        $block.remove();
    });

   
}

// Handle Input Value (Main Section)
function handleInputValueChange($block) {
    $block.find('.input-value-select').on('change', function() {
        var value = $(this).val();
        var $container = $block.find('.option-blocks');
        $container.empty();

        if(value === 'check_box' || value === 'radio_button' || value === 'list_box') {
            var type = value;
            var uniqueId = 'accordion-' + type + '-' + new Date().getTime();
            var typeText = type.replace('_',' ');
            typeText = typeText.charAt(0).toUpperCase() + typeText.slice(1);

            var html = `
            <div class="accordion">
              <div class="accordion-item mb-2">
                <h2 class="accordion-header">
                  <button type="button" class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#${uniqueId}"> ${typeText} </button>
                </h2>
                <div id="${uniqueId}" class="accordion-collapse collapse">
                  <div class="accordion-body px-2">
                    <div class="scroll-y max-h-200px ${type}-container p-3" style="overflow-x: hidden;">
                      <div class="option-item row mb-2">
                        <div class="col-lg-10">
                          <label class="text-dark mb-1 fs-6 fw-semibold">Option 1 <span class="text-danger">*</span></label>
                          <textarea class="form-control" rows="1" placeholder="Enter Option 1"></textarea>
                        </div>
                        <div class="col-lg-2 d-flex justify-content-center align-items-center mb-1"></div>
                      </div>
                    </div>
                    <div class="mb-1 mt-1">
                      <button type="button" class="btn btn-primary mt-2 add-option-btn">Add Option</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>`;
            $container.append(html);

            $container.find('.add-option-btn').on('click', function(e){
                e.preventDefault();
                var $optionsContainer = $container.find(`.${type}-container`);
                var nextNum = $optionsContainer.find('.option-item').length + 1;
                var $newRow = $(`
                    <div class="option-item row mb-2">
                      <div class="col-lg-10">
                        <label class="text-dark mb-1 fs-6 fw-semibold">Option ${nextNum} <span class="text-danger">*</span></label>
                        <textarea class="form-control" rows="1" placeholder="Enter Option ${nextNum}"></textarea>
                      </div>
                      <div class="col-lg-2 d-flex justify-content-start align-items-end mb-1">
                        <div>
                          <a href="javascript:;" class="btn btn-outline-danger delete-option w-100 h-100 d-flex justify-content-center align-items-center p-1">
                            <i class="mdi mdi-delete fs-4"></i>
                          </a>
                        </div>
                      </div>
                    </div>
                `);
                $optionsContainer.append($newRow);

                $newRow.find('.delete-option').on('click', function() {
                    $newRow.remove();
                    updateOptionNumbers($optionsContainer);
                    updateDependsSelect($block);
                });

                $newRow.find('textarea').on('input', function() {
                    updateDependsSelect($block);
                });

                updateDependsSelect($block);
            });

            $container.find('textarea').on('input', function() {
                updateDependsSelect($block);
            });
            updateDependsSelect($block);
        }
    });
}

// Update depends select based on main options only
function updateDependsSelect($block) {
    var $dependsSelect = $block.find('.depends-select');
    $dependsSelect.empty().append('<option value="">Select Label</option>');
    $block.find('.option-blocks textarea').each(function(){
        var val = $(this).val().trim();
        if(val) $dependsSelect.append(`<option value="${val}">${val}</option>`);
    });
}

// Update numbering for main options
function updateOptionNumbers($optionsContainer){
    $optionsContainer.find('.option-item').each(function(index){
        $(this).find('label').html(`Option ${index+1} <span class="text-danger">*</span>`);
        $(this).find('textarea').attr('placeholder', `Enter Option ${index+1}`);
    });
}

// Update numbering for depends local options
function updateDepOptionNumbers($container){
    $container.find('.option-item').each(function(index){
        $(this).find('label').html(`Option ${index+1} <span class="text-danger">*</span>`);
        $(this).find('textarea').attr('placeholder', `Enter Option ${index+1}`);
    });
}
</script>
<script>
    function AddvalidateForm() {
        const $form = $('#add_customer_type_option_form');
        const $blocks = $('#questions_container .payment_mode_question_block');
        let isValid = true;

        // Reset old validation
        $form.find('.is-invalid').removeClass('is-invalid');
        $form.find('.invalid-feedback-dynamic').remove();
        
        var interview_category_id =$('#interview_category_id').val();
        $('#interview_category_id_err').text('');
       
        var section_id =$('#section_id').val();
        $('#section_id_err').text('');
        if (section_id == '') {
            $('#section_id_err').text('Section is Required!');
            isValid = false;
        }

        if(section_id == 1){
             if (!interview_category_id) {
                $('#interview_category_id_err').text('Interview Category is Required!');
                isValid = false;
            }
        }
       

        // Validate each question block
        $blocks.each(function(index) {
            const $block = $(this);
            const $labelName = $block.find('.label-name');
            const $inputValue = $block.find('.input-value-select');
            const labelName = $labelName.val()?.trim();
            const inputValue = $inputValue.val();

            // ---- Question Name ----
            if (!labelName) {
                showError($labelName, "Question Name is required.");
                isValid = false;
            }

            // ---- Input Value ----
            if (!inputValue || inputValue === "Select Input Value") {
                showError($inputValue.next('.select2'), "Please select an Input Value.");
                isValid = false;
            }

            // ---- Option Validation ----
            if (['check_box', 'radio_button', 'list_box'].includes(inputValue)) {
                const $options = $block.find('.option-blocks textarea');
                if ($options.length === 0) {
                    showError($block.find('.option-blocks'), "Option is required.");
                    isValid = false;
                } else {
                    $options.each(function() {
                        if (!$(this).val().trim()) {
                            showError($(this), "Option is required.");
                            isValid = false;
                        }
                    });
                }
            }

            
        });

        // Scroll to first invalid field
        if (!isValid) {
            $('html, body').animate({
                scrollTop: $('.is-invalid').first().offset().top - 120
            }, 400);
            return false;
        }

        serializeQuestions($form);
    }

    // Helper: Show inline validation message
    function showError($el, message) {
        $el.addClass('is-invalid');
        if ($el.next('.invalid-feedback-dynamic').length === 0) {
            $(`<div class="invalid-feedback invalid-feedback-dynamic">${message}</div>`).insertAfter($el);
        }

        // Remove error dynamically when corrected
        $el.on('input change', function() {
            if ($(this).val()?.trim()) {
                $(this).removeClass('is-invalid');
                $(this).next('.invalid-feedback-dynamic').remove();
            }
        });
    }

    // Serialize questions into hidden inputs
    function serializeQuestions($form) {

        $form.find('input[type="hidden"]').not('[name="_token"]').remove();

        // Ensure CSRF token exists
        if ($form.find('input[name="_token"]').length === 0) {
            $('<input>', {
                type: 'hidden',
                name: '_token',
                value: '{{ csrf_token() }}'
            }).appendTo($form);
        }

        const questionsData = [];
        $('#questions_container .payment_mode_question_block').each(function() {
            const $block = $(this);
            const q = {
                label_name: $block.find('.label-name').val()?.trim() || '',
                label_value: $block.find('.input-value-select').val() || '',
                options: [],
            };

            // Collect options
            $block.find('.option-blocks textarea').each(function() {
                const opt = $(this).val()?.trim();
                if (opt) q.options.push({ label: opt });
            });

        

            questionsData.push(q);
        });

        // Convert questions to hidden inputs
        questionsData.forEach((q, i) => {
            $('<input>', { type: 'hidden', name: `label_names[${i}]`, value: q.label_name }).appendTo($form);
            $('<input>', { type: 'hidden', name: `label_values[${i}]`, value: q.label_value }).appendTo($form);
            

            q.options.forEach((opt, j) => {
                $('<input>', { type: 'hidden', name: `options[${i}][${j}][label]`, value: opt.label }).appendTo($form);
            });
            
        });

        $form.get(0).submit();
    }
</script>

<script>
    $(document).ready(function() {
        $('#section_id').on('change', function() {
            var section_id = $(this).val();
             var category= document.getElementById('interview_category_div') ;
           if(section_id == 1){
                category.style.display = 'block';
           }else{
            category.style.display = 'none';
           }

            
        });


    });
</script>

@endsection
