@extends('layouts/layoutMaster')
@section('style')
@section('title', 'Experience')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/select2/select2.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
    @vite(['resources/assets/vendor/libs/select2/select2.js'])
@endsection

@section('content')

    <!-- Users List Table -->
    <div class="card">
        <div class="card-header pb-1">
            <ul class="nav nav-tabs flex-nowrap" role="tablist">
                <div class="scroll-container-wrapper">
                    <button class="scroll-btn left" id="scrollLeftBtn"><span class="scroll-arrow"><i
                                class="mdi mdi-chevron-left fs-2 text-white"></i></span></button>
                    <div class="scroll-container" id="scrollContainer">
                        <li class="item nav-item">
                            <a href="{{ url('/settings/general_settings') }}" type="button" class="nav-link scroll-link"
                                role="tab">
                                General Settings
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/broadcast_theme') }}" type="button"
                                class="nav-link scroll-link ">
                                Common
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/credential_book') }}" type="button"
                                class="nav-link scroll-link ">
                                Entity
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/document') }}" type="button"
                                class="nav-link scroll-link">
                                HRM
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/applicant_status') }}" type="button"
                                class="nav-link scroll-link active">
                                Recruitment
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/department') }}" type="button"
                                class="nav-link scroll-link ">
                                Management
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/settings/business/department') }}" type="button"
                                class="nav-link scroll-link ">
                                Business
                            </a>
                        </li>
                    </div>
                    <button class="scroll-btn right" id="scrollRightBtn" style="display: block;"><i
                            class="mdi mdi-chevron-right fs-2 text-white"></i></button>
                </div>
            </ul>
        </div>
        <div class="card-body px-1 py-1">
            <div class="nav-align-right nav-tabs-shadow pt-0 mt-0">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item">
                        <a href="{{ url('/settings/applicant_status') }}" type="button" class="nav-link " role="tab">
                            <label class="fs-6 right_nav">
                                <span><i class="mdi mdi-monitor-account me-2 fs-3"></i></span>
                                Applicant Status
                            </label>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/qualification') }}" type="button" class="nav-link" role="tab">
                            <label class="fs-6 right_nav">
                                <span><i class="mdi mdi-book-education-outline me-2 fs-3"></i></span>
                                Qualification
                            </label>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/major') }}" type="button" class="nav-link" role="tab">
                            <label class="fs-6 right_nav">
                                <span><i class="mdi mdi-school-outline me-2 fs-3"></i></span>
                                 Major
                            </label>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/experience') }}" type="button" class="nav-link active" role="tab">
                            <label class="fs-6 right_nav">
                                <span><i class="mdi mdi-head-question-outline me-2 fs-3"></i></span>
                                Experience
                            </label>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/source') }}" type="button" class="nav-link " role="tab">
                            <label class="fs-6 right_nav">
                                <span><i class="mdi mdi-vector-link me-2 fs-3"></i></span>
                                Source
                            </label>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ url('/settings/call_status') }}" type="button" class="nav-link  " role="tab">
                            <label class="fs-6 right_nav">
                                <span><i class="mdi mdi-phone-message-outline me-2 fs-3"></i></span>
                                Call Status
                            </label>
                        </a>
                    </li>
                    

                </ul>
                <div class="tab-content">
                    <div class="d-flex align-items-center justify-content-between pb-0 mb-4 pt-0 mt-0" style="border-bottom: 1px solid gray;">
                        <div class="d-flex flex-column align-items-start">
                            <h5 class="card-title mb-1 text-black">Experience</h5>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb custom-breadcrumb">
                                    <!-- Home -->
                                    <li class="breadcrumb-item">
                                        <a href="{{ url('/dashboard') }}">
                                            <i class="mdi mdi-cog"></i> Settings
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item" aria-current="page">
                                        <a href="javascript:void(0);">Common </a>
                                    </li>
                                    <li class="breadcrumb-item active" aria-current="page">
                                        <a href="javascript:void(0);" class="active-link">
                                            Experience
                                        </a>
                                    </li>
                                </ol>
                            </nav>
                        </div>
                        <div class="d-flex justify-content-end align-items-center mb-2 gap-2">
                            <a href="#" class="btn btn-sm fw-bold btn-primary" data-bs-toggle="modal"
                                data-bs-target="#kt_modal_add_Experience">
                                <span class="me-2"><i class="mdi mdi-plus"></i></span>Add Experience
                            </a>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="d-flex align-items-center justify-content-between gap-2 mb-2">
                                <div>
                                    <span>Show</span>
                                    <br>
                                    <select id="perpage" name="perpage" class="form-select form-select-sm w-60px">
                                        <option value="10">10</option>
                                        <option value="25" selected>25</option>
                                        <option value="50">50</option>
                                        <option value="100">100</option>
                                    </select>
                                </div>
                                <div class="d-flex align-items-center justify-content-end flex-wrap gap-2">
                                    <div class="searchBar">
                                        <input class="searchQueryInput" type="text" name="searchQueryInput" placeholder="Enter Experience Name" value="" />
                                        <a href="{{url('settings/Experience')}}" class="searchQuerySubmit" type="submit" name="searchQuerySubmit">
                                            <svg style="width:24px;height:24px" viewBox="0 0 24 24"><path fill="#ab2b22" d="M9.5,3A6.5,6.5 0 0,1 16,9.5C16,11.11 15.41,12.59 14.44,13.73L14.71,14H15.5L20.5,19L19,20.5L14,15.5V14.71L13.73,14.44C12.59,15.41 11.11,16 9.5,16A6.5,6.5 0 0,1 3,9.5A6.5,6.5 0 0,1 9.5,3M9.5,5C7,5 5,7 5,9.5C5,12 7,14 9.5,14C12,14 14,12 14,9.5C14,7 12,5 9.5,5Z" />
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <table
                                class="table align-middle table-row-dashed table-striped table-hover gy-0 gs-1 list_page">
                                <thead>
                                    <tr class="text-start align-top fw-bold fs-6 gs-0 bg-primary">
                                        <th class="min-w-50px">S.No</th>
                                        <th class="min-w-100px">Experience</th>
                                        <th class="min-w-50px">Status</th>
                                        <th class="min-w-50px">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <label class="fs-7 fw-medium">1</label>
                                        </td>
                                        <td>
                                            <label class="fs-7 fw-medium">Fresher</label>
                                             <a href="javascipt:;" data-bs-toggle="tooltip" data-bs-placement="right"
                                                title="-">
                                                <i class="mdi mdi mdi-help-circle text-dark"></i>
                                            </a>
                                        </td>

                                        <td>
                                            <label class="switch switch-square">
                                                <input type="checkbox" class="switch-input" checked />
                                                <span class="switch-toggle-slider">
                                                    <span class="switch-on"></span>
                                                    <span class="switch-off"></span>
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <span class="text-end">
                                                <a href="#" data-bs-toggle="modal"
                                                    data-bs-target="#kt_modal_edit_Experience" data-bs-toggle="tooltip"
                                                    data-bs-placement="bottom" title="Edit">
                                                    <i class="mdi mdi-square-edit-outline fs-3 text-black"></i>
                                                </a>
                                                <a href="javascript:;" class="btn btn-icon btn-sm"
                                                    data-bs-toggle="modal" data-bs-target="#kt_modal_delete_Experience"
                                                    data-bs-toggle="tooltip" data-bs-placement="bottom"
                                                    title="Delete">
                                                    <i class="mdi mdi-delete-outline fs-3 text-black"></i>
                                                </a>
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label class="fs-7 fw-medium">2</label>
                                        </td>
                                        <td>
                                            <label class="fs-7 fw-medium">1-2 Years</label>
                                             <a href="javascipt:;" data-bs-toggle="tooltip" data-bs-placement="right"
                                                title="-">
                                                <i class="mdi mdi mdi-help-circle text-dark"></i>
                                            </a>
                                        </td>
                                        <td>
                                            <label class="switch switch-square">
                                                <input type="checkbox" class="switch-input" checked />
                                                <span class="switch-toggle-slider">
                                                    <span class="switch-on"></span>
                                                    <span class="switch-off"></span>
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <span class="text-end">
                                                <a href="#" data-bs-toggle="modal"
                                                    data-bs-target="#kt_modal_edit_Experience" data-bs-toggle="tooltip"
                                                    data-bs-placement="bottom" title="Edit">
                                                    <i class="mdi mdi-square-edit-outline fs-3 text-black"></i>
                                                </a>
                                                <a href="javascript:;" class="btn btn-icon btn-sm"
                                                    data-bs-toggle="modal" data-bs-target="#kt_modal_delete_Experience"
                                                    data-bs-toggle="tooltip" data-bs-placement="bottom"
                                                    title="Delete">
                                                    <i class="mdi mdi-delete-outline fs-3 text-black"></i>
                                                </a>
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label class="fs-7 fw-medium">3</label>
                                        </td>
                                        <td>
                                            <label class="fs-7 fw-medium">10 and Above</label>
                                             <a href="javascipt:;" data-bs-toggle="tooltip" data-bs-placement="right"
                                                title="-">
                                                <i class="mdi mdi mdi-help-circle text-dark"></i>
                                            </a>
                                        </td>
                                        <td>
                                            <label class="switch switch-square">
                                                <input type="checkbox" class="switch-input" checked />
                                                <span class="switch-toggle-slider">
                                                    <span class="switch-on"></span>
                                                    <span class="switch-off"></span>
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <span class="text-end">
                                                <a href="#" data-bs-toggle="modal"
                                                    data-bs-target="#kt_modal_edit_Experience" data-bs-toggle="tooltip"
                                                    data-bs-placement="bottom" title="Edit">
                                                    <i class="mdi mdi-square-edit-outline fs-3 text-black"></i>
                                                </a>
                                                <a href="javascript:;" class="btn btn-icon btn-sm"
                                                    data-bs-toggle="modal" data-bs-target="#kt_modal_delete_Experience"
                                                    data-bs-toggle="tooltip" data-bs-placement="bottom"
                                                    title="Delete">
                                                    <i class="mdi mdi-delete-outline fs-3 text-black"></i>
                                                </a>
                                            </span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!--begin::Modal - Add Experience -->
    <div class="modal fade" id="kt_modal_add_Experience" tabindex="-1" aria-hidden="true" data-bs-keyboard="false"
        data-bs-backdrop="static" data-bs-focus="false">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-md">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div
                    class="modal-header d-flex align-items-center justify-content-between border border-bottom-1 pb-0 mb-4">
                    <div class="text-center mt-4">
                        <h3 class="text-center text-black">Create Experience</h3>
                    </div>
                    <!--begin::Close-->
                    <div class="btn btn-sm btn-icon btn-active-color-primary rounded" style="border: 2px solid #000;" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="#000" xmlns="http://www.w3.org/2000/svg">
                                <rect opaExperience="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="#000" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="#000" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                    </div>
                    <!--end::Close-->
                </div>
                <!--end::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body pt-0 pb-10 px-10 px-xl-20">
                    <!--begin::Heading-->

                     <div class="row">
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold"> Experience<span class="text-danger error_cls"></span></label>
                            <input type="text" class="form-control messg_cls" placeholder="Enter Experience">
                        </div>
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold">Description</label>
                            <textarea class="form-control messg_cls" rows="1" placeholder="Enter Description"></textarea>
                        </div>
                    </div>
                    <div class="d-flex justify-content-between align-items-center mt-4">
                        <button type="reset" class="btn btn-outline-danger text-primary me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" id="create_sms_btn" class="btn btn-primary"
                            data-bs-dismiss="modal">Create
                            Experience</button>
                    </div>
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - Add Experience-->


    <!--begin::Modal - Edit Experience -->
    <div class="modal fade" id="kt_modal_edit_Experience" tabindex="-1" aria-hidden="true" data-bs-keyboard="false"
        data-bs-backdrop="static" data-bs-focus="false">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-md">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div
                    class="modal-header d-flex align-items-center justify-content-between border border-bottom-1 pb-0 mb-4">
                    <div class="text-center mt-4">
                        <h3 class="text-center text-black">Update Experience</h3>
                    </div>
                    <!--begin::Close-->
                    <div class="btn btn-sm btn-icon btn-active-color-primary rounded" style="border: 2px solid #000;" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="#000" xmlns="http://www.w3.org/2000/svg">
                                <rect opaExperience="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="#000" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="#000" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                    </div>
                    <!--end::Close-->
                </div>
                <!--end::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body pt-0 pb-10 px-10 px-xl-20">
                    <!--begin::Heading-->

                    <div class="row">
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold"> Experience<span class="text-danger error_cls"></span></label>
                            <input type="text" class="form-control messg_cls" placeholder="Enter Experience" value="Fresher">
                        </div>
                        <div class="col-lg-12 mb-3">
                            <label class="text-dark mb-1 fs-6 fw-semibold">Description</label>
                            <textarea class="form-control messg_cls" rows="1" placeholder="Enter Description">-</textarea>
                        </div>
                    </div>
                    <div class="d-flex justify-content-between align-items-center mt-4">
                        <button type="reset" class="btn btn-outline-danger text-primary me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" id="create_sms_btn" class="btn btn-primary"
                            data-bs-dismiss="modal">Update Experience</button>
                    </div>
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - Edit Experience-->

    <!--begin::Modal - Delete Experience-->
    <div class="modal fade" id="kt_modal_delete_Experience" tabindex="-1" aria-hidden="true" data-bs-keyboard="false"
        data-bs-backdrop="static">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-m">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <div class="swal2-icon swal2-danger swal2-icon-show" style="display: flex;">
                    <!-- <div class="swal2-icon-content"><i class="mdi mdi-trash fs-2 text-danger"></i></div> -->
                    <div>
                        <i class="fa-solid fa-trash text-danger" style="font-size: 35px;"></i>
                    </div>
                </div>
                <div class="swal2-html-container mb-4" id="swal2-html-container" style="display: block;">
                    <span id="delete_message">Are you sure you want to delete <br><b class="text-danger">Fresher</b> from
                        Experience ?</span>
                </div>
                <div class="d-flex justify-content-center align-items-center pt-8 mb-4">
                    <button type="submit" class="btn btn-danger me-3" data-bs-dismiss="modal">Yes,
                        delete!</button>
                    <button type="reset" class="btn btn-secondary text-black" data-bs-dismiss="modal">No,cancel</button>
                </div>
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - Delete Experience-->




    <!-- Logo File Upload Start -->
    <!-- jQuery from CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Toastr CSS from CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <!-- Toastr JavaScript from CDN -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <style>
        /* Customize Toastr notification */
        .toast-success {
            background-color: green;
        }

        /* Customize Toastr notification */
        .toast-error {
            background-color: red;
        }
    </style>

@endsection
